/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import java.util.Arrays;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;
import org.xml.sax.Attributes;

public class AttributeCollectionImpl
implements Attributes,
AttributeCollection {
    private Configuration config;
    private LocationProvider locationProvider;
    private NodeName[] names = null;
    private String[] values = null;
    private long[] codes = null;
    private int used = 0;
    private SimpleType[] types = null;
    public static AttributeCollectionImpl EMPTY_ATTRIBUTE_COLLECTION = new AttributeCollectionImpl(null);

    public AttributeCollectionImpl(Configuration config) {
        this.config = config;
        this.used = 0;
    }

    public static AttributeCollectionImpl copy(AttributeCollectionImpl atts) {
        if (atts.getLength() == 0) {
            return EMPTY_ATTRIBUTE_COLLECTION;
        }
        AttributeCollectionImpl t = new AttributeCollectionImpl(atts.config);
        t.used = atts.used;
        t.locationProvider = atts.locationProvider;
        t.names = new NodeName[atts.used];
        t.values = new String[atts.used];
        t.codes = new long[atts.used];
        System.arraycopy(atts.names, 0, t.names, 0, atts.used);
        System.arraycopy(atts.values, 0, t.values, 0, atts.used);
        System.arraycopy(atts.codes, 0, t.codes, 0, atts.used);
        if (atts.types != null) {
            t.types = new SimpleType[atts.used];
            System.arraycopy(atts.types, 0, t.types, 0, atts.used);
        }
        return t;
    }

    public void setLocationProvider(LocationProvider provider) {
        this.locationProvider = provider;
    }

    public void addAttribute(NodeName nodeName, SimpleType type, String value, int locationId, int properties) {
        if (this.values == null) {
            this.names = new NodeName[5];
            this.values = new String[5];
            this.codes = new long[5];
            if (!type.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                this.types = new SimpleType[5];
            }
            this.used = 0;
        }
        if (this.values.length == this.used) {
            int newsize = this.used == 0 ? 5 : this.used * 2;
            NodeName[] n2 = new NodeName[newsize];
            String[] v2 = new String[newsize];
            long[] c2 = new long[newsize];
            System.arraycopy(this.names, 0, n2, 0, this.used);
            System.arraycopy(this.values, 0, v2, 0, this.used);
            System.arraycopy(this.codes, 0, c2, 0, this.used);
            this.names = n2;
            this.values = v2;
            this.codes = c2;
            if (this.types != null) {
                SimpleType[] t2 = new SimpleType[newsize];
                System.arraycopy(this.types, 0, t2, 0, this.used);
                this.types = t2;
            }
        }
        int n = this.used;
        this.names[n] = nodeName;
        this.codes[n] = (long)locationId << 32 | (long)properties;
        this.setTypeAnnotation(n, type);
        this.values[this.used++] = value;
    }

    public void setAttribute(int index, NodeName nodeName, SimpleType type, String value, int locationId, int properties) {
        this.names[index] = nodeName;
        this.codes[index] = (long)locationId << 32 | (long)properties;
        this.setTypeAnnotation(index, type);
        this.values[this.used++] = value;
        this.values[index] = value;
    }

    public void clear() {
        this.used = 0;
    }

    public void compact() {
        if (this.used == 0) {
            this.codes = null;
            this.values = null;
        } else if (this.values != null && this.values.length > this.used) {
            NodeName[] n2 = new NodeName[this.used];
            String[] v2 = new String[this.used];
            long[] c2 = new long[this.used];
            System.arraycopy(this.names, 0, n2, 0, this.used);
            System.arraycopy(this.values, 0, v2, 0, this.used);
            System.arraycopy(this.codes, 0, c2, 0, this.used);
            this.values = v2;
            this.codes = c2;
            this.names = n2;
            if (this.types != null) {
                SimpleType[] t2 = new SimpleType[this.used];
                System.arraycopy(this.types, 0, t2, 0, this.used);
                this.types = t2;
            }
        }
    }

    public int getLength() {
        return this.values == null ? 0 : this.used;
    }

    public int getNameCode(int index) {
        if (this.names == null) {
            return -1;
        }
        if (index < 0 || index >= this.used) {
            return -1;
        }
        return this.names[index].allocateNameCode(this.config.getNamePool());
    }

    public NodeName getNodeName(int index) {
        if (this.names == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.names[index];
    }

    public SimpleType getTypeAnnotation(int index) {
        if (this.types == null) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        if (index < 0 || index >= this.used) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return this.types[index];
    }

    public int getLocationId(int index) {
        if (this.codes == null) {
            return -1;
        }
        if (index < 0 || index >= this.used) {
            return -1;
        }
        return (int)(this.codes[index] >> 32);
    }

    public String getSystemId(int index) {
        return this.locationProvider.getSystemId(this.getLocationId(index));
    }

    public int getLineNumber(int index) {
        return this.locationProvider.getLineNumber(this.getLocationId(index));
    }

    public int getProperties(int index) {
        if (this.codes == null) {
            return -1;
        }
        if (index < 0 || index >= this.used) {
            return -1;
        }
        return (int)this.codes[index];
    }

    public String getPrefix(int index) {
        if (this.names == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.names[index].getPrefix();
    }

    public String getQName(int index) {
        if (this.names == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.names[index].getDisplayName();
    }

    public String getLocalName(int index) {
        if (this.names == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.names[index].getLocalPart();
    }

    public String getURI(int index) {
        if (this.names == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.names[index].getURI();
    }

    public String getType(int index) {
        int typeCode = this.getTypeAnnotation(index).getFingerprint();
        switch (typeCode) {
            case 560: {
                return "ID";
            }
            case 561: {
                return "IDREF";
            }
            case 556: {
                return "NMTOKEN";
            }
            case 563: {
                return "ENTITY";
            }
            case 562: {
                return "IDREFS";
            }
            case 557: {
                return "NMTOKENS";
            }
            case 564: {
                return "ENTITIES";
            }
        }
        return "CDATA";
    }

    public String getType(String uri, String localname) {
        int index = this.findByName(uri, localname);
        return index < 0 ? null : this.getType(index);
    }

    public String getValue(int index) {
        if (this.values == null) {
            return null;
        }
        if (index < 0 || index >= this.used) {
            return null;
        }
        return this.values[index];
    }

    public String getValue(String uri, String localname) {
        int index = this.findByName(uri, localname);
        return index < 0 ? null : this.getValue(index);
    }

    public String getValueByFingerprint(int fingerprint) {
        int index = this.findByFingerprint(fingerprint);
        return index < 0 ? null : this.getValue(index);
    }

    public int getIndex(String qname) {
        String[] parts;
        if (this.names == null) {
            return -1;
        }
        if (qname.indexOf(58) < 0) {
            return this.findByName("", qname);
        }
        try {
            parts = Name11Checker.getInstance().getQNameParts(qname);
        }
        catch (QNameException err) {
            return -1;
        }
        String prefix = parts[0];
        if (prefix.length() == 0) {
            return this.findByName("", qname);
        }
        String localName = parts[1];
        for (int i = 0; i < this.used; ++i) {
            if (this.names[i] == null) continue;
            String lname = this.names[i].getLocalPart();
            String ppref = this.names[i].getPrefix();
            if (!localName.equals(lname) || !prefix.equals(ppref)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(String uri, String localname) {
        return this.findByName(uri, localname);
    }

    public int getIndexByFingerprint(int fingerprint) {
        return this.findByFingerprint(fingerprint);
    }

    public String getType(String name) {
        int index = this.getIndex(name);
        return this.getType(index);
    }

    public String getValue(String name) {
        int index = this.getIndex(name);
        return this.getValue(index);
    }

    private int findByName(String uri, String localName) {
        if (this.names == null || this.config == null) {
            return -1;
        }
        for (int i = 0; i < this.used; ++i) {
            if (this.names[i] == null || !this.names[i].isInNamespace(uri) || !localName.equals(this.names[i].getLocalPart())) continue;
            return i;
        }
        return -1;
    }

    private int findByFingerprint(int fingerprint) {
        if (this.names == null || this.config == null) {
            return -1;
        }
        NamePool pool = this.config.getNamePool();
        for (int i = 0; i < this.used; ++i) {
            NodeName nn = this.names[i];
            if (nn == null || !(nn.hasFingerprint() ? nn.getFingerprint() == fingerprint : nn.isInNamespace(pool.getURI(fingerprint)) && nn.getLocalPart().equals(pool.getLocalName(fingerprint)))) continue;
            return i;
        }
        return -1;
    }

    public int findByNodeName(NodeName nodeName) {
        if (this.codes == null || this.config == null) {
            return -1;
        }
        if (nodeName.hasFingerprint()) {
            return this.findByFingerprint(nodeName.getFingerprint());
        }
        return this.findByName(nodeName.getURI(), nodeName.getLocalPart());
    }

    public boolean isId(int index) {
        return !this.isDeleted(index) && (StandardNames.XML_ID_NAME.equals(this.names[index]) || (this.getProperties(index) & 0x800) != 0 || this.config.getTypeHierarchy().isIdCode(this.getTypeAnnotation(index).getFingerprint()));
    }

    public boolean isIdref(int index) {
        return this.config.getTypeHierarchy().isIdrefsCode(this.getTypeAnnotation(index).getFingerprint());
    }

    public void removeAttribute(int index) {
        this.names[index] = null;
        this.codes[index] = -1L;
        this.values[index] = null;
        if (this.types != null) {
            this.types[index] = null;
        }
    }

    public boolean isDeleted(int index) {
        return this.names[index] == null;
    }

    public void renameAttribute(int index, NodeName newName) {
        this.names[index] = newName;
        if (this.types != null) {
            this.types[index] = BuiltInAtomicType.UNTYPED_ATOMIC;
        }
    }

    public void replaceAttribute(int index, CharSequence newValue) {
        this.values[index] = newValue.toString();
    }

    public void setTypeAnnotation(int index, SimpleType type) {
        if (type.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            if (this.types != null) {
                this.types[index] = type;
            }
        } else if (this.types == null) {
            this.types = new SimpleType[this.names.length];
            Arrays.fill(this.types, BuiltInAtomicType.UNTYPED_ATOMIC);
            this.types[index] = type;
        } else {
            this.types[index] = type;
        }
    }
}

