/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CastingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class CastExpression
extends CastingExpression
implements Callable {
    public CastExpression(Expression source, AtomicType target, boolean allowEmpty) {
        super(source, target, allowEmpty);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextInfo);
        SequenceType atomicType = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, this.getCardinality());
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        RoleLocator role = new RoleLocator(2, "cast as", 0);
        ItemType sourceItemType = null;
        this.operand = TypeChecker.staticTypeCheck(this.operand, atomicType, false, role, visitor);
        sourceItemType = this.operand.getItemType();
        if (sourceItemType instanceof ErrorType) {
            if (this.allowsEmpty()) {
                return Literal.makeEmptySequence(this.getContainer());
            }
            XPathException err = new XPathException("Cast does not allow an empty sequence as input");
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
        boolean isXPath30 = visitor.getStaticContext().getXPathLanguageLevel().equals(DecimalValue.THREE);
        PlainType sourceType = (PlainType)sourceItemType;
        int r = th.relationship(sourceType, this.getTargetType());
        if (r == 0) {
            return this.operand;
        }
        if (r == 2) {
            this.converter = new Converter.UpCastingConverter(this.getTargetType());
        } else {
            ConversionRules rules = visitor.getConfiguration().getConversionRules();
            if (sourceType.isAtomicType() && sourceType != BuiltInAtomicType.ANY_ATOMIC) {
                this.converter = rules.getConverter((AtomicType)sourceType, this.getTargetType());
                if (this.converter == null) {
                    XPathException err = new XPathException("Casting from " + sourceType + " to " + this.getTargetType() + " can never succeed");
                    err.setErrorCode("XPTY0004");
                    err.setLocator(this);
                    err.setIsTypeError(true);
                    throw err;
                }
                if (this.getTargetType().isNamespaceSensitive()) {
                    this.converter = this.converter.setNamespaceResolver(this.nsResolver);
                }
                if (!(!this.converter.isXPath30Conversion() || isXPath30 || this.operand instanceof Literal && this.getTargetType().getPrimitiveType() == 530)) {
                    XPathException err = new XPathException("Casting from " + sourceType + " to " + this.getTargetType() + " requires XPath 3.0 functionality to be enabled");
                    err.setErrorCode("XPTY0004");
                    err.setLocator(this);
                    err.setIsTypeError(true);
                    throw err;
                }
            }
        }
        if (this.operand instanceof Literal) {
            return this.preEvaluate(isXPath30);
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression e;
        ItemType et;
        ItemType it;
        ItemType et2;
        Expression e2;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression e22 = super.optimize(visitor, contextItemType);
        if (e22 != this) {
            return e22;
        }
        if (this.getTargetType() == BuiltInAtomicType.UNTYPED_ATOMIC) {
            if (this.operand instanceof StringFn) {
                e2 = ((StringFn)this.operand).getArguments()[0];
                if (e2.getItemType() instanceof AtomicType && e2.getCardinality() == 16384) {
                    this.operand = e2;
                }
            } else if (this.operand instanceof CastExpression) {
                if (((CastExpression)this.operand).getTargetType() == BuiltInAtomicType.UNTYPED_ATOMIC) {
                    return this.operand;
                }
                if (((CastExpression)this.operand).getTargetType() == BuiltInAtomicType.STRING) {
                    ((CastExpression)this.operand).setTargetType(BuiltInAtomicType.UNTYPED_ATOMIC);
                    return this.operand;
                }
            } else if (this.operand instanceof AtomicSequenceConverter) {
                if (this.operand.getItemType() == BuiltInAtomicType.UNTYPED_ATOMIC) {
                    return this.operand;
                }
                if (this.operand.getItemType() == BuiltInAtomicType.STRING) {
                    AtomicSequenceConverter old = (AtomicSequenceConverter)this.operand;
                    AtomicSequenceConverter asc = new AtomicSequenceConverter(old.getBaseExpression(), BuiltInAtomicType.UNTYPED_ATOMIC);
                    return asc.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
                }
            }
        }
        if (this.operand instanceof StringFn && (et2 = (e2 = ((StringFn)this.operand).getArguments()[0]).getItemType()) instanceof AtomicType && e2.getCardinality() == 16384 && th.isSubType(et2, this.getTargetType())) {
            return e2;
        }
        if (this.operand instanceof CastExpression && (th.isSubType(it = ((CastExpression)this.operand).getTargetType(), BuiltInAtomicType.STRING) || th.isSubType(it, BuiltInAtomicType.UNTYPED_ATOMIC)) && (et = (e = ((CastExpression)this.operand).getBaseExpression()).getItemType()) instanceof AtomicType && e.getCardinality() == 16384 && th.isSubType(et, this.getTargetType())) {
            return e;
        }
        if (this.operand instanceof AtomicSequenceConverter && (th.isSubType(it = this.operand.getItemType(), BuiltInAtomicType.STRING) || th.isSubType(it, BuiltInAtomicType.UNTYPED_ATOMIC)) && (et = (e = ((AtomicSequenceConverter)this.operand).getBaseExpression()).getItemType()) instanceof AtomicType && e.getCardinality() == 16384 && th.isSubType(et, this.getTargetType())) {
            return e;
        }
        if (!Cardinality.allowsZero(this.operand.getCardinality())) {
            this.setAllowEmpty(false);
            this.resetLocalStaticProperties();
        }
        if (this.operand instanceof Literal) {
            return this.preEvaluate(visitor.getStaticContext().getXPathLanguageLevel().equals(DecimalValue.THREE));
        }
        return this;
    }

    protected Expression preEvaluate(boolean isXPath30) throws XPathException {
        GroundedValue literalOperand = ((Literal)this.operand).getValue();
        if (literalOperand instanceof AtomicValue && this.converter != null) {
            if (!(!this.converter.isXPath30Conversion() || isXPath30 || this.converter instanceof StringConverter.StringToQName && this.isOperandIsStringLiteral())) {
                XPathException e = new XPathException("Casting from " + ((AtomicValue)literalOperand).getPrimitiveType() + " to " + this.getTargetType() + " requires XPath 3.0 to be enabled");
                e.setLocator(this);
                e.setErrorCode("XPTY0004");
                throw e;
            }
            ConversionResult result = this.converter.convert((AtomicValue)literalOperand);
            if (result instanceof ValidationFailure) {
                ValidationFailure err = (ValidationFailure)result;
                String code = err.getErrorCode();
                if (code == null) {
                    code = "FORG0001";
                }
                XPathException xpe = new XPathException(err.getMessage(), this);
                xpe.setErrorCode(code);
                throw xpe;
            }
            return Literal.makeLiteral((AtomicValue)result, this.getContainer());
        }
        if (literalOperand.getLength() == 0) {
            if (this.allowsEmpty()) {
                return this.operand;
            }
            XPathException err = new XPathException("Cast can never succeed: the operand must not be an empty sequence");
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
        return this;
    }

    public int computeCardinality() {
        return this.allowsEmpty() && Cardinality.allowsZero(this.operand.getCardinality()) ? 24576 : 16384;
    }

    public ItemType getItemType() {
        return this.getTargetType();
    }

    public IntegerValue[] getIntegerBounds() {
        if (this.converter == Converter.BOOLEAN_TO_INTEGER) {
            return new IntegerValue[]{Int64Value.ZERO, Int64Value.PLUS_ONE};
        }
        return null;
    }

    public Expression copy() {
        CastExpression c2 = new CastExpression(this.getBaseExpression().copy(), this.getTargetType(), this.allowsEmpty());
        c2.converter = this.converter;
        c2.nsResolver = this.nsResolver;
        c2.setOperandIsStringLiteral(this.isOperandIsStringLiteral());
        return c2;
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        AtomicValue result = this.doCast((AtomicValue)arguments[0].head(), context);
        return result == null ? EmptySequence.getInstance() : result;
    }

    private AtomicValue doCast(AtomicValue value, XPathContext context) throws XPathException {
        ConversionResult result;
        if (value == null) {
            if (this.allowsEmpty()) {
                return null;
            }
            XPathException e = new XPathException("Cast does not allow an empty sequence");
            e.setXPathContext(context);
            e.setLocator(this);
            e.setErrorCode("XPTY0004");
            throw e;
        }
        Converter converter = this.converter;
        if (converter == null) {
            ConversionRules rules = context.getConfiguration().getConversionRules();
            converter = rules.getConverter(value.getPrimitiveType(), this.getTargetType());
            if (converter == null) {
                XPathException e = new XPathException("Casting from " + value.getPrimitiveType() + " to " + this.getTargetType() + " is not permitted");
                e.setXPathContext(context);
                e.setLocator(this);
                e.setErrorCode("XPTY0004");
                throw e;
            }
            if (!(!converter.isXPath30Conversion() || this.getContainer().getPackageData().isAllowXPath30() || converter instanceof StringConverter.StringToQName && this.isOperandIsStringLiteral())) {
                XPathException e = new XPathException("Casting from " + value.getPrimitiveType() + " to " + this.getTargetType() + " requires XPath 3.0 to be enabled");
                e.setXPathContext(context);
                e.setLocator(this);
                e.setErrorCode("XPTY0004");
                throw e;
            }
            if (this.nsResolver != null) {
                converter = converter.setNamespaceResolver(this.nsResolver);
            }
        }
        if ((result = converter.convert(value)) instanceof ValidationFailure) {
            ValidationFailure err = (ValidationFailure)result;
            String code = err.getErrorCode();
            if (code == null) {
                code = "FORG0001";
            }
            this.dynamicError(err.getMessage(), code, context);
            return null;
        }
        return (AtomicValue)result;
    }

    public AtomicValue evaluateItem(XPathContext context) throws XPathException {
        AtomicValue value = (AtomicValue)this.operand.evaluateItem(context);
        return this.doCast(value, context);
    }

    public boolean equals(Object other) {
        return other instanceof CastExpression && this.operand.equals(((CastExpression)other).operand) && this.getTargetType() == ((CastExpression)other).getTargetType() && this.getTargetType() == ((CastExpression)other).getTargetType();
    }

    public int hashCode() {
        return super.hashCode() ^ this.getTargetType().hashCode();
    }

    public String toString() {
        return this.getTargetType().getEQName() + "(" + this.operand.toString() + ")";
    }

    public String toShortString() {
        return this.getTargetType().getDisplayName() + "(" + this.operand.toShortString() + ")";
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("cast");
        out.emitAttribute("as", this.getTargetType().getEQName());
        this.operand.explain(out);
        out.endElement();
    }
}

