/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;

public final class ComplexContentOutputter
extends SequenceReceiver {
    private Receiver nextReceiver;
    private int pendingStartTagDepth = -2;
    private NodeName pendingStartTag = null;
    private int level = -1;
    private boolean[] currentLevelIsDocument = new boolean[20];
    private Boolean elementIsInNullNamespace;
    private NodeName[] pendingAttCode = new NodeName[20];
    private SimpleType[] pendingAttType = new SimpleType[20];
    private String[] pendingAttValue = new String[20];
    private Location[] pendingAttLocation = new Location[20];
    private int[] pendingAttProp = new int[20];
    private int pendingAttListSize = 0;
    private NamespaceBinding[] pendingNSList = new NamespaceBinding[20];
    private int pendingNSListSize = 0;
    private SchemaType currentSimpleType = null;
    private int startElementProperties;
    private Location startElementLocationId = ExplicitLocation.UNKNOWN_LOCATION;
    private boolean declaresDefaultNamespace;
    private int hostLanguage = 50;
    private boolean serializing = false;

    public ComplexContentOutputter(PipelineConfiguration pipe) {
        super(pipe);
    }

    public static SequenceReceiver makeComplexContentReceiver(Receiver receiver, ParseOptions options) throws XPathException {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        ComplexContentOutputter out = new ComplexContentOutputter(pipe);
        out.setHostLanguage(pipe.getHostLanguage());
        NamespaceReducer ne = new NamespaceReducer(receiver);
        ne.setSystemId(receiver.getSystemId());
        receiver = ne;
        if (options != null && options.getSchemaValidationMode() != 3) {
            Configuration config = pipe.getConfiguration();
            receiver = config.getDocumentValidator(ne, receiver.getSystemId(), options);
        }
        out.setReceiver(receiver);
        return out;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        if (this.pipelineConfiguration != pipe) {
            this.pipelineConfiguration = pipe;
            if (this.nextReceiver != null) {
                this.nextReceiver.setPipelineConfiguration(pipe);
            }
        }
    }

    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        this.nextReceiver.setSystemId(systemId);
    }

    public void setHostLanguage(int language) {
        this.hostLanguage = language;
    }

    public void setSerializing(boolean serializing) {
        this.serializing = serializing;
    }

    public boolean isSerializing() {
        return this.serializing;
    }

    public void setReceiver(Receiver receiver) {
        this.nextReceiver = receiver;
    }

    public void open() throws XPathException {
        this.nextReceiver.open();
        this.previousAtomic = false;
    }

    public void startDocument(int properties) throws XPathException {
        ++this.level;
        if (this.level == 0) {
            this.nextReceiver.startDocument(properties);
        } else if (this.pendingStartTagDepth >= 0) {
            this.startContent();
            this.pendingStartTagDepth = -2;
        }
        this.previousAtomic = false;
        if (this.currentLevelIsDocument.length < this.level + 1) {
            boolean[] b2 = new boolean[this.level * 2];
            System.arraycopy(this.currentLevelIsDocument, 0, b2, 0, this.level);
            this.currentLevelIsDocument = b2;
        }
        this.currentLevelIsDocument[this.level] = true;
    }

    public void endDocument() throws XPathException {
        if (this.level == 0) {
            this.nextReceiver.endDocument();
        }
        this.previousAtomic = false;
        --this.level;
    }

    public void characters(CharSequence s, Location locationId, int properties) throws XPathException {
        this.previousAtomic = false;
        if (s == null) {
            return;
        }
        int len = s.length();
        if (len == 0) {
            return;
        }
        if (this.pendingStartTagDepth >= 0) {
            this.startContent();
        }
        this.nextReceiver.characters(s, locationId, properties);
    }

    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        ++this.level;
        if (this.pendingStartTagDepth >= 0) {
            this.startContent();
        }
        this.startElementProperties = properties;
        this.startElementLocationId = location.saveLocation();
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = elemName;
        this.pendingStartTagDepth = 1;
        this.elementIsInNullNamespace = null;
        this.declaresDefaultNamespace = false;
        this.currentSimpleType = typeCode;
        this.previousAtomic = false;
        if (this.currentLevelIsDocument.length < this.level + 1) {
            boolean[] b2 = new boolean[this.level * 2];
            System.arraycopy(this.currentLevelIsDocument, 0, b2, 0, this.level);
            this.currentLevelIsDocument = b2;
        }
        this.currentLevelIsDocument[this.level] = false;
    }

    public void namespace(NamespaceBinding nsBinding, int properties) throws XPathException {
        if (this.pendingStartTagDepth < 0) {
            throw NoOpenStartTagException.makeNoOpenStartTagException(13, nsBinding.getPrefix(), this.hostLanguage, this.pendingStartTagDepth == -2, this.isSerializing(), this.startElementLocationId);
        }
        boolean rejectDuplicates = (properties & 0x20) != 0;
        for (int i = 0; i < this.pendingNSListSize; ++i) {
            if (nsBinding.equals(this.pendingNSList[i])) {
                return;
            }
            if (!nsBinding.getPrefix().equals(this.pendingNSList[i].getPrefix())) continue;
            if (this.pendingNSList[i].isDefaultUndeclaration() || nsBinding.isDefaultUndeclaration()) {
                this.pendingNSList[i] = nsBinding;
                continue;
            }
            if (rejectDuplicates) {
                String prefix = nsBinding.getPrefix();
                String uri1 = nsBinding.getURI();
                String uri2 = this.pendingNSList[i].getURI();
                XPathException err = new XPathException("Cannot create two namespace nodes with the same prefix mapped to different URIs (prefix=" + (prefix.isEmpty() ? "\"\"" : prefix) + ", URI=" + (uri1.isEmpty() ? "\"\"" : uri1) + ", URI=" + (uri2.isEmpty() ? "\"\"" : uri2) + ")");
                err.setErrorCode(this.hostLanguage == 50 ? "XTDE0430" : "XQDY0102");
                throw err;
            }
            return;
        }
        if (nsBinding.getPrefix().isEmpty() && nsBinding.getURI().length() != 0) {
            this.declaresDefaultNamespace = true;
            if (this.elementIsInNullNamespace == null) {
                this.elementIsInNullNamespace = this.pendingStartTag.hasURI("");
            }
            if (this.elementIsInNullNamespace.booleanValue()) {
                XPathException err = new XPathException("Cannot output a namespace node for the default namespace when the element is in no namespace");
                err.setErrorCode(this.hostLanguage == 50 ? "XTDE0440" : "XQDY0102");
                throw err;
            }
        }
        if (this.pendingNSListSize + 1 > this.pendingNSList.length) {
            NamespaceBinding[] newlist = new NamespaceBinding[this.pendingNSListSize * 2];
            System.arraycopy(this.pendingNSList, 0, newlist, 0, this.pendingNSListSize);
            this.pendingNSList = newlist;
        }
        this.pendingNSList[this.pendingNSListSize++] = nsBinding;
        this.previousAtomic = false;
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (this.pendingStartTagDepth < 0) {
            NoOpenStartTagException err = NoOpenStartTagException.makeNoOpenStartTagException(2, attName.getDisplayName(), this.hostLanguage, this.level < 0 || this.currentLevelIsDocument[this.level], this.isSerializing(), this.startElementLocationId);
            err.setLocator(locationId);
            throw err;
        }
        for (int a = 0; a < this.pendingAttListSize; ++a) {
            if (!this.pendingAttCode[a].equals(attName)) continue;
            if (this.hostLanguage == 50) {
                this.pendingAttType[a] = typeCode;
                this.pendingAttValue[a] = value.toString();
                this.pendingAttLocation[a] = locationId;
                this.pendingAttProp[a] = properties;
                return;
            }
            XPathException err = new XPathException("Cannot create an element having two attributes with the same name: " + Err.wrap(attName.getDisplayName(), 2));
            err.setErrorCode("XQDY0025");
            throw err;
        }
        if (this.level == 0 && !typeCode.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && this.currentLevelIsDocument[0] && typeCode.isNamespaceSensitive()) {
            XPathException err = new XPathException("Cannot copy attributes whose type is namespace-sensitive (QName or NOTATION): " + Err.wrap(attName.getDisplayName(), 2));
            err.setErrorCode(this.hostLanguage == 50 ? "XTTE0950" : "XQTY0086");
            throw err;
        }
        if (this.pendingAttListSize >= this.pendingAttCode.length) {
            NodeName[] attCode2 = new NodeName[this.pendingAttListSize * 2];
            SimpleType[] attType2 = new SimpleType[this.pendingAttListSize * 2];
            String[] attValue2 = new String[this.pendingAttListSize * 2];
            Location[] attLoc2 = new Location[this.pendingAttListSize * 2];
            int[] attProp2 = new int[this.pendingAttListSize * 2];
            System.arraycopy(this.pendingAttCode, 0, attCode2, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttType, 0, attType2, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttValue, 0, attValue2, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttLocation, 0, attLoc2, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttProp, 0, attProp2, 0, this.pendingAttListSize);
            this.pendingAttCode = attCode2;
            this.pendingAttType = attType2;
            this.pendingAttValue = attValue2;
            this.pendingAttLocation = attLoc2;
            this.pendingAttProp = attProp2;
        }
        this.pendingAttCode[this.pendingAttListSize] = attName;
        this.pendingAttType[this.pendingAttListSize] = typeCode;
        this.pendingAttValue[this.pendingAttListSize] = value.toString();
        this.pendingAttLocation[this.pendingAttListSize] = locationId;
        this.pendingAttProp[this.pendingAttListSize] = properties;
        ++this.pendingAttListSize;
        this.previousAtomic = false;
    }

    private NodeName checkProposedPrefix(NodeName nodeName, int seq) throws XPathException {
        NamespaceBinding binding = nodeName.getNamespaceBinding();
        String nsprefix = binding.getPrefix();
        for (int i = 0; i < this.pendingNSListSize; ++i) {
            if (!nsprefix.equals(this.pendingNSList[i].getPrefix())) continue;
            if (binding.getURI().equals(this.pendingNSList[i].getURI())) {
                return nodeName;
            }
            String prefix = this.getSubstitutePrefix(binding, seq);
            FingerprintedQName newName = new FingerprintedQName(prefix, nodeName.getURI(), nodeName.getLocalPart());
            this.namespace(newName.getNamespaceBinding(), 0);
            return newName;
        }
        this.namespace(binding, 0);
        return nodeName;
    }

    private String getSubstitutePrefix(NamespaceBinding nscode, int seq) {
        return nscode.getPrefix() + '_' + seq;
    }

    public void endElement() throws XPathException {
        if (this.pendingStartTagDepth >= 0) {
            this.startContent();
        } else {
            this.pendingStartTagDepth = -2;
            this.pendingStartTag = null;
        }
        this.nextReceiver.endElement();
        --this.level;
        this.previousAtomic = false;
    }

    public void comment(CharSequence comment, Location locationId, int properties) throws XPathException {
        if (this.pendingStartTagDepth >= 0) {
            this.startContent();
        }
        this.nextReceiver.comment(comment, locationId, properties);
        this.previousAtomic = false;
    }

    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        if (this.pendingStartTagDepth >= 0) {
            this.startContent();
        }
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
        this.previousAtomic = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (item == null) return;
        if (item instanceof AtomicValue || item instanceof ObjectValue) {
            if (this.previousAtomic) {
                this.characters(" ", locationId, 0);
            }
            this.characters(item.getStringValueCS(), locationId, 0);
            this.previousAtomic = true;
            return;
        }
        if (item instanceof Function) {
            String string;
            if (SequenceReceiver.isTrueSequenceReceiver(this.nextReceiver)) {
                ((SequenceReceiver)this.nextReceiver).append(item);
                return;
            }
            String kind = "a function item";
            if (item instanceof MapItem) {
                kind = "a map";
            } else if (item instanceof ArrayItem) {
                kind = "an array";
            }
            boolean isXSLT = this.getPipelineConfiguration().getHostLanguage() == 50;
            String string2 = "Cannot add " + kind + " to an XML tree";
            if (isXSLT) {
                string = "XTDE0450";
                throw new XPathException(string2, string);
            }
            string = "FOTY0013";
            throw new XPathException(string2, string);
        }
        if (((NodeInfo)item).getNodeKind() == 9) {
            this.startDocument(0);
            AxisIterator iter = ((NodeInfo)item).iterateAxis((byte)3);
            while (true) {
                Item it;
                if ((it = iter.next()) == null) {
                    this.endDocument();
                    this.previousAtomic = false;
                    return;
                }
                this.append(it, locationId, copyNamespaces);
            }
        }
        int copyOptions = 4;
        if (copyNamespaces == 1) {
            copyOptions |= 1;
        } else if (copyNamespaces == 2) {
            copyOptions |= 2;
        }
        ((NodeInfo)item).copy(this, copyOptions, locationId);
        this.previousAtomic = false;
    }

    public void close() throws XPathException {
        this.nextReceiver.close();
        this.previousAtomic = false;
    }

    public void startContent() throws XPathException {
        int a;
        if (this.pendingStartTagDepth < 0) {
            return;
        }
        int props = this.startElementProperties;
        NodeName elcode = this.pendingStartTag;
        if (this.declaresDefaultNamespace || this.pendingStartTag.getPrefix().length() != 0) {
            elcode = this.checkProposedPrefix(this.pendingStartTag, 0);
            props = this.startElementProperties | 0x40;
        }
        this.nextReceiver.startElement(elcode, this.currentSimpleType, this.startElementLocationId, props);
        for (a = 0; a < this.pendingAttListSize; ++a) {
            NodeName attcode = this.pendingAttCode[a];
            if (attcode.hasURI("")) continue;
            this.pendingAttCode[a] = attcode = this.checkProposedPrefix(attcode, a + 1);
        }
        for (int n = 0; n < this.pendingNSListSize; ++n) {
            this.nextReceiver.namespace(this.pendingNSList[n], 0);
        }
        for (a = 0; a < this.pendingAttListSize; ++a) {
            this.nextReceiver.attribute(this.pendingAttCode[a], this.pendingAttType[a], this.pendingAttValue[a], this.pendingAttLocation[a], this.pendingAttProp[a]);
        }
        this.nextReceiver.startContent();
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTagDepth = -1;
        this.previousAtomic = false;
    }

    public boolean usesTypeAnnotations() {
        return this.nextReceiver.usesTypeAnnotations();
    }
}

