/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Assignation
extends Expression
implements LocalBinding {
    private Operand sequenceOp = new Operand(this, null, OperandRole.NAVIGATE);
    private Operand actionOp = new Operand(this, null, this instanceof LetExpression ? OperandRole.SAME_FOCUS_ACTION : REPEATED_ACTION_ROLE);
    protected int slotNumber = -999;
    protected StructuredQName variableName;
    protected SequenceType requiredType;
    protected int refCount = 2;
    private static final OperandRole REPEATED_ACTION_ROLE = new OperandRole(4, OperandUsage.TRANSMISSION);

    public Operand getSequenceOp() {
        return this.sequenceOp;
    }

    public Operand getActionOp() {
        return this.actionOp;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.sequenceOp, this.actionOp);
    }

    public void setRequiredType(SequenceType requiredType) {
        this.requiredType = requiredType;
    }

    public void setVariableQName(StructuredQName variableName) {
        this.variableName = variableName;
    }

    @Override
    public StructuredQName getVariableQName() {
        return this.variableName;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.variableName;
    }

    @Override
    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    @Override
    public IntegerValue[] getIntegerBoundsForVariable() {
        return this.getSequence().getIntegerBounds();
    }

    @Override
    public int getLocalSlotNumber() {
        return this.slotNumber;
    }

    @Override
    public Sequence evaluateVariable(XPathContext context) throws XPathException {
        Sequence actual = context.evaluateLocalVariable(this.slotNumber);
        if (!(actual instanceof GroundedValue) && !(actual instanceof NodeInfo)) {
            actual = SequenceTool.toGroundedValue(actual);
            context.setLocalVariable(this.slotNumber, actual);
        }
        return actual;
    }

    public void setAction(Expression action) {
        this.actionOp.setChildExpression(action);
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }

    @Override
    public final boolean isAssignable() {
        return false;
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        this.getSequence().checkForUpdatingSubexpressions();
        if (this.getSequence().isUpdatingExpression()) {
            XPathException err = new XPathException("An updating expression cannot be used to initialize a variable", "XUST0001");
            err.setLocator(this.getSequence().getLocation());
            throw err;
        }
        this.getAction().checkForUpdatingSubexpressions();
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.getAction().isUpdatingExpression();
    }

    public Expression getAction() {
        return this.actionOp.getChildExpression();
    }

    public void setSequence(Expression sequence) {
        this.sequenceOp.setChildExpression(sequence);
    }

    public Expression getSequence() {
        return this.sequenceOp.getChildExpression();
    }

    public void setSlotNumber(int nr) {
        this.slotNumber = nr;
    }

    public int getRequiredSlots() {
        return 1;
    }

    @Override
    public boolean hasVariableBinding(Binding binding) {
        return this == binding;
    }

    @Override
    public void promoteChildren(PromotionOffer offer) throws XPathException {
        this.setSequence(this.doPromotion(this.getSequence(), offer));
        if (offer.action == 11 || offer.action == 10) {
            Binding[] savedBindingList = offer.bindingList;
            offer.bindingList = this.extendBindingList(offer.bindingList);
            this.setAction(this.doPromotion(this.getAction(), offer));
            offer.bindingList = savedBindingList;
        }
    }

    @Override
    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        this.setAction(this.getAction().unordered(retainAllNodes, forStreaming));
        return this;
    }

    @Override
    public int getCost() {
        return this.getSequence().getCost() + 5 * this.getAction().getCost();
    }

    @Override
    public void suppressValidation(int validationMode) {
        this.getAction().suppressValidation(validationMode);
    }

    public Binding[] extendBindingList(Binding[] in) {
        Binding[] newBindingList;
        if (in == null) {
            newBindingList = new Binding[1];
        } else {
            newBindingList = new Binding[in.length + 1];
            System.arraycopy(in, 0, newBindingList, 0, in.length);
        }
        newBindingList[newBindingList.length - 1] = this;
        return newBindingList;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet varPath = this.getSequence().addToPathMap(pathMap, pathMapNodeSet);
        pathMap.registerPathForVariable(this, varPath);
        return this.getAction().addToPathMap(pathMap, pathMapNodeSet);
    }

    public String getVariableName() {
        if (this.variableName == null) {
            return "zz:var" + this.hashCode();
        }
        return this.variableName.getDisplayName();
    }

    public String getVariableEQName() {
        if (this.variableName == null) {
            return "Q{http://ns.saxonica.com/anonymous-var}var" + this.hashCode();
        }
        if (this.variableName.hasURI("")) {
            return this.variableName.getLocalPart();
        }
        return this.variableName.getEQName();
    }

    public void refineTypeInformation(ItemType type, int cardinality, GroundedValue constantValue, int properties, ExpressionVisitor visitor, Assignation currentExpression) {
        ArrayList<VariableReference> references = new ArrayList<VariableReference>();
        ExpressionTool.gatherVariableReferences(currentExpression.getAction(), this, references);
        for (BindingReference bindingReference : references) {
            if (!(bindingReference instanceof VariableReference)) continue;
            ((VariableReference)bindingReference).refineVariableType(type, cardinality, constantValue, properties);
            ExpressionTool.resetStaticProperties(this);
        }
    }

    @Override
    public void addReference(boolean isLoopingReference) {
        if (this.refCount != 10000 && this.refCount != -1) {
            this.refCount += isLoopingReference ? 10 : 1;
        }
    }

    public int getNominalReferenceCount() {
        return this.refCount;
    }

    public boolean isIndexedVariable() {
        return this.refCount == 10000;
    }

    public boolean replaceVariable(Expression seq) throws XPathException {
        Binding newBinding;
        boolean done = ExpressionTool.inlineVariableReferences(this.getAction(), this, seq);
        if (done && this.isIndexedVariable() && seq instanceof VariableReference && (newBinding = ((VariableReference)seq).getBinding()) instanceof Assignation) {
            ((Assignation)newBinding).setIndexedVariable();
        }
        return done;
    }

    public void setIndexedVariable() {
        this.refCount = 10000;
    }
}

