/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public final class SingletonAtomizer
extends UnaryExpression {
    private boolean allowEmpty;
    private RoleDiagnostic role;

    public SingletonAtomizer(Expression sequence, RoleDiagnostic role, boolean allowEmpty) {
        super(sequence);
        this.allowEmpty = allowEmpty;
        this.role = role;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public Expression simplify() throws XPathException {
        Expression operand = this.getBaseExpression().simplify();
        if (operand instanceof Literal && ((Literal)operand).getValue() instanceof AtomicValue) {
            return operand;
        }
        this.setBaseExpression(operand);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        Expression operand = this.getBaseExpression();
        ExpressionTool.resetStaticProperties(this);
        if (Literal.isEmptySequence(operand)) {
            if (!this.allowEmpty) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), null);
            }
            return operand;
        }
        ItemType operandType = operand.getItemType();
        if (operandType.isPlainType()) {
            return operand;
        }
        if (!operandType.isAtomizable()) {
            XPathException err = operandType instanceof FunctionItemType ? new XPathException("Cannot atomize a function item", "FOTY0013") : new XPathException("Cannot atomize an element that is defined in the schema to have element-only content", "FOTY0012");
            err.setIsTypeError(true);
            err.setLocation(this.getLocation());
            throw err;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression exp = super.optimize(visitor, contextInfo);
        if (exp == this) {
            this.setBaseExpression(this.getBaseExpression().unordered(true, false));
            if (this.getBaseExpression().getItemType().isPlainType() && !Cardinality.allowsMany(this.getBaseExpression().getCardinality())) {
                return this.getBaseExpression();
            }
            return this;
        }
        return exp;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy() {
        SingletonAtomizer e2 = new SingletonAtomizer(this.getBaseExpression().copy(), this.role, this.allowEmpty);
        ExpressionTool.copyLocationInfo(this, e2);
        return e2;
    }

    public int getImplementationMethod() {
        return 1;
    }

    public RoleDiagnostic getRole() {
        return this.role;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        ItemType operandItemType;
        TypeHierarchy th;
        PathMap.PathMapNodeSet result = this.getBaseExpression().addToPathMap(pathMap, pathMapNodeSet);
        if (result != null && ((th = this.getConfiguration().getTypeHierarchy()).relationship(NodeKindTest.ELEMENT, operandItemType = this.getBaseExpression().getItemType()) != 4 || th.relationship(NodeKindTest.DOCUMENT, operandItemType) != 4)) {
            result.setAtomized();
        }
        return null;
    }

    public AtomicValue evaluateItem(XPathContext context) throws XPathException {
        Item item;
        int found = 0;
        AtomicValue result = null;
        SequenceIterator iter = this.getBaseExpression().iterate(context);
        while ((item = iter.next()) != null) {
            AtomicSequence seq = item.atomize();
            if ((found += seq.getLength()) > 1) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage() + CardinalityChecker.depictSequenceStart(iter.getAnother(), 3), this.role.getErrorCode(), context);
            }
            if (found != 1) continue;
            result = seq.head();
        }
        if (found == 0 && !this.allowEmpty) {
            this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), null);
        }
        return result;
    }

    public ItemType getItemType() {
        boolean isSchemaAware;
        block10: {
            isSchemaAware = true;
            try {
                isSchemaAware = this.getPackageData().isSchemaAware();
            }
            catch (NullPointerException err) {
                if (this.getConfiguration().isLicensedFeature(1)) break block10;
                isSchemaAware = false;
            }
        }
        ItemType in = this.getBaseExpression().getItemType();
        if (in.isPlainType()) {
            return in;
        }
        if (in instanceof NodeTest) {
            UType kinds = in.getUType();
            if (!isSchemaAware) {
                if (Atomizer.STRING_KINDS.subsumes(kinds)) {
                    return BuiltInAtomicType.STRING;
                }
                if (Atomizer.UNTYPED_IF_UNTYPED_KINDS.subsumes(kinds)) {
                    return BuiltInAtomicType.UNTYPED_ATOMIC;
                }
            } else if (Atomizer.UNTYPED_KINDS.subsumes(kinds)) {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            return in.getAtomizedItemType();
        }
        if (in instanceof JavaExternalObjectType) {
            return in.getAtomizedItemType();
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public int computeCardinality() {
        if (this.allowEmpty) {
            return 24576;
        }
        return 16384;
    }

    public String getExpressionName() {
        return "atomizeSingleton";
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("atomSing", this);
        if (this.allowEmpty) {
            out.emitAttribute("card", "?");
        }
        out.emitAttribute("diag", this.getRole().save());
        this.getBaseExpression().export(out);
        out.endElement();
    }

    public String toShortString() {
        return this.getBaseExpression().toShortString();
    }
}

