/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Properties;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.AbstractFunction;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public abstract class SystemFunction
extends AbstractFunction {
    private int arity;
    private StandardFunction.Entry details;
    private RetainedStaticContext retainedStaticContext;

    public static Expression makeCall(String name, RetainedStaticContext rsc, Expression ... arguments) {
        SystemFunction f = SystemFunction.makeFunction(name, rsc, arguments.length);
        if (f == null) {
            return null;
        }
        return f.makeFunctionCall(arguments);
    }

    public static SystemFunction makeFunction(String name, RetainedStaticContext rsc, int arity) {
        StandardFunction.Entry entry = StandardFunction.getFunction(name, arity);
        if (entry == null) {
            return null;
        }
        Class functionClass = entry.implementationClass;
        try {
            SystemFunction f = (SystemFunction)functionClass.newInstance();
            f.arity = arity;
            f.setDetails(entry);
            f.setRetainedStaticContext(rsc);
            return f;
        }
        catch (IllegalAccessException err) {
            return null;
        }
        catch (InstantiationException err) {
            return null;
        }
    }

    public Expression makeFunctionCall(Expression ... arguments) {
        SystemFunctionCall e = new SystemFunctionCall(this, arguments);
        ((Expression)e).setRetainedStaticContext(this.getRetainedStaticContext());
        return e;
    }

    public void setArity(int arity) {
        this.arity = arity;
    }

    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        for (int i = 0; i < this.getArity(); ++i) {
            if (!Literal.isEmptySequence(arguments[i]) || this.resultIfEmpty(i) == null) continue;
            return Literal.makeLiteral(SequenceTool.toGroundedValue(this.details.resultIfEmpty[i]));
        }
        return null;
    }

    protected Sequence resultIfEmpty(int arg) {
        return this.details.resultIfEmpty[arg];
    }

    public RetainedStaticContext getRetainedStaticContext() {
        return this.retainedStaticContext;
    }

    public void setRetainedStaticContext(RetainedStaticContext retainedStaticContext) {
        this.retainedStaticContext = retainedStaticContext;
    }

    public void setDetails(StandardFunction.Entry entry) {
        this.details = entry;
    }

    public StandardFunction.Entry getDetails() {
        return this.details;
    }

    public StructuredQName getFunctionName() {
        return new StructuredQName("", "http://www.w3.org/2005/xpath-functions", this.details.name);
    }

    public String getDescription() {
        return "fn:" + this.details.name;
    }

    public int getArity() {
        return this.arity;
    }

    public OperandRole[] getOperandRoles() {
        OperandRole[] roles = new OperandRole[this.getArity()];
        OperandUsage[] usages = this.details.usage;
        try {
            for (int i = 0; i < this.getArity(); ++i) {
                roles[i] = new OperandRole(0, usages[i], this.getRequiredType(i));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return roles;
    }

    public IntegerValue[] getIntegerBounds() {
        return null;
    }

    public void supplyTypeInformation(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType, Expression[] arguments) throws XPathException {
    }

    public boolean equals(Object o) {
        return o != null && o instanceof SystemFunction && super.equals(o);
    }

    public String getErrorCodeForTypeErrors() {
        return "XPTY0004";
    }

    public SequenceType getRequiredType(int arg) {
        if (this.details == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.details.argumentTypes[arg];
    }

    public ItemType getResultItemType() {
        return this.details.itemType;
    }

    public FunctionItemType getFunctionItemType() {
        SequenceType resultType = SequenceType.makeSequenceType(this.getResultItemType(), this.details.cardinality);
        return new SpecificFunctionType(this.details.argumentTypes, resultType);
    }

    public ItemType getResultItemType(Expression[] args) {
        if ((this.details.properties & 1) != 0) {
            return args[0].getItemType();
        }
        if ((this.details.properties & 2) != 0) {
            return args[0].getItemType().getPrimitiveItemType();
        }
        return this.details.itemType;
    }

    public int getCardinality(Expression[] args) {
        return this.details.cardinality;
    }

    public int getSpecialProperties(Expression[] arguments) {
        int p = 0;
        if (this.details == null) {
            return p;
        }
        if (this.details.itemType.isPlainType() || (this.details.properties & 1) != 0 || (this.details.properties & 2) != 0) {
            return p | 0x400000;
        }
        return p | 0x400000;
    }

    protected NodeInfo getContextNode(XPathContext context) throws XPathException {
        Item item = context.getContextItem();
        if (item == null) {
            XPathException err = new XPathException("Context item for " + this.getFunctionName() + "() is absent", "XPDY0002");
            err.maybeSetContext(context);
            throw err;
        }
        if (!(item instanceof NodeInfo)) {
            XPathException err = new XPathException("Context item for " + this.getFunctionName() + "() is not a node", "XPTY0004");
            err.maybeSetContext(context);
            throw err;
        }
        return (NodeInfo)item;
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("fnRef");
        out.emitAttribute("name", this.getFunctionName().getLocalPart());
        out.emitAttribute("arity", this.getArity() + "");
        if ((this.getDetails().properties & 0x38) != 0) {
            out.emitRetainedStaticContext(this.getRetainedStaticContext(), null);
        }
        out.endElement();
    }

    public Expression typeCheckCaller(FunctionCall caller, ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        return caller;
    }

    public String getStaticBaseUriString() {
        return this.getRetainedStaticContext().getStaticBaseUriString();
    }

    public void exportAttributes(ExpressionPresenter out) {
    }

    public boolean isTrustedResultType() {
        return true;
    }

    public void importAttributes(Properties attributes) throws XPathException {
    }
}

