/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.functions.Current;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternMaker;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneralNodePattern
extends Pattern {
    private Expression equivalentExpr = null;
    private NodeTest itemType = null;

    public GeneralNodePattern(Expression expr, NodeTest itemType) {
        this.equivalentExpr = expr;
        this.itemType = itemType;
    }

    @Override
    public Iterable<Operand> operands() {
        return new Operand(this, this.equivalentExpr, OperandRole.SAME_FOCUS_ACTION);
    }

    @Override
    public boolean isMotionless(boolean allowExtensions) {
        return false;
    }

    @Override
    public Pattern typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.equivalentExpr = this.equivalentExpr.typeCheck(visitor, ContextItemStaticInfo.DEFAULT);
        return this;
    }

    @Override
    public Pattern optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.equivalentExpr = this.equivalentExpr.optimize(visitor, ContextItemStaticInfo.DEFAULT);
        if (this.equivalentExpr instanceof FilterExpression && !((FilterExpression)this.equivalentExpr).isFilterIsPositional()) {
            try {
                return PatternMaker.fromExpression(this.equivalentExpr, this.getConfiguration(), true).typeCheck(visitor, ContextItemStaticInfo.DEFAULT);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public int getDependencies() {
        return this.equivalentExpr.getDependencies() & 0x80;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator<Expression>(this.equivalentExpr);
    }

    @Override
    public void bindCurrent(LocalBinding binding) {
        if (ExpressionTool.callsFunction(this.equivalentExpr, Current.FN_CURRENT, false)) {
            if (this.equivalentExpr.isCallOn(Current.class)) {
                this.equivalentExpr = new LocalVariableReference(binding);
            } else {
                GeneralNodePattern.replaceCurrent(this.equivalentExpr, binding);
            }
        }
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        return ExpressionTool.allocateSlots(this.equivalentExpr, nextFree, slotManager);
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        Binding[] savedBindingList = offer.bindingList;
        this.equivalentExpr = this.equivalentExpr.promote(offer);
        offer.bindingList = savedBindingList;
    }

    @Override
    public boolean matches(Item item, XPathContext context) throws XPathException {
        NodeInfo a;
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        if (!this.itemType.matches(item, th)) {
            return false;
        }
        AxisIterator anc = ((NodeInfo)item).iterateAxis((byte)1);
        do {
            if ((a = anc.next()) != null) continue;
            return false;
        } while (!this.matchesBeneathAnchor((NodeInfo)item, a, context));
        return true;
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        if (!this.itemType.matchesNode(node)) {
            return false;
        }
        if (anchor == null) {
            NodeInfo ancestor;
            AxisIterator ancestors = node.iterateAxis((byte)1);
            do {
                if ((ancestor = ancestors.next()) != null) continue;
                return false;
            } while (!this.matchesBeneathAnchor(node, ancestor, context));
            return true;
        }
        XPathContextMinor c2 = context.newMinorContext();
        ManualIterator iter = new ManualIterator(anchor);
        c2.setCurrentIterator(iter);
        try {
            NodeInfo n;
            SequenceIterator nsv = this.equivalentExpr.iterate(c2);
            do {
                if ((n = (NodeInfo)nsv.next()) != null) continue;
                return false;
            } while (!n.isSameNodeInfo(node));
            return true;
        }
        catch (XPathException.Circularity e) {
            throw e;
        }
        catch (XPathException e) {
            XPathException err = new XPathException("An error occurred matching pattern {" + this.toString() + "}: ", e);
            err.setXPathContext(c2);
            err.setErrorCodeQName(e.getErrorCodeQName());
            err.setLocation(this.getLocation());
            c2.getController().recoverableError(err);
            return false;
        }
    }

    @Override
    public UType getUType() {
        return this.itemType.getUType();
    }

    @Override
    public int getFingerprint() {
        return this.itemType.getFingerprint();
    }

    @Override
    public ItemType getItemType() {
        return this.itemType;
    }

    public Expression getEquivalentExpr() {
        return this.equivalentExpr;
    }

    public boolean equals(Object other) {
        if (other instanceof GeneralNodePattern) {
            GeneralNodePattern lpp = (GeneralNodePattern)other;
            return this.equivalentExpr.equals(lpp.equivalentExpr);
        }
        return false;
    }

    public int hashCode() {
        return 0x146B9 ^ this.equivalentExpr.hashCode();
    }

    @Override
    public Pattern copy() {
        GeneralNodePattern n = new GeneralNodePattern(this.equivalentExpr.copy(), this.itemType);
        ExpressionTool.copyLocationInfo(this, n);
        return n;
    }

    @Override
    public void export(ExpressionPresenter presenter) throws XPathException {
        presenter.startElement("p.genNode");
        presenter.emitAttribute("type", this.itemType.toString());
        this.equivalentExpr.export(presenter);
        presenter.endElement();
    }
}

