/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLConnection;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.om.Item;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Base64BinaryValue;

public class BinaryResource
implements Resource {
    private String href = null;
    private String contentType = null;
    private byte[] data;
    private URLConnection connection = null;
    private File file = null;
    private InputStream inputStream = null;
    public static final ResourceFactory FACTORY = new ResourceFactory(){

        public Resource makeResource(Configuration config, String resourceURI, String contentType, AbstractResourceCollection.InputDetails details) throws XPathException {
            return new BinaryResource(resourceURI, contentType, details.inputStream);
        }
    };

    public BinaryResource(String href, String contentType, InputStream in) {
        this.contentType = contentType;
        this.href = href;
        this.inputStream = in;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String getResourceURI() {
        return this.href;
    }

    private byte[] readBinaryFromConn(String href, URLConnection con) throws XPathException {
        InputStream raw = null;
        this.connection = con;
        try {
            int offset;
            raw = this.connection.getInputStream();
            int contentLength = this.connection.getContentLength();
            BufferedInputStream in = new BufferedInputStream(raw);
            byte[] data = new byte[contentLength];
            int bytesRead = 0;
            for (offset = 0; offset < contentLength && (bytesRead = ((InputStream)in).read(data, offset, data.length - offset)) != -1; offset += bytesRead) {
            }
            ((InputStream)in).close();
            if (offset != contentLength) {
                throw new XPathException("Only read " + offset + " bytes; Expected " + contentLength + " bytes");
            }
            return data;
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    public static byte[] readBinaryFromStream(InputStream in, String path) throws XPathException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        try {
            int nRead;
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new XPathException("Failed to read: " + path + " " + e);
        }
    }

    public static byte[] readBinary(File file, String path) throws XPathException {
        try {
            File sFile = file;
            long fileLength = sFile.length();
            byte[] content = new byte[(int)fileLength];
            FileInputStream in = new FileInputStream(sFile);
            int bytes = in.read(content, 0, (int)fileLength);
            if (bytes != content.length) {
                in.close();
                throw new XPathException("Number of bytes read does not match file length");
            }
            in.close();
            return content;
        }
        catch (IOException e) {
            throw new XPathException("Failed to read file " + path, e);
        }
    }

    public Item getItem(XPathContext context) throws XPathException {
        if (this.data != null) {
            return new Base64BinaryValue(this.data);
        }
        if (this.file != null) {
            this.data = BinaryResource.readBinary(this.file, this.href);
            return new Base64BinaryValue(this.data);
        }
        if (this.connection != null) {
            this.data = this.readBinaryFromConn(this.href, this.connection);
            return new Base64BinaryValue(this.data);
        }
        if (this.inputStream != null) {
            this.data = BinaryResource.readBinaryFromStream(this.inputStream, this.href);
            return new Base64BinaryValue(this.data);
        }
        return null;
    }

    public String getContentType() {
        return this.contentType;
    }
}

