/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.accum.AccumulatorManager;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Bindery;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.functions.IriToUri;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.DelegatingErrorListener;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.resource.CollectionURIResolverWrapper;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.ImplicitResultChecker;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.TraceEventMulticaster;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.StylesheetCache;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.RuleManager;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.wrapper.SpaceStrippedDocument;
import net.sf.saxon.tree.wrapper.SpaceStrippedNode;
import net.sf.saxon.tree.wrapper.TypeStrippedDocument;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonClosure;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller
implements ContextOriginator {
    private Configuration config;
    private Executable executable;
    private Item globalContextItem;
    private boolean globalContextItemPreset;
    private Map<PackageData, Bindery> binderies;
    private GlobalParameterSet globalParameters;
    private boolean convertParameters = true;
    private Map<GlobalVariable, Set<GlobalVariable>> globalVariableDependencies = new HashMap<GlobalVariable, Set<GlobalVariable>>();
    private String messageReceiverClassName;
    private Receiver messageReceiver;
    private TraceListener traceListener;
    private boolean tracingPaused;
    private Logger traceFunctionDestination;
    private boolean assertionsEnabled = true;
    private URIResolver standardURIResolver;
    private URIResolver userURIResolver;
    private Receiver principalResult;
    private String principalResultURI;
    private String cookedPrincipalResultURI;
    private boolean thereHasBeenAnExplicitResultDocument;
    private OutputURIResolver outputURIResolver;
    private UnparsedTextURIResolver unparsedTextResolver;
    private String defaultCollectionURI;
    private UnfailingErrorListener errorListener;
    private int recoveryPolicy;
    private TreeModel treeModel = TreeModel.TINY_TREE;
    private NamedTemplate initialTemplate = null;
    private HashSet<DocumentURI> allOutputDestinations;
    private DocumentPool sourceDocumentPool;
    private SequenceOutputter reusableSequenceOutputter = null;
    private HashMap<String, Object> userDataTable;
    private DateTimeValue currentDateTime;
    private boolean dateTimePreset = false;
    private Mode initialMode = null;
    private Function initialFunction = null;
    private NodeInfo lastRememberedNode = null;
    private int lastRememberedNumber = -1;
    private PathMap pathMap = null;
    private int validationMode = 0;
    private boolean inUse = false;
    private boolean stripSourceTrees = true;
    private boolean buildTree = true;
    private Map<StructuredQName, Sequence> initialTemplateParams;
    private Map<StructuredQName, Sequence> initialTemplateTunnelParams;
    private Stack<AttributeSet> attributeSetEvaluationStack = new Stack();
    private StylesheetCache stylesheetCache = null;
    private AccumulatorManager accumulatorManager = null;
    private CollectionFinder collectionFinder = null;
    private final Map<StructuredQName, Integer> messageCounters = new HashMap<StructuredQName, Integer>();
    public static final String ANONYMOUS_PRINCIPAL_OUTPUT_URI = "dummy:/anonymous/principal/result";

    public Controller(Configuration config) {
        this.config = config;
        this.executable = new Executable(config);
        this.sourceDocumentPool = new DocumentPool();
        this.reset();
    }

    public Controller(Configuration config, Executable executable) {
        this.config = config;
        this.executable = executable;
        this.sourceDocumentPool = new DocumentPool();
        this.reset();
    }

    public void reset() {
        TraceListener tracer;
        this.globalParameters = new GlobalParameterSet();
        this.standardURIResolver = this.config.getSystemURIResolver();
        this.userURIResolver = this.config.getURIResolver();
        this.outputURIResolver = this.config.getOutputURIResolver();
        this.unparsedTextResolver = this.config.getUnparsedTextURIResolver();
        this.setErrorListener(this.config.getErrorListener());
        this.recoveryPolicy = this.config.getRecoveryPolicy();
        this.validationMode = this.config.getSchemaValidationMode();
        this.accumulatorManager = new AccumulatorManager();
        if (this.errorListener instanceof StandardErrorListener) {
            Logger ps = ((StandardErrorListener)this.errorListener).getLogger();
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(this.executable.getHostLanguage());
            ((StandardErrorListener)this.errorListener).setLogger(ps);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(this.recoveryPolicy);
        }
        this.traceListener = null;
        this.traceFunctionDestination = this.config.getLogger();
        try {
            tracer = this.config.makeTraceListener();
        }
        catch (XPathException err) {
            throw new IllegalStateException(err.getMessage());
        }
        if (tracer != null) {
            this.addTraceListener(tracer);
        }
        this.setModel(this.config.getParseOptions().getModel());
        this.globalContextItem = null;
        this.messageReceiver = null;
        this.currentDateTime = null;
        this.dateTimePreset = false;
        this.initialMode = null;
        this.initialTemplate = null;
        this.clearPerTransformationData();
    }

    private synchronized void clearPerTransformationData() {
        this.userDataTable = new HashMap(20);
        this.principalResult = null;
        this.allOutputDestinations = null;
        this.thereHasBeenAnExplicitResultDocument = false;
        this.lastRememberedNode = null;
        this.lastRememberedNumber = -1;
        this.tracingPaused = false;
        if (!this.globalContextItemPreset) {
            this.globalContextItem = null;
        }
        this.messageCounters.clear();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setInitialMode(StructuredQName expandedModeName) throws XPathException {
        if (expandedModeName == null || expandedModeName.equals(Mode.UNNAMED_MODE_NAME)) {
            this.initialMode = ((PreparedStylesheet)this.executable).getRuleManager().obtainMode(Mode.UNNAMED_MODE_NAME, true);
        } else if (expandedModeName.equals(Mode.DEFAULT_MODE_NAME)) {
            StructuredQName defaultModeName = ((StylesheetPackage)this.executable.getTopLevelPackage()).getDefaultMode();
            if (!expandedModeName.equals(defaultModeName)) {
                this.setInitialMode(defaultModeName);
            }
        } else {
            this.initialMode = ((PreparedStylesheet)this.executable).getRuleManager().obtainMode(expandedModeName, false);
            boolean declaredModes = ((StylesheetPackage)this.executable.getTopLevelPackage()).isDeclaredModes();
            if (this.initialMode == null) {
                throw new XPathException("Requested initial mode " + expandedModeName + " is not defined in the stylesheet", "XTDE0045");
            }
            if (declaredModes && this.initialMode.getDeclaringComponent().getVisibility() == Visibility.PRIVATE) {
                throw new XPathException("Requested initial mode " + expandedModeName + " is private", "XTDE0045");
            }
            if (!declaredModes && this.initialMode.isEmpty()) {
                throw new XPathException("Requested initial mode " + expandedModeName + " contains no template rules", "XTDE0045");
            }
        }
    }

    public StructuredQName getInitialModeName() {
        return this.initialMode == null ? null : this.initialMode.getModeName();
    }

    public Mode getInitialMode() {
        StructuredQName defaultMode;
        if (this.initialMode == null && (defaultMode = ((StylesheetPackage)this.executable.getTopLevelPackage()).getDefaultMode()) != null) {
            this.initialMode = ((PreparedStylesheet)this.executable).getRuleManager().obtainMode(defaultMode, false);
        }
        return this.initialMode;
    }

    public AccumulatorManager getAccumulatorManager() {
        return this.accumulatorManager;
    }

    public Sequence getParameter(StructuredQName name) {
        return this.globalParameters.get(name);
    }

    public Sequence getConvertedParameter(StructuredQName name, SequenceType requiredType, XPathContext context) throws XPathException {
        Sequence val = this.globalParameters.convertParameterValue(name, requiredType, this.convertParameters, context);
        if (val != null) {
            Item next;
            Configuration config = this.getConfiguration();
            SequenceIterator iter = val.iterate();
            while ((next = iter.next()) != null) {
                if (!(next instanceof NodeInfo) || config.isCompatible(((NodeInfo)next).getConfiguration())) continue;
                throw new XPathException("A node supplied in a global parameter must be built using the same Configuration that was used to compile the stylesheet or query", "SXXP0004");
            }
            if (val instanceof NodeInfo && ((NodeInfo)val).getNodeKind() == 9) {
                String systemId = ((NodeInfo)val).getRoot().getSystemId();
                try {
                    DocumentPool pool;
                    if (systemId != null && new URI(systemId).isAbsolute() && (pool = this.getDocumentPool()).find(systemId) == null) {
                        pool.add(((NodeInfo)val).getTreeInfo(), systemId);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            val = SequenceTool.toGroundedValue(val);
        }
        return val;
    }

    public void setBaseOutputURI(String uri) {
        this.principalResultURI = uri;
    }

    public String getBaseOutputURI() {
        return this.principalResultURI;
    }

    public String getCookedBaseOutputURI() {
        if (this.cookedPrincipalResultURI == null) {
            String base = this.getBaseOutputURI();
            if (base == null && this.config.getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions")) {
                base = new File(System.getProperty("user.dir")).toURI().toString();
            }
            if (base != null) {
                base = IriToUri.iriToUri(base).toString();
            }
            this.cookedPrincipalResultURI = base;
        }
        return this.cookedPrincipalResultURI;
    }

    public Receiver getPrincipalResult() {
        return this.principalResult;
    }

    public synchronized boolean checkUniqueOutputDestination(DocumentURI uri) {
        if (uri == null) {
            return true;
        }
        if (this.allOutputDestinations == null) {
            this.allOutputDestinations = new HashSet(20);
        }
        return !this.allOutputDestinations.contains(uri);
    }

    public void addUnavailableOutputDestination(DocumentURI uri) {
        if (this.allOutputDestinations == null) {
            this.allOutputDestinations = new HashSet(20);
        }
        this.allOutputDestinations.add(uri);
    }

    public void removeUnavailableOutputDestination(DocumentURI uri) {
        if (this.allOutputDestinations != null) {
            this.allOutputDestinations.remove(uri);
        }
    }

    public boolean isUnusedOutputDestination(DocumentURI uri) {
        return this.allOutputDestinations == null || !this.allOutputDestinations.contains(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkImplicitResultTree() throws XPathException {
        String implicitURI = this.principalResultURI;
        if (implicitURI == null) {
            implicitURI = ANONYMOUS_PRINCIPAL_OUTPUT_URI;
        }
        DocumentURI documentURI = new DocumentURI(implicitURI);
        Controller controller = this;
        synchronized (controller) {
            if (!this.checkUniqueOutputDestination(documentURI)) {
                XPathException err = new XPathException("Cannot write an implicit result document if an explicit result document has been written to the same URI: " + (implicitURI.equals(ANONYMOUS_PRINCIPAL_OUTPUT_URI) ? "(no URI supplied)" : implicitURI));
                err.setErrorCode("XTDE1490");
                throw err;
            }
            this.addUnavailableOutputDestination(documentURI);
        }
    }

    public void setThereHasBeenAnExplicitResultDocument() {
        this.thereHasBeenAnExplicitResultDocument = true;
    }

    public boolean hasThereBeenAnExplicitResultDocument() {
        return this.thereHasBeenAnExplicitResultDocument;
    }

    public synchronized SequenceOutputter allocateSequenceOutputter(int size) {
        PipelineConfiguration pipe = this.makePipelineConfiguration();
        return new SequenceOutputter(pipe, size);
    }

    public void reuseSequenceOutputter(SequenceOutputter out) {
        this.reusableSequenceOutputter = out;
    }

    public void setBuildTree(boolean build) {
        this.buildTree = build;
    }

    public boolean isBuildTree() {
        return this.buildTree;
    }

    public void setInitialTemplate(StructuredQName qName) throws XPathException {
        if (qName == null) {
            this.initialTemplate = null;
            return;
        }
        NamedTemplate t = ((PreparedStylesheet)this.getExecutable()).getNamedTemplate(qName);
        if (t == null) {
            XPathException err = new XPathException("The requested initial template " + qName.getDisplayName() + " does not exist");
            err.setErrorCode("XTDE0040");
            this.reportFatalError(err);
            throw err;
        }
        this.initialTemplate = t;
    }

    public StructuredQName getInitialTemplate() {
        if (this.initialTemplate == null) {
            return null;
        }
        return this.initialTemplate.getTemplateName();
    }

    public void setInitialTemplateParameters(Map<StructuredQName, Sequence> params, boolean tunnel) {
        if (tunnel) {
            this.initialTemplateTunnelParams = params;
        } else {
            this.initialTemplateParams = params;
        }
    }

    public Map<StructuredQName, Sequence> getInitialTemplateParameters(boolean tunnel) {
        return tunnel ? this.initialTemplateTunnelParams : this.initialTemplateParams;
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipe = this.config.makePipelineConfiguration();
        pipe.setURIResolver(this.userURIResolver == null ? this.standardURIResolver : this.userURIResolver);
        pipe.getParseOptions().setSchemaValidationMode(this.validationMode);
        pipe.getParseOptions().setErrorListener(this.errorListener);
        pipe.setController(this);
        Executable executable = this.getExecutable();
        if (executable != null) {
            pipe.setHostLanguage(executable.getHostLanguage());
        }
        return pipe;
    }

    public void setMessageReceiverClassName(String name) {
        this.messageReceiverClassName = name;
    }

    private Receiver makeMessageReceiver() throws XPathException {
        Object messageReceiver = this.config.getInstance(this.messageReceiverClassName, null);
        if (!(messageReceiver instanceof Receiver)) {
            throw new XPathException(this.messageReceiverClassName + " is not a Receiver");
        }
        ((Receiver)messageReceiver).setPipelineConfiguration(this.makePipelineConfiguration());
        this.setMessageEmitter((Receiver)messageReceiver);
        return (Receiver)messageReceiver;
    }

    public void setMessageEmitter(Receiver receiver) {
        this.messageReceiver = receiver;
        receiver.setPipelineConfiguration(this.makePipelineConfiguration());
        if (receiver instanceof Emitter && ((Emitter)receiver).getOutputProperties() == null) {
            try {
                Properties props = new Properties();
                props.setProperty("method", "xml");
                props.setProperty("indent", "yes");
                props.setProperty("omit-xml-declaration", "yes");
                ((Emitter)receiver).setOutputProperties(props);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
    }

    public Receiver getMessageEmitter() {
        return this.messageReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMessageCounter(StructuredQName code) {
        Map<StructuredQName, Integer> map = this.messageCounters;
        synchronized (map) {
            Integer c = this.messageCounters.get(code);
            int n = c == null ? 1 : c + 1;
            this.messageCounters.put(code, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<StructuredQName, Integer> getMessageCounters() {
        Map<StructuredQName, Integer> map = this.messageCounters;
        synchronized (map) {
            return new HashMap<StructuredQName, Integer>(this.messageCounters);
        }
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
        if (this.errorListener instanceof StandardErrorListener) {
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(policy);
        }
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener instanceof UnfailingErrorListener ? (UnfailingErrorListener)listener : new DelegatingErrorListener(listener);
    }

    public UnfailingErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void recoverableError(XPathException err) throws XPathException {
        if (this.executable.getHostLanguage() == 51 || this.recoveryPolicy == 2) {
            throw err;
        }
        if (this.executable.getHostLanguage() == 50) {
            this.errorListener.warning(err);
        } else {
            this.errorListener.error(err);
        }
    }

    public void reportFatalError(XPathException err) {
        if (!err.hasBeenReported()) {
            if (err.getHostLanguage() == null) {
                if (this.executable.getHostLanguage() == 50) {
                    err.setHostLanguage("XSLT");
                } else if (this.executable.getHostLanguage() == 51) {
                    err.setHostLanguage("XQuery");
                }
            }
            this.getErrorListener().fatalError(err);
            err.setHasBeenReported(true);
        }
    }

    public void warning(String message, String errorCode, Location locator) {
        this.getErrorListener().warning(new XPathException(message, errorCode, locator));
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public DocumentPool getDocumentPool() {
        return this.sourceDocumentPool;
    }

    public void clearDocumentPool() {
        for (PackageData pack : this.getExecutable().getPackages()) {
            this.sourceDocumentPool.discardIndexes(pack.getKeyManager());
        }
        this.sourceDocumentPool = new DocumentPool();
    }

    public Bindery getBindery(PackageData packageData) {
        Bindery b = this.binderies.get(packageData);
        if (b == null) {
            b = new Bindery(packageData);
            this.binderies.put(packageData, b);
        }
        return b;
    }

    public void setGlobalContextItem(Item contextItem) {
        this.setGlobalContextItem(contextItem, false);
    }

    public void setGlobalContextItem(Item contextItem, boolean alreadyStripped) {
        if (!alreadyStripped) {
            if (this.globalContextItem instanceof SpaceStrippedNode && ((SpaceStrippedNode)this.globalContextItem).getUnderlyingNode() == contextItem) {
                return;
            }
            if (contextItem instanceof NodeInfo) {
                contextItem = this.prepareInputTree((NodeInfo)contextItem);
            }
        }
        this.globalContextItem = contextItem;
        this.globalContextItemPreset = true;
    }

    public Item getGlobalContextItem() {
        return this.globalContextItem;
    }

    public void setURIResolver(URIResolver resolver) {
        this.userURIResolver = resolver;
        if (resolver instanceof StandardURIResolver) {
            ((StandardURIResolver)resolver).setConfiguration(this.getConfiguration());
        }
    }

    public URIResolver getURIResolver() {
        return this.userURIResolver;
    }

    public URIResolver getStandardURIResolver() {
        return this.standardURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver resolver) {
        this.outputURIResolver = resolver == null ? this.config.getOutputURIResolver() : resolver;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.outputURIResolver;
    }

    public void setUnparsedTextURIResolver(UnparsedTextURIResolver resolver) {
        this.unparsedTextResolver = resolver;
    }

    public UnparsedTextURIResolver getUnparsedTextURIResolver() {
        return this.unparsedTextResolver;
    }

    public void setCollectionURIResolver(CollectionURIResolver resolver) {
        this.setCollectionFinder(new CollectionURIResolverWrapper(resolver));
    }

    public CollectionURIResolver getCollectionURIResolver() {
        CollectionFinder finder = this.getCollectionFinder();
        if (finder instanceof CollectionURIResolverWrapper) {
            return ((CollectionURIResolverWrapper)finder).getCollectionURIResolver();
        }
        return null;
    }

    public CollectionFinder getCollectionFinder() {
        if (this.collectionFinder == null) {
            this.collectionFinder = this.config.getCollectionFinder();
        }
        return this.collectionFinder;
    }

    public void setCollectionFinder(CollectionFinder cf) {
        this.collectionFinder = cf;
    }

    public void setDefaultCollection(String uri) {
        this.defaultCollectionURI = uri;
    }

    public String getDefaultCollection() {
        return this.defaultCollectionURI == null ? this.getConfiguration().getDefaultCollection() : this.defaultCollectionURI;
    }

    public int getSchemaValidationMode() {
        return this.validationMode;
    }

    public void setSchemaValidationMode(int validationMode) {
        this.validationMode = validationMode;
    }

    public KeyManager getKeyManager() {
        return this.executable.getKeyManager();
    }

    public void setModel(TreeModel model) {
        this.treeModel = model;
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public Builder makeBuilder() {
        Builder b = this.treeModel.makeBuilder(this.makePipelineConfiguration());
        b.setTiming(this.config.isTiming());
        b.setLineNumbering(this.config.isLineNumbering());
        return b;
    }

    public void setStripSourceTrees(boolean strip) {
        this.stripSourceTrees = strip;
    }

    public boolean isStripSourceTree() {
        return this.stripSourceTrees;
    }

    private boolean isStylesheetContainingStripSpace() {
        SpaceStrippingRule rule;
        return this.executable instanceof PreparedStylesheet && (rule = ((PreparedStylesheet)this.executable).getTopLevelPackage().getSpaceStrippingRule()) != null && rule != NoElementsSpaceStrippingRule.getInstance();
    }

    public boolean isStylesheetStrippingTypeAnnotations() {
        return this.executable instanceof PreparedStylesheet && ((PreparedStylesheet)this.executable).getTopLevelPackage().isStripsTypeAnnotations();
    }

    public Stripper makeStripper(Receiver next) {
        if (next == null) {
            next = new Sink(this.makePipelineConfiguration());
        }
        return new Stripper(this.getSpaceStrippingRule(), next);
    }

    public SpaceStrippingRule getSpaceStrippingRule() {
        SpaceStrippingRule rule;
        if (this.config.getParseOptions().getSpaceStrippingRule() == AllElementsSpaceStrippingRule.getInstance()) {
            return AllElementsSpaceStrippingRule.getInstance();
        }
        if (this.executable instanceof PreparedStylesheet && (rule = ((PreparedStylesheet)this.executable).getTopLevelPackage().getSpaceStrippingRule()) != null) {
            return rule;
        }
        return NoElementsSpaceStrippingRule.getInstance();
    }

    public void registerDocument(TreeInfo doc, DocumentURI uri) throws XPathException {
        if (!this.getExecutable().isSchemaAware() && !Untyped.getInstance().equals(doc.getRootNode().getSchemaType())) {
            boolean isXSLT = this.getExecutable().getHostLanguage() == 50;
            String message = isXSLT ? "The source document has been schema-validated, but the stylesheet is not schema-aware. A stylesheet is schema-aware if either (a) it contains an xsl:import-schema declaration, or (b) the stylesheet compiler was configured to be schema-aware." : "The source document has been schema-validated, but the query is not schema-aware. A query is schema-aware if either (a) it contains an 'import schema' declaration, or (b) the query compiler was configured to be schema-aware.";
            throw new XPathException(message);
        }
        if (uri != null) {
            this.sourceDocumentPool.add(doc, uri);
        }
    }

    public RuleManager getRuleManager() {
        Executable exec = this.getExecutable();
        return exec instanceof PreparedStylesheet ? ((PreparedStylesheet)this.getExecutable()).getRuleManager() : null;
    }

    public void setTraceListener(TraceListener listener) {
        this.traceListener = listener;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public final boolean isTracing() {
        return this.traceListener != null && !this.tracingPaused;
    }

    public final void pauseTracing(boolean pause) {
        this.tracingPaused = pause;
    }

    public void addTraceListener(TraceListener trace) {
        if (trace != null) {
            this.traceListener = TraceEventMulticaster.add(this.traceListener, trace);
        }
    }

    public void removeTraceListener(TraceListener trace) {
        this.traceListener = TraceEventMulticaster.remove(this.traceListener, trace);
    }

    public void setTraceFunctionDestination(Logger stream) {
        this.traceFunctionDestination = stream;
    }

    public Logger getTraceFunctionDestination() {
        return this.traceFunctionDestination;
    }

    public boolean isAssertionsEnabled() {
        return this.assertionsEnabled;
    }

    public void setAssertionsEnabled(boolean enabled) {
        this.assertionsEnabled = enabled;
    }

    public void initializeController(GlobalParameterSet params) throws XPathException {
        block3: {
            this.binderies = new HashMap<PackageData, Bindery>();
            try {
                this.executable.checkAllRequiredParamsArePresent(params);
            }
            catch (XPathException e) {
                if (e.hasBeenReported()) break block3;
                this.getErrorListener().fatalError(e);
                throw e;
            }
        }
        this.globalParameters = params;
        this.globalContextItem = this.executable.checkInitialContextItem(this.globalContextItem, this.newXPathContext());
        if (this.traceListener != null) {
            this.traceListener.open(this);
            this.preEvaluateGlobals(this.newXPathContext());
        }
    }

    public void setApplyFunctionConversionRulesToExternalVariables(boolean applyConversionRules) {
        this.convertParameters = applyConversionRules;
    }

    public Object getUserData(Object key, String name) {
        String keyValue = key.hashCode() + " " + name;
        return this.userDataTable.get(keyValue);
    }

    public void setUserData(Object key, String name, Object data) {
        String keyVal = key.hashCode() + " " + name;
        if (data == null) {
            this.userDataTable.remove(keyVal);
        } else {
            this.userDataTable.put(keyVal, data);
        }
    }

    private void checkReadiness() throws XPathException {
        if (this.inUse) {
            throw new IllegalStateException("The Controller is being used recursively or concurrently. This is not permitted.");
        }
        if (this.binderies == null) {
            throw new IllegalStateException("The Controller has not been initialized");
        }
        this.inUse = true;
        this.clearPerTransformationData();
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been prepared");
        }
        if (!this.dateTimePreset) {
            this.currentDateTime = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transform(Source source, Receiver receiver) throws XPathException {
        this.checkReadiness();
        if (source instanceof TreeInfo) {
            source = ((TreeInfo)source).getRootNode();
        }
        if (source instanceof SAXSource && this.config.getBooleanProperty("http://saxon.sf.net/feature/ignoreSAXSourceParser")) {
            ((SAXSource)source).setXMLReader(null);
        }
        boolean close = false;
        try {
            Source s2;
            NodeInfo startNode = null;
            boolean wrap = true;
            boolean streaming = false;
            int validationMode = this.getSchemaValidationMode();
            Source underSource = source;
            if (source instanceof AugmentedSource) {
                Boolean localWrap = ((AugmentedSource)source).getWrapDocument();
                if (localWrap != null) {
                    wrap = localWrap;
                }
                close = ((AugmentedSource)source).isPleaseCloseAfterUse();
                int localValidate = ((AugmentedSource)source).getSchemaValidation();
                if (localValidate != 0) {
                    validationMode = localValidate;
                }
                if (validationMode == 1 || validationMode == 2) {
                    wrap = false;
                }
                underSource = ((AugmentedSource)source).getContainedSource();
            }
            if ((s2 = this.config.getSourceResolver().resolveSource(underSource, this.config)) != null) {
                underSource = s2;
            }
            if (wrap && (underSource instanceof NodeInfo || underSource instanceof DOMSource)) {
                if (this.globalContextItem instanceof SpaceStrippedNode && ((SpaceStrippedNode)this.globalContextItem).getUnderlyingNode() == underSource) {
                    startNode = (SpaceStrippedNode)this.globalContextItem;
                } else if (this.globalContextItem == source) {
                    startNode = (NodeInfo)this.globalContextItem;
                } else {
                    startNode = this.prepareInputTree(underSource);
                    if (startNode == null) {
                        throw new XPathException("The transformation source is a whitespace text node that is stripped by the transformation");
                    }
                }
                String uri = underSource.getSystemId();
                TreeInfo root = startNode.getTreeInfo();
                if (root != null) {
                    this.registerDocument(startNode.getTreeInfo(), uri == null ? null : new DocumentURI(uri));
                }
            } else if (source == null) {
                if (this.initialMode != null) {
                    throw new XPathException("Either a source document or initial match selection must be specified for an initial mode", "XTDE0044");
                }
                if (this.initialTemplate == null && this.initialFunction == null) {
                    NamedTemplate t = ((PreparedStylesheet)this.getExecutable()).getNamedTemplate(new StructuredQName("", "http://www.w3.org/1999/XSL/Transform", "initial-template"));
                    if (t == null) {
                        throw new XPathException("Either a source document, an initial template or an initial function must be specified");
                    }
                    this.initialTemplate = t;
                }
            } else {
                Mode mode = this.getInitialMode();
                if (mode == null) {
                    throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getModeName().getDisplayName()) + " does not exist", "XTDE0045");
                }
                if (mode.isDeclaredStreamable()) {
                    if (!(source instanceof StreamSource) && !(source instanceof SAXSource)) throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getModeName().getDisplayName()) + " is streamable: must supply a SAXSource or StreamSource", "SXST0061");
                    streaming = true;
                    this.transformStream(source, mode, receiver);
                } else {
                    startNode = this.makeSourceTree(source, close, validationMode);
                }
            }
            if (streaming) return;
            this.transformDocument(startNode, receiver);
            return;
        }
        catch (TerminationException err) {
            if (err.hasBeenReported()) throw err;
            this.reportFatalError(err);
            throw err;
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause != null && cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                if (!((cause = spe.getException()) instanceof RuntimeException)) throw err;
                this.reportFatalError(err);
                throw err;
            } else {
                this.reportFatalError(err);
            }
            throw err;
        }
        finally {
            this.inUse = false;
            if (close && source instanceof AugmentedSource) {
                ((AugmentedSource)source).close();
            }
            if (this.messageReceiver != null) {
                this.messageReceiver.close();
            }
        }
    }

    public NodeInfo makeSourceTree(Source source, boolean close, int validationMode) throws XPathException {
        Builder sourceBuilder;
        if (source instanceof SAXSource && this.config.getBooleanProperty("http://saxon.sf.net/feature/ignoreSAXSourceParser")) {
            ((SAXSource)source).setXMLReader(null);
        }
        if ((sourceBuilder = this.makeBuilder()) instanceof TinyBuilder) {
            ((TinyBuilder)sourceBuilder).setStatistics(Statistics.SOURCE_DOCUMENT_STATISTICS);
        }
        Receiver r = sourceBuilder;
        if (this.config.isStripsAllWhiteSpace() || this.isStylesheetContainingStripSpace() || validationMode == 1 || validationMode == 2) {
            r = this.makeStripper(sourceBuilder);
        }
        if (this.isStylesheetStrippingTypeAnnotations()) {
            r = this.config.getAnnotationStripper(r);
        }
        PipelineConfiguration pipe = sourceBuilder.getPipelineConfiguration();
        pipe.getParseOptions().setSchemaValidationMode(validationMode);
        r.setPipelineConfiguration(pipe);
        Sender.send(source, r, null);
        if (close) {
            ((AugmentedSource)source).close();
        }
        NodeInfo doc = sourceBuilder.getCurrentRoot();
        this.globalContextItem = doc;
        sourceBuilder.reset();
        if (source.getSystemId() != null) {
            this.registerDocument(doc.getTreeInfo(), new DocumentURI(source.getSystemId()));
        }
        return doc;
    }

    public void applyTemplates(Sequence source, Receiver outputDestination) throws XPathException {
        this.checkReadiness();
        boolean close = false;
        try {
            Mode mode = this.initialMode;
            if (mode == null) {
                mode = ((PreparedStylesheet)this.executable).getRuleManager().getUnnamedMode();
            }
            if (mode == null) {
                throw new XPathException("Requested initial mode " + (this.initialMode == null ? "#unnamed" : this.initialMode.getModeName().getDisplayName()) + " does not exist", "XTDE0045");
            }
            this.warningIfStreamable(mode);
            this.openMessageEmitter();
            boolean mustClose = false;
            this.principalResult = outputDestination;
            if (this.principalResultURI == null) {
                this.principalResultURI = outputDestination.getSystemId();
            }
            ParameterSet ordinaryParams = null;
            if (this.initialTemplateParams != null) {
                ordinaryParams = new ParameterSet(this.initialTemplateParams);
            }
            ParameterSet tunnelParams = null;
            if (this.initialTemplateTunnelParams != null) {
                tunnelParams = new ParameterSet(this.initialTemplateTunnelParams);
            }
            XPathContextMajor initialContext = this.newXPathContext();
            initialContext.createThreadManager();
            initialContext.setOrigin(this);
            final Mode finalMode = mode;
            SequenceIterator iter = source.iterate();
            MappingFunction preprocessor = new MappingFunction(){

                public SequenceIterator map(Item item) throws XPathException {
                    if (item instanceof NodeInfo) {
                        TreeInfo docInfo;
                        NodeInfo node = (NodeInfo)item;
                        if (node.getConfiguration() == null) {
                            throw new XPathException("The supplied source document must be associated with a Configuration");
                        }
                        if (!node.getConfiguration().isCompatible(Controller.this.executable.getConfiguration())) {
                            throw new XPathException("Source document and stylesheet must use the same or compatible Configurations", "SXXP0004");
                        }
                        if (node.getTreeInfo().isTyped() && !Controller.this.executable.isSchemaAware()) {
                            throw new XPathException("Cannot use a schema-validated source document unless the stylesheet is schema-aware");
                        }
                        if (Controller.this.isStylesheetStrippingTypeAnnotations() && node != Controller.this.globalContextItem && (docInfo = node.getTreeInfo()).isTyped()) {
                            TypeStrippedDocument strippedDoc = new TypeStrippedDocument(docInfo);
                            node = strippedDoc.wrap(node);
                        }
                        if (Controller.this.isStylesheetContainingStripSpace() && Controller.this.isStripSourceTree() && !(node instanceof SpaceStrippedNode) && node != Controller.this.globalContextItem) {
                            SpaceStrippedDocument strippedDoc = new SpaceStrippedDocument(node.getTreeInfo(), Controller.this.getSpaceStrippingRule());
                            if (!SpaceStrippedNode.isPreservedNode(node, strippedDoc, node.getParent())) {
                                return EmptyIterator.getInstance();
                            }
                            node = strippedDoc.wrap(node);
                        }
                        if (Controller.this.getAccumulatorManager() != null) {
                            Controller.this.getAccumulatorManager().setApplicableAccumulators(node.getTreeInfo(), finalMode.getAccumulators());
                        }
                        return SingletonIterator.makeIterator(node);
                    }
                    return SingletonIterator.makeIterator(item);
                }
            };
            iter = new MappingIterator(iter, preprocessor);
            initialContext.setCurrentIterator(new FocusTrackingIterator(iter));
            initialContext.setCurrentMode(mode.getDeclaringComponent());
            initialContext.setCurrentComponent(mode.getDeclaringComponent());
            outputDestination = this.openResult(outputDestination, initialContext);
            for (TailCall tc = mode.applyTemplates(ordinaryParams, tunnelParams, initialContext, ExplicitLocation.UNKNOWN_LOCATION); tc != null; tc = tc.processLeavingTail()) {
            }
            initialContext.waitForChildThreads();
            this.closeResult(outputDestination, mustClose, initialContext);
        }
        catch (TerminationException err) {
            if (!err.hasBeenReported()) {
                this.reportFatalError(err);
            }
            throw err;
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause != null && cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                if ((cause = spe.getException()) instanceof RuntimeException) {
                    this.reportFatalError(err);
                }
            } else {
                this.reportFatalError(err);
            }
            throw err;
        }
        finally {
            this.inUse = false;
            this.closeMessageEmitter();
            if (this.traceListener != null) {
                this.traceListener.close();
            }
            if (close && source instanceof AugmentedSource) {
                ((AugmentedSource)((Object)source)).close();
            }
            this.principalResultURI = null;
        }
    }

    public NodeInfo prepareInputTree(Source source) {
        GenericTreeInfo strippedDoc;
        TreeInfo docInfo;
        NodeInfo start = this.getConfiguration().unravel(source);
        if (this.isStylesheetStrippingTypeAnnotations() && (docInfo = start.getTreeInfo()).isTyped()) {
            strippedDoc = new TypeStrippedDocument(docInfo);
            start = ((TypeStrippedDocument)strippedDoc).wrap(start);
        }
        if (this.stripSourceTrees && this.isStylesheetContainingStripSpace()) {
            docInfo = start.getTreeInfo();
            strippedDoc = new SpaceStrippedDocument(docInfo, this.getSpaceStrippingRule());
            if (!SpaceStrippedNode.isPreservedNode(start, (SpaceStrippedDocument)strippedDoc, start.getParent())) {
                return null;
            }
            start = ((SpaceStrippedDocument)strippedDoc).wrap(start);
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformDocument(NodeInfo startNode, Receiver outputDestination) throws XPathException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        this.openMessageEmitter();
        boolean mustClose = false;
        try {
            this.principalResult = outputDestination;
            if (this.principalResultURI == null) {
                this.principalResultURI = outputDestination.getSystemId();
            }
            XPathContextMajor initialContext = this.newXPathContext();
            initialContext.createThreadManager();
            initialContext.setOrigin(this);
            if (startNode != null) {
                this.globalContextItem = startNode.getRoot();
                if (startNode.getConfiguration() == null) {
                    throw new XPathException("The supplied source document must be associated with a Configuration");
                }
                if (!startNode.getConfiguration().isCompatible(this.executable.getConfiguration())) {
                    throw new XPathException("Source document and stylesheet must use the same or compatible Configurations", "SXXP0004");
                }
                if (startNode.getTreeInfo().isTyped() && !this.executable.isSchemaAware()) {
                    throw new XPathException("Cannot use a schema-validated source document unless the stylesheet is schema-aware");
                }
                UnfailingIterator currentIter = SingletonIterator.makeIterator(startNode);
                FocusTrackingIterator focus = new FocusTrackingIterator(currentIter);
                if (this.initialTemplate != null) {
                    focus.next();
                }
                initialContext.setCurrentIterator(focus);
            }
            outputDestination = this.openResult(outputDestination, initialContext);
            ParameterSet ordinaryParams = null;
            if (this.initialTemplateParams != null) {
                ordinaryParams = new ParameterSet(this.initialTemplateParams);
            }
            ParameterSet tunnelParams = null;
            if (this.initialTemplateTunnelParams != null) {
                tunnelParams = new ParameterSet(this.initialTemplateTunnelParams);
            }
            if (this.initialTemplate == null) {
                NodeInfo topElement;
                Component.M modeComponent;
                Mode mode = this.initialMode;
                if (mode == null) {
                    mode = ((PreparedStylesheet)this.executable).getRuleManager().getUnnamedMode();
                }
                if ((modeComponent = mode.getDeclaringComponent()).getVisibility() == Visibility.PRIVATE && ((StylesheetPackage)this.executable.getTopLevelPackage()).isDeclaredModes() && !mode.isUnnamedMode()) {
                    throw new XPathException((this.initialMode == null ? "" : this.initialMode.getModeTitle()) + " has private visibility", "XTDE0045");
                }
                if (this.getAccumulatorManager() != null) {
                    this.getAccumulatorManager().setApplicableAccumulators(startNode.getTreeInfo(), mode.getAccumulators());
                }
                this.warningIfStreamable(mode);
                if (startNode.getNodeKind() == 9 && !this.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/suppressXsltNamespaceCheck") && (topElement = startNode.iterateAxis((byte)3, NodeKindTest.ELEMENT).next()) != null) {
                    String uri = topElement.getURI();
                    Set<String> explicitNamespaces = mode.getExplicitNamespaces(this.getConfiguration().getNamePool());
                    if (!explicitNamespaces.isEmpty() && !explicitNamespaces.contains(uri)) {
                        NodeInfo element;
                        AxisIterator allElements = startNode.iterateAxis((byte)4, NodeKindTest.ELEMENT);
                        boolean found = false;
                        while ((element = allElements.next()) != null) {
                            String ns = element.getURI();
                            if (!explicitNamespaces.contains(ns)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            String suffix = "(Use --suppressXsltNamespaceCheck:on to avoid this warning)";
                            if (explicitNamespaces.size() == 1 && explicitNamespaces.contains("")) {
                                this.warning("The source document is in namespace " + uri + ", but all the template rules match elements in no namespace " + suffix, "SXXP0005", null);
                            } else if (uri.equals("")) {
                                this.warning("The source document is in no namespace, but the template rules all expect elements in a namespace " + suffix, "SXXP0005", null);
                            } else {
                                this.warning("The source document is in namespace " + uri + ", but none of the template rules match elements in this namespace " + suffix, "SXXP0005", null);
                            }
                        }
                    }
                }
                initialContext.setCurrentMode(mode.getDeclaringComponent());
                initialContext.setCurrentComponent(mode.getDeclaringComponent());
                for (TailCall tc = mode.applyTemplates(ordinaryParams, tunnelParams, initialContext, ExplicitLocation.UNKNOWN_LOCATION); tc != null; tc = tc.processLeavingTail()) {
                }
            } else {
                NamedTemplate t = this.initialTemplate;
                XPathContextMajor c2 = initialContext.newContext();
                initialContext.setOrigin(this);
                c2.setCurrentComponent(t.getDeclaringComponent());
                c2.openStackFrame(t.getStackFrameMap());
                c2.setLocalParameters(ordinaryParams);
                c2.setTunnelParameters(tunnelParams);
                for (TailCall tc = t.expand(c2); tc != null; tc = tc.processLeavingTail()) {
                }
            }
            initialContext.waitForChildThreads();
            this.closeResult(outputDestination, mustClose, initialContext);
        }
        finally {
            this.closeMessageEmitter();
            if (this.traceListener != null) {
                this.traceListener.close();
            }
        }
    }

    private void warningIfStreamable(Mode mode) {
        if (mode.isDeclaredStreamable()) {
            this.warning((this.initialMode == null ? "" : this.initialMode.getModeTitle()) + " is streamable, but the input is not supplied as a stream", null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callTemplate(StructuredQName initialTemplateName, Receiver outputDestination) throws XPathException {
        this.checkReadiness();
        if (this.initialMode != null && !this.initialMode.getModeName().equals(((StylesheetPackage)this.getExecutable().getTopLevelPackage()).getDefaultMode())) {
            throw new XPathException("Initial mode and template cannot both be defined", "XTDE0047");
        }
        this.openMessageEmitter();
        boolean mustClose = false;
        try {
            StylesheetPackage pack;
            Component initialComponent;
            this.principalResult = outputDestination;
            if (this.principalResultURI == null) {
                this.principalResultURI = outputDestination.getSystemId();
            }
            XPathContextMajor initialContext = this.newXPathContext();
            initialContext.createThreadManager();
            initialContext.setOrigin(this);
            if (this.globalContextItem != null) {
                if (this.globalContextItem instanceof NodeInfo) {
                    NodeInfo startNode = (NodeInfo)this.globalContextItem;
                    if (startNode.getConfiguration() == null) {
                        throw new XPathException("The supplied source document must be associated with a Configuration");
                    }
                    if (!startNode.getConfiguration().isCompatible(this.executable.getConfiguration())) {
                        throw new XPathException("Source document and stylesheet must use the same or compatible Configurations", "SXXP0004");
                    }
                    if (startNode.getTreeInfo().isTyped() && !this.executable.isSchemaAware()) {
                        throw new XPathException("Cannot use a schema-validated source document unless the stylesheet is schema-aware");
                    }
                }
                initialContext.setCurrentIterator(new ManualIterator(this.globalContextItem));
            }
            outputDestination = this.openResult(outputDestination, initialContext);
            ParameterSet ordinaryParams = null;
            if (this.initialTemplateParams != null) {
                ordinaryParams = new ParameterSet(this.initialTemplateParams);
            }
            ParameterSet tunnelParams = null;
            if (this.initialTemplateTunnelParams != null) {
                tunnelParams = new ParameterSet(this.initialTemplateTunnelParams);
            }
            if ((initialComponent = (pack = (StylesheetPackage)this.executable.getTopLevelPackage()).getComponent(new SymbolicName(200, initialTemplateName))) == null) {
                throw new XPathException("Template " + initialTemplateName.getDisplayName() + " does not exist (or is not public)", "XTDE0040");
            }
            NamedTemplate t = (NamedTemplate)initialComponent.getActor();
            XPathContextMajor c2 = initialContext.newContext();
            initialContext.setOrigin(this);
            c2.setCurrentComponent(initialComponent);
            c2.openStackFrame(t.getStackFrameMap());
            c2.setLocalParameters(ordinaryParams);
            c2.setTunnelParameters(tunnelParams);
            for (TailCall tc = t.expand(c2); tc != null; tc = tc.processLeavingTail()) {
            }
            initialContext.waitForChildThreads();
            this.closeResult(outputDestination, mustClose, initialContext);
        }
        finally {
            if (this.traceListener != null) {
                this.traceListener.close();
            }
            this.closeMessageEmitter();
            this.inUse = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformStream(Source source, Mode mode, Receiver result) throws XPathException {
        this.openMessageEmitter();
        boolean mustClose = result instanceof StreamResult && ((StreamResult)((Object)result)).getOutputStream() == null;
        try {
            XPathContextMajor initialContext;
            block13: {
                this.principalResult = result;
                if (this.principalResultURI == null) {
                    this.principalResultURI = result.getSystemId();
                }
                initialContext = this.newXPathContext();
                initialContext.setOrigin(this);
                this.globalContextItem = null;
                result = this.openResult(result, initialContext);
                if (!mode.isDeclaredStreamable()) {
                    if (this.config.getBooleanProperty("http://saxon.sf.net/feature/streamingFallback")) {
                        this.warning("Mode is not streamable; attempting fallback to non-streamed evaluation", "", null);
                        TreeInfo doc = this.config.buildDocumentTree(source);
                        this.initialMode = mode;
                        this.transformDocument(doc.getRootNode(), result);
                        return;
                    }
                    throw new XPathException("mode supplied to transformStream() must be streamable");
                }
                Receiver despatcher = this.config.makeStreamingTransformer(initialContext, mode);
                if (despatcher == null) {
                    throw new XPathException("Streaming requires Saxon-EE");
                }
                if (this.config.isStripsAllWhiteSpace() || this.isStylesheetContainingStripSpace()) {
                    despatcher = this.makeStripper(despatcher);
                }
                PipelineConfiguration pipe = despatcher.getPipelineConfiguration();
                pipe.getParseOptions().setSchemaValidationMode(this.validationMode);
                boolean verbose = this.getConfiguration().isTiming();
                if (verbose) {
                    this.getConfiguration().getLogger().info("Streaming " + source.getSystemId());
                }
                try {
                    Sender.send(source, despatcher, null);
                }
                catch (QuitParsingException e) {
                    if (!verbose) break block13;
                    this.getConfiguration().getLogger().info("Streaming " + source.getSystemId() + " : early exit");
                }
            }
            this.closeResult(result, mustClose, initialContext);
        }
        finally {
            if (this.traceListener != null) {
                this.traceListener.close();
            }
            this.closeMessageEmitter();
        }
    }

    public Receiver getStreamingReceiver(Mode mode, Receiver result) throws XPathException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        this.openMessageEmitter();
        final boolean mustClose = result instanceof StreamResult && ((StreamResult)((Object)result)).getOutputStream() == null;
        this.principalResult = result;
        if (this.principalResultURI == null) {
            this.principalResultURI = result.getSystemId();
        }
        final XPathContextMajor initialContext = this.newXPathContext();
        initialContext.setOrigin(this);
        this.globalContextItem = null;
        final Receiver result2 = this.openResult(result, initialContext);
        if (!mode.isDeclaredStreamable()) {
            throw new XPathException("mode supplied to getStreamingReceiver() must be streamable");
        }
        Receiver despatcher = this.config.makeStreamingTransformer(initialContext, mode);
        if (despatcher == null) {
            throw new XPathException("Streaming requires Saxon-EE");
        }
        if (this.config.isStripsAllWhiteSpace() || this.isStylesheetContainingStripSpace()) {
            despatcher = this.makeStripper(despatcher);
        }
        despatcher.setPipelineConfiguration(this.makePipelineConfiguration());
        return new ProxyReceiver(despatcher){

            public void close() throws XPathException {
                if (Controller.this.traceListener != null) {
                    Controller.this.traceListener.close();
                }
                Controller.this.closeResult(result2, mustClose, initialContext);
                Controller.this.closeMessageEmitter();
            }
        };
    }

    private void closeResult(Result result, boolean mustClose, XPathContextMajor initialContext) throws XPathException {
        OutputStream os;
        SequenceReceiver out = initialContext.getReceiver();
        if (this.buildTree) {
            out.endDocument();
        }
        out.close();
        if (mustClose && result instanceof StreamResult && (os = ((StreamResult)result).getOutputStream()) != null) {
            try {
                os.close();
            }
            catch (IOException err) {
                throw new XPathException(err);
            }
        }
    }

    private Receiver openResult(Receiver result, XPathContextMajor initialContext) throws XPathException {
        Receiver receiver = result;
        boolean openNow = false;
        if (this.buildTree && this.getExecutable().createsSecondaryResult()) {
            receiver = new ImplicitResultChecker(receiver, this);
            receiver.setPipelineConfiguration(this.makePipelineConfiguration());
        } else {
            openNow = true;
        }
        receiver.getPipelineConfiguration().setController(this);
        SequenceReceiver out = result instanceof ComplexContentOutputter ? (SequenceReceiver)receiver : (this.buildTree ? ComplexContentOutputter.makeComplexContentReceiver(receiver, null) : (receiver instanceof SequenceReceiver ? (SequenceReceiver)receiver : new TreeReceiver(receiver)));
        initialContext.setReceiver(out);
        if (openNow) {
            out.open();
            if (this.buildTree) {
                out.startDocument(0);
            }
        }
        return result;
    }

    private void openMessageEmitter() throws XPathException {
        if (this.getMessageEmitter() == null) {
            Receiver me = this.makeMessageReceiver();
            this.setMessageEmitter(me);
            if (me instanceof Emitter && ((Emitter)me).getWriter() == null) {
                ((Emitter)me).setStreamResult(this.getConfiguration().getLogger().asStreamResult());
            }
        }
        this.getMessageEmitter().open();
    }

    private void closeMessageEmitter() throws XPathException {
        Receiver me = this.getMessageEmitter();
        if (me != null) {
            me.close();
        }
    }

    public void preEvaluateGlobals(XPathContext context) throws XPathException {
        for (PackageData pack : this.getExecutable().getPackages()) {
            for (GlobalVariable var : pack.getGlobalVariableList()) {
                if (var.isUnused()) continue;
                try {
                    var.evaluateVariable(context, var.getDeclaringComponent());
                }
                catch (XPathException err) {
                    SingletonClosure closure = new SingletonClosure(new ErrorExpression(err), context);
                    this.getBindery(var.getPackageData()).setGlobalVariable(var, closure);
                }
            }
        }
    }

    public synchronized void registerGlobalVariableDependency(GlobalVariable one, GlobalVariable two) throws XPathException {
        Set<GlobalVariable> existingDependencies;
        if (one == two) {
            throw new XPathException.Circularity("Circular dependency among global variables: " + one.getVariableQName().getDisplayName() + " depends on its own value");
        }
        Set<GlobalVariable> transitiveDependencies = this.globalVariableDependencies.get(two);
        if (transitiveDependencies != null) {
            if (transitiveDependencies.contains(one)) {
                throw new XPathException.Circularity("Circular dependency among variables: " + one.getVariableQName().getDisplayName() + " depends on the value of " + two.getVariableQName().getDisplayName() + ", which depends directly or indirectly on the value of " + one.getVariableQName().getDisplayName());
            }
            for (GlobalVariable var : transitiveDependencies) {
                this.registerGlobalVariableDependency(one, var);
            }
        }
        if ((existingDependencies = this.globalVariableDependencies.get(one)) == null) {
            existingDependencies = new HashSet<GlobalVariable>();
            this.globalVariableDependencies.put(one, existingDependencies);
        }
        existingDependencies.add(two);
    }

    public void setCurrentDateTime(DateTimeValue dateTime) throws XPathException {
        if (this.currentDateTime == null) {
            if (dateTime.getComponent(AccessorFn.Component.TIMEZONE) == null) {
                throw new XPathException("No timezone is present in supplied value of current date/time");
            }
        } else {
            throw new IllegalStateException("Current date and time can only be set once, and cannot subsequently be changed");
        }
        this.currentDateTime = dateTime;
        this.dateTimePreset = true;
    }

    public DateTimeValue getCurrentDateTime() {
        if (this.currentDateTime == null) {
            this.currentDateTime = new DateTimeValue(new GregorianCalendar(), true);
        }
        return this.currentDateTime;
    }

    public int getImplicitTimezone() {
        return this.getCurrentDateTime().getTimezoneInMinutes();
    }

    public XPathContextMajor newXPathContext() {
        XPathContextMajor c = new XPathContextMajor(this);
        c.setCurrentOutputUri(this.principalResultURI);
        return c;
    }

    public synchronized void setRememberedNumber(NodeInfo node, int number) {
        this.lastRememberedNode = node;
        this.lastRememberedNumber = number;
    }

    public synchronized int getRememberedNumber(NodeInfo node) {
        if (this.lastRememberedNode == node) {
            return this.lastRememberedNumber;
        }
        return -1;
    }

    public void setUseDocumentProjection(PathMap pathMap) {
        this.pathMap = pathMap;
    }

    public PathMap getPathMapForDocumentProjection() {
        return this.pathMap;
    }

    public Stack<AttributeSet> getAttributeSetEvaluationStack() {
        return this.attributeSetEvaluationStack;
    }

    public synchronized StylesheetCache getStylesheetCache() {
        if (this.stylesheetCache == null) {
            this.stylesheetCache = new StylesheetCache();
        }
        return this.stylesheetCache;
    }
}

