/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.functions.RegexFunction;
import net.sf.saxon.lib.StandardEntityResolver;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AnalyzeStringFn
extends RegexFunction {
    private NodeName resultName;
    private NodeName nonMatchName;
    private NodeName matchName;
    private NodeName groupName;
    private NodeName groupNrName;
    private SchemaType resultType = Untyped.getInstance();
    private SchemaType nonMatchType = Untyped.getInstance();
    private SchemaType matchType = Untyped.getInstance();
    private SchemaType groupType = Untyped.getInstance();
    private SimpleType groupNrType = BuiltInAtomicType.UNTYPED_ATOMIC;

    protected boolean allowRegexMatchingEmptyString() {
        return false;
    }

    private synchronized void init(Configuration config, boolean schemaAware) throws XPathException {
        this.resultName = new FingerprintedQName("", "http://www.w3.org/2005/xpath-functions", "analyze-string-result");
        this.nonMatchName = new FingerprintedQName("", "http://www.w3.org/2005/xpath-functions", "non-match");
        this.matchName = new FingerprintedQName("", "http://www.w3.org/2005/xpath-functions", "match");
        this.groupName = new FingerprintedQName("", "http://www.w3.org/2005/xpath-functions", "group");
        this.groupNrName = new NoNamespaceName("nr");
        if (schemaAware) {
            this.resultType = config.getSchemaType(new StructuredQName("", "http://www.w3.org/2005/xpath-functions", "analyze-string-result-type"));
            this.nonMatchType = BuiltInAtomicType.STRING;
            this.matchType = config.getSchemaType(new StructuredQName("", "http://www.w3.org/2005/xpath-functions", "match-type"));
            this.groupType = config.getSchemaType(new StructuredQName("", "http://www.w3.org/2005/xpath-functions", "group-type"));
            this.groupNrType = BuiltInAtomicType.POSITIVE_INTEGER;
            if (this.resultType == null || this.matchType == null || this.groupType == null) {
                throw new XPathException("Schema for analyze-string has not been successfully loaded");
            }
        }
    }

    public NodeInfo call(XPathContext context, Sequence[] arguments) throws XPathException {
        Item item;
        Item inputItem = arguments[0].head();
        CharSequence input = inputItem == null ? "" : inputItem.getStringValueCS();
        RegularExpression re = this.getRegularExpression(arguments);
        RegexIterator iter = re.analyze(input);
        if (this.resultName == null) {
            boolean schemaAware = context.getController().getExecutable().isSchemaAware();
            Configuration config = context.getConfiguration();
            if (schemaAware && !config.isSchemaAvailable("http://www.w3.org/2005/xpath-functions")) {
                try {
                    StandardEntityResolver resolver = new StandardEntityResolver();
                    resolver.setConfiguration(config);
                    InputSource is = resolver.resolveEntity(null, "classpath:xpath-functions.xsd");
                    if (is == null) {
                        throw new XPathException("Failed to load xpath-functions.xsd from the classpath");
                    }
                    if (config.isTiming()) {
                        config.getLogger().info("Loading schema from resources for: http://www.w3.org/2005/xpath-functions");
                    }
                    config.addSchemaSource(new SAXSource(is));
                }
                catch (SAXException e) {
                    throw new XPathException(e);
                }
                catch (IOException e) {
                    throw new XPathException(e);
                }
            }
            this.init(context.getConfiguration(), schemaAware);
        }
        Builder builder = context.getController().makeBuilder();
        final NamespaceReducer out = new NamespaceReducer(builder);
        builder.setBaseURI(this.getStaticBaseUriString());
        out.open();
        out.startElement(this.resultName, this.resultType, ExplicitLocation.UNKNOWN_LOCATION, 0);
        out.startContent();
        while ((item = iter.next()) != null) {
            if (iter.isMatching()) {
                out.startElement(this.matchName, this.matchType, ExplicitLocation.UNKNOWN_LOCATION, 0);
                out.startContent();
                iter.processMatchingSubstring(new RegexIterator.MatchHandler(){

                    public void characters(CharSequence s) throws XPathException {
                        out.characters(s, ExplicitLocation.UNKNOWN_LOCATION, 0);
                    }

                    public void onGroupStart(int groupNumber) throws XPathException {
                        out.startElement(AnalyzeStringFn.this.groupName, AnalyzeStringFn.this.groupType, ExplicitLocation.UNKNOWN_LOCATION, 0);
                        out.attribute(AnalyzeStringFn.this.groupNrName, AnalyzeStringFn.this.groupNrType, "" + groupNumber, ExplicitLocation.UNKNOWN_LOCATION, 0);
                        out.startContent();
                    }

                    public void onGroupEnd(int groupNumber) throws XPathException {
                        out.endElement();
                    }
                });
                out.endElement();
                continue;
            }
            out.startElement(this.nonMatchName, this.nonMatchType, ExplicitLocation.UNKNOWN_LOCATION, 0);
            out.startContent();
            out.characters(item.getStringValueCS(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            out.endElement();
        }
        out.endElement();
        out.close();
        return builder.getCurrentRoot();
    }
}

