/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Component;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.style.ComponentAcceptor;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLAcceptExpose;
import net.sf.saxon.style.XSLUsePackage;
import net.sf.saxon.trans.ComponentTest;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;

public class XSLAccept
extends XSLAcceptExpose
implements ComponentAcceptor {
    protected void prepareAttributes() throws XPathException {
        super.prepareAttributes();
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeImpl parent = this.getParent();
        if (!(parent instanceof XSLUsePackage)) {
            this.compileError("Parent of xsl:accept must be xsl:use-package");
            return;
        }
        StylesheetPackage pack = ((XSLUsePackage)parent).getUsedPackage();
        if (pack != null) {
            for (ComponentTest test : this.getExplicitComponentTests()) {
                QNameTest nameTest = test.getQNameTest();
                if (!(nameTest instanceof NameTest)) continue;
                int kind = test.getComponentKind();
                SymbolicName sName = kind == 158 ? new SymbolicName.F(((NameTest)nameTest).getMatchingNodeName(), test.getArity()) : new SymbolicName(kind, ((NameTest)nameTest).getMatchingNodeName());
                Component comp = pack.getComponent(sName);
                boolean found = false;
                if (comp == null) {
                    if (kind == 158 && test.getArity() == -1) {
                        for (int i = 0; i <= pack.getMaxFunctionArity(); ++i) {
                            sName = new SymbolicName.F(((NameTest)nameTest).getMatchingNodeName(), i);
                            comp = pack.getComponent(sName);
                            if (comp == null) continue;
                            this.checkCompatibility(sName, comp.getVisibility(), this.getVisibility());
                            found = true;
                        }
                    }
                } else {
                    this.checkCompatibility(sName, comp.getVisibility(), this.getVisibility());
                    found = true;
                }
                if (found) continue;
                this.compileError("No " + sName.toString() + " exists in the used package", "XTSE3030");
            }
        }
    }

    public void acceptComponent(Component component) throws XPathException {
        for (ComponentTest test : this.getExplicitComponentTests()) {
            if (!test.matches(component.getActor())) continue;
            component.setVisibility(this.getVisibility(), false);
            return;
        }
        for (ComponentTest test : this.getWildcardComponentTests()) {
            if (!test.matches(component.getActor()) || !XSLAccept.isCompatible(component.getVisibility(), this.getVisibility())) continue;
            component.setVisibility(this.getVisibility(), false);
            return;
        }
    }
}

