/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.attribute.filter.testing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.shared.component.AbstractIdentifiedInitializableComponent;

/** A simple, mock implementation of {@link Matcher}. */
public class MockPolicyRequirementRule extends AbstractIdentifiedInitializableComponent implements
        PolicyRequirementRule {

    /** state variable */
    private boolean initialized;

    /** to return from matcher(). */
    @Nullable private Tristate retVal;

    /** Constructor. */
    public MockPolicyRequirementRule() {
        setId("Mock");
    }

    /** {@inheritDoc} */
    @Override
    public boolean isInitialized() {
        return initialized;
    }

    /** {@inheritDoc} */
    @Override
    public void doInitialize() {
        initialized = true;
    }

    /** Set what to return
     * @param what what to return
     */
    public void setRetVal(Tristate what) {
        retVal = what;
    }

    /** {@inheritDoc} */
    @Override
    @Nonnull public Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        return retVal != null ? retVal : Tristate.FAIL;
    }
    
}