/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.BasicNamingFunction;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAML1AttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.impl.SAML1StringAttributeTranscoder;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.testing.MockApplicationContext;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeDesignator;
import org.opensaml.saml.saml1.core.AttributeValue;
import org.springframework.context.ApplicationContext;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SAML1StringAttributeTranscoderTest
extends OpenSAMLInitBaseTestCase {
    private AttributeTranscoderRegistryImpl registry;
    private XMLObjectBuilder<XSString> stringBuilder;
    private SAMLObjectBuilder<Attribute> attributeBuilder;
    private SAMLObjectBuilder<AttributeDesignator> designatorBuilder;
    @Nonnull
    @NotEmpty
    private static final String ATTR_NAME = "foo";
    @Nonnull
    @NotEmpty
    private static final String ATTR_NAMESPACE = "Namespace";
    @Nonnull
    @NotEmpty
    private static final String STRING_1 = "Value The First";
    @Nonnull
    @NotEmpty
    private static final String STRING_2 = "Second string the value is";

    @BeforeClass
    public void setUp() throws ComponentInitializationException {
        this.stringBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(XSString.TYPE_NAME);
        this.attributeBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Attribute.TYPE_NAME);
        this.designatorBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(AttributeDesignator.TYPE_NAME);
        this.registry = new AttributeTranscoderRegistryImpl();
        this.registry.setId("test");
        SAML1StringAttributeTranscoder transcoder = new SAML1StringAttributeTranscoder();
        transcoder.initialize();
        this.registry.setNamingRegistry((Collection)CollectionSupport.singletonList((Object)new BasicNamingFunction(transcoder.getEncodedType(), (Function)new AbstractSAML1AttributeTranscoder.NamingFunction())));
        HashMap<String, Object> ruleset1 = new HashMap<String, Object>();
        ruleset1.put("id", ATTR_NAME);
        ruleset1.put("transcoder", transcoder);
        ruleset1.put("saml1.encodeType", true);
        ruleset1.put("saml1.name", ATTR_NAME);
        ruleset1.put("saml1.namespace", ATTR_NAMESPACE);
        this.registry.setTranscoderRegistry((Collection)CollectionSupport.singletonList((Object)new TranscodingRule(ruleset1)));
        this.registry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        this.registry.initialize();
    }

    @AfterClass
    public void tearDown() {
        this.registry.destroy();
        this.registry = null;
    }

    @Test(expectedExceptions={AttributeEncodingException.class})
    public void emptyEncode() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
    }

    @Test
    public void emptyRequestedEncode() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, AttributeDesignator.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        AttributeDesignator attr = (AttributeDesignator)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, AttributeDesignator.class, ruleset);
        assert (attr != null);
        Assert.assertEquals((String)attr.getAttributeName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getAttributeNamespace(), (String)ATTR_NAMESPACE);
    }

    @Test
    public void emptyDecode() throws Exception {
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setAttributeName(ATTR_NAME);
        samlAttribute.setAttributeNamespace(ATTR_NAMESPACE);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        assert (attr != null);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test
    public void emptyRequestedDecode() throws Exception {
        AttributeDesignator samlAttribute = (AttributeDesignator)this.designatorBuilder.buildObject();
        samlAttribute.setAttributeName(ATTR_NAME);
        samlAttribute.setAttributeNamespace(ATTR_NAMESPACE);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        assert (attr != null);
        Assert.assertTrue((boolean)(attr instanceof IdPRequestedAttribute));
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertFalse((boolean)((IdPRequestedAttribute)attr).isRequired());
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test(expectedExceptions={AttributeEncodingException.class})
    public void inappropriate() throws Exception {
        final int[] intArray = new int[]{1, 2, 3, 4};
        List values = CollectionSupport.listOf((Object)new ByteAttributeValue(new byte[]{1, 2, 3}), (Object)new IdPAttributeValue(){

            @Nonnull
            public Object getNativeValue() {
                return intArray;
            }

            @Nonnull
            public String getDisplayValue() {
                String result = intArray.toString();
                assert (result != null);
                return result;
            }
        });
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
    }

    @Test
    public void single() throws Exception {
        List values = CollectionSupport.listOf((Object)new ByteAttributeValue(new byte[]{1, 2, 3}), (Object)new StringAttributeValue(STRING_1));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        assert (attr != null);
        Assert.assertEquals((String)attr.getAttributeName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getAttributeNamespace(), (String)ATTR_NAMESPACE);
        List children = attr.getOrderedChildren();
        assert (children != null);
        Assert.assertEquals((int)children.size(), (int)1, (String)"Encoding one entry");
        XMLObject child = (XMLObject)children.get(0);
        Assert.assertEquals((Object)child.getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        Assert.assertTrue((boolean)(child instanceof XSString), (String)"Child of result attribute should be a string");
        XSString childAsString = (XSString)child;
        Assert.assertEquals((String)childAsString.getValue(), (String)STRING_1);
    }

    @Test
    public void singleRequested() throws Exception {
        List values = CollectionSupport.listOf((Object)new ByteAttributeValue(new byte[]{1, 2, 3}), (Object)new StringAttributeValue(STRING_1));
        IdPRequestedAttribute inputAttribute = new IdPRequestedAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules((IdPAttribute)inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        AttributeDesignator attr = (AttributeDesignator)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, (IdPAttribute)inputAttribute, AttributeDesignator.class, ruleset);
        assert (attr != null);
        Assert.assertEquals((String)attr.getAttributeName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getAttributeNamespace(), (String)ATTR_NAMESPACE);
    }

    @Test
    public void singleDecode() throws Exception {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue.setValue(STRING_1);
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setAttributeName(ATTR_NAME);
        samlAttribute.setAttributeNamespace(ATTR_NAMESPACE);
        samlAttribute.getAttributeValues().add(stringValue);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        assert (attr != null);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertEquals((int)attr.getValues().size(), (int)1);
        Assert.assertEquals((String)((StringAttributeValue)attr.getValues().get(0)).getValue().toString(), (String)STRING_1);
    }

    @Test
    public void multi() throws Exception {
        List values = CollectionSupport.listOf((Object[])new IdPAttributeValue[]{new ByteAttributeValue(new byte[]{1, 2, 3}), new StringAttributeValue(STRING_1), new StringAttributeValue(STRING_2), new ScopedStringAttributeValue(STRING_1, STRING_2)});
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        assert (attr != null);
        List children = attr.getOrderedChildren();
        assert (children != null);
        Assert.assertEquals((int)children.size(), (int)3, (String)"Encoding three entries");
        for (XMLObject child : children) {
            Assert.assertTrue((boolean)(child instanceof XSString), (String)"Child of result attribute should be a string");
            String childAsString = ((XSString)children.get(0)).getValue();
            Assert.assertTrue((STRING_1.equals(childAsString) || STRING_2.equals(childAsString) ? 1 : 0) != 0);
        }
    }

    @Test
    public void multiDecode() throws Exception {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue.setValue(STRING_1);
        XSString stringValue2 = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue2.setValue(STRING_2);
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setAttributeName(ATTR_NAME);
        samlAttribute.setAttributeNamespace(ATTR_NAMESPACE);
        samlAttribute.getAttributeValues().add(stringValue);
        samlAttribute.getAttributeValues().add(stringValue2);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        assert (attr != null);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertEquals((int)attr.getValues().size(), (int)2);
        Assert.assertEquals((String)((StringAttributeValue)attr.getValues().get(0)).getValue().toString(), (String)STRING_1);
        Assert.assertEquals((String)((StringAttributeValue)attr.getValues().get(1)).getValue().toString(), (String)STRING_2);
    }
}

