/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding.impl;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.DateTimeAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.transcoding.BasicNamingFunction;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAML2AttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.impl.SAML2DateTimeAttributeTranscoder;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.testing.MockApplicationContext;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.springframework.context.ApplicationContext;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SAML2DateTimeAttributeTranscoderTest
extends OpenSAMLInitBaseTestCase {
    private AttributeTranscoderRegistryImpl registry;
    private XMLObjectBuilder<XSString> stringBuilder;
    private XMLObjectBuilder<XSDateTime> dateTimeBuilder;
    private SAMLObjectBuilder<Attribute> attributeBuilder;
    private SAMLObjectBuilder<RequestedAttribute> reqAttributeBuilder;
    @Nonnull
    @NotEmpty
    private static final String ATTR_NAME = "foo";
    @Nonnull
    @NotEmpty
    private static final String ATTR_NAMEFORMAT = "Namespace";
    @Nonnull
    @NotEmpty
    private static final String ATTR_FRIENDLYNAME = "friendly";
    @Nonnull
    @NotEmpty
    private static final String STRING_SECS = "1659979872";
    @Nonnull
    @NotEmpty
    private static final String STRING_MSECS = "1659979872969";
    @Nonnull
    @NotEmpty
    private static final String STRING_ISO = "2022-08-08T17:31:12.969Z";
    @Nonnull
    @NotEmpty
    private static final String STRING_INVALID = "invalid";

    @BeforeClass
    public void setUp() throws ComponentInitializationException {
        this.stringBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(XSString.TYPE_NAME);
        this.dateTimeBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(XSDateTime.TYPE_NAME);
        this.attributeBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Attribute.TYPE_NAME);
        this.reqAttributeBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(RequestedAttribute.TYPE_NAME);
        this.registry = new AttributeTranscoderRegistryImpl();
        this.registry.setId("test");
        SAML2DateTimeAttributeTranscoder transcoder = new SAML2DateTimeAttributeTranscoder();
        transcoder.initialize();
        this.registry.setNamingRegistry((Collection)CollectionSupport.singletonList((Object)new BasicNamingFunction(transcoder.getEncodedType(), (Function)new AbstractSAML2AttributeTranscoder.NamingFunction())));
        HashMap<String, Object> ruleset1 = new HashMap<String, Object>();
        ruleset1.put("id", ATTR_NAME);
        ruleset1.put("transcoder", transcoder);
        ruleset1.put("saml2.encodeType", true);
        ruleset1.put("saml2.name", ATTR_NAME);
        ruleset1.put("saml2.nameFormat", ATTR_NAMEFORMAT);
        ruleset1.put("saml2.friendlyName", ATTR_FRIENDLYNAME);
        this.registry.setTranscoderRegistry((Collection)CollectionSupport.singletonList((Object)new TranscodingRule(ruleset1)));
        this.registry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        this.registry.initialize();
    }

    @AfterClass
    public void tearDown() {
        this.registry.destroy();
        this.registry = null;
    }

    @Test
    public void emptyEncode() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        assert (attr != null);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getNameFormat(), (String)ATTR_NAMEFORMAT);
        Assert.assertEquals((String)attr.getFriendlyName(), (String)ATTR_FRIENDLYNAME);
        Assert.assertTrue((boolean)attr.getAttributeValues().isEmpty());
    }

    @Test
    public void emptyDecode() throws Exception {
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        assert (attr != null);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test
    public void invalidDecode() throws Exception {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue.setValue(STRING_INVALID);
        XSString stringValue2 = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue2.setValue(STRING_ISO);
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.getAttributeValues().add(stringValue);
        samlAttribute.getAttributeValues().add(stringValue2);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        assert (attr != null);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertEquals((int)attr.getValues().size(), (int)1);
    }

    @Test
    public void emptyRequestedDecode() throws Exception {
        RequestedAttribute samlAttribute = (RequestedAttribute)this.reqAttributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.setIsRequired(Boolean.valueOf(true));
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        assert (attr != null);
        Assert.assertTrue((boolean)(attr instanceof IdPRequestedAttribute));
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)((IdPRequestedAttribute)attr).isRequired());
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test(expectedExceptions={AttributeEncodingException.class})
    public void inappropriate() throws Exception {
        final int[] intArray = new int[]{1, 2, 3, 4};
        List<1> values = List.of(new ByteAttributeValue(new byte[]{1, 2, 3}), new IdPAttributeValue(){

            @Nonnull
            public Object getNativeValue() {
                return intArray;
            }

            @Nonnull
            public String getDisplayValue() {
                String result = intArray.toString();
                assert (result != null);
                return result;
            }
        });
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
    }

    @Test
    public void single() throws Exception {
        List<DateTimeAttributeValue> values = List.of(new ByteAttributeValue(new byte[]{1, 2, 3}), new DateTimeAttributeValue(Instant.parse(STRING_ISO)));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        assert (attr != null);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getNameFormat(), (String)ATTR_NAMEFORMAT);
        Assert.assertEquals((String)attr.getFriendlyName(), (String)ATTR_FRIENDLYNAME);
        List children = attr.getOrderedChildren();
        assert (children != null);
        Assert.assertEquals((int)children.size(), (int)1, (String)"Encoding one entry");
        XMLObject child = (XMLObject)children.get(0);
        Assert.assertEquals((Object)child.getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        Assert.assertTrue((boolean)(child instanceof XSDateTime), (String)"Child of result attribute should be a string");
        XSDateTime childAsString = (XSDateTime)child;
        Assert.assertEquals((Object)childAsString.getValue(), (Object)Instant.parse(STRING_ISO));
    }

    @Test
    public void singleRequested() throws Exception {
        List<DateTimeAttributeValue> values = List.of(new ByteAttributeValue(new byte[]{1, 2, 3}), new DateTimeAttributeValue(Instant.ofEpochSecond(Long.valueOf(STRING_SECS))));
        IdPRequestedAttribute inputAttribute = new IdPRequestedAttribute(ATTR_NAME);
        inputAttribute.setRequired(true);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules((IdPAttribute)inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        RequestedAttribute attr = (RequestedAttribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, (IdPAttribute)inputAttribute, RequestedAttribute.class, ruleset);
        assert (attr != null);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getNameFormat(), (String)ATTR_NAMEFORMAT);
        Assert.assertEquals((String)attr.getFriendlyName(), (String)ATTR_FRIENDLYNAME);
        Boolean isRequired = attr.isRequired();
        Assert.assertTrue((isRequired != null && isRequired != false ? 1 : 0) != 0);
        List children = attr.getOrderedChildren();
        assert (children != null);
        Assert.assertEquals((int)children.size(), (int)1, (String)"Encoding one entry");
        XMLObject child = (XMLObject)children.get(0);
        Assert.assertEquals((Object)child.getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        Assert.assertTrue((boolean)(child instanceof XSDateTime), (String)"Child of result attribute should be a string");
        Instant val = ((XSDateTime)child).getValue();
        assert (val != null);
        Assert.assertEquals((long)val.getEpochSecond(), (Long)Long.valueOf(STRING_SECS));
    }

    @Test
    public void singleDecodeString() throws Exception {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue.setValue(STRING_ISO);
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.getAttributeValues().add(stringValue);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        assert (attr != null);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertEquals((int)attr.getValues().size(), (int)1);
        Assert.assertEquals((String)((DateTimeAttributeValue)attr.getValues().get(0)).getValue().toString(), (String)STRING_ISO);
    }

    @Test
    public void singleRequestedDecode() throws Exception {
        XSDateTime dateTimeValue = (XSDateTime)this.dateTimeBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        dateTimeValue.setValue(Instant.ofEpochMilli(Long.valueOf(STRING_MSECS)));
        RequestedAttribute samlAttribute = (RequestedAttribute)this.reqAttributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.setIsRequired(Boolean.valueOf(true));
        samlAttribute.getAttributeValues().add(dateTimeValue);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        assert (ruleset != null);
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        assert (attr != null);
        Assert.assertTrue((boolean)(attr instanceof IdPRequestedAttribute));
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)((IdPRequestedAttribute)attr).isRequired());
        Assert.assertEquals((int)attr.getValues().size(), (int)1);
        Assert.assertEquals((String)((DateTimeAttributeValue)attr.getValues().get(0)).getValue().toString(), (String)STRING_ISO);
    }
}

