/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.resolver.impl;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;

@ThreadSafe
public class EntityAttributesDataConnector
extends AbstractDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EntityAttributesDataConnector.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy = new ChildContextLookup(SAMLMetadataContext.class).compose(new ChildContextLookup(SAMLPeerEntityContext.class).compose((Function)new InboundMessageContextLookup()));

    public void setMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        this.metadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLMetadataContext strategy cannot be null");
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        EntityDescriptor entity;
        SAMLMetadataContext metadataContext = this.metadataContextLookupStrategy.apply((ProfileRequestContext)resolutionContext.getProfileRequestContextLookupStrategy().apply(resolutionContext));
        EntityDescriptor entityDescriptor = entity = metadataContext != null ? metadataContext.getEntityDescriptor() : null;
        if (entity == null) {
            this.log.debug("Specified metadata source was absent.");
            return CollectionSupport.emptyMap();
        }
        HashMap<String, IdPAttribute> results = new HashMap<String, IdPAttribute>();
        try {
            this.resolveMappedTags((XMLObject)entity, results);
        }
        catch (CloneNotSupportedException e) {
            throw new ResolutionException((Exception)e);
        }
        XMLObject parent = entity.getParent();
        while (parent instanceof EntitiesDescriptor) {
            EntitiesDescriptor entities = (EntitiesDescriptor)parent;
            try {
                this.resolveMappedTags((XMLObject)entities, results);
            }
            catch (CloneNotSupportedException e) {
                throw new ResolutionException((Exception)e);
            }
            parent = parent.getParent();
        }
        if (results.isEmpty()) {
            this.log.trace("{} No entity attributes resolved", (Object)this.getLogPrefix());
            return CollectionSupport.emptyMap();
        }
        this.log.trace("{} Resolved attributes: {}", (Object)this.getLogPrefix(), results);
        return results;
    }

    private void resolveMappedTags(@Nonnull XMLObject parent, @Nonnull Map<String, IdPAttribute> results) throws CloneNotSupportedException {
        AttributesMapContainer container;
        Multimap tags;
        List containerList = parent.getObjectMetadata().get(AttributesMapContainer.class);
        if (containerList != null && !containerList.isEmpty() && !(tags = (container = (AttributesMapContainer)containerList.get(0)).get()).isEmpty()) {
            for (IdPAttribute attribute : tags.values()) {
                if (results.containsKey(attribute.getId())) {
                    IdPAttribute existing = results.get(attribute.getId());
                    ArrayList union = new ArrayList(existing.getValues());
                    union.addAll(attribute.getValues());
                    existing.setValues(union);
                    continue;
                }
                results.put(attribute.getId(), attribute.clone());
            }
        }
    }
}

