/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAML1AttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.SAMLEncoderSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml1.core.AttributeDesignator;
import org.opensaml.saml.saml1.core.AttributeValue;
import org.slf4j.Logger;

public class SAML1StringAttributeTranscoder
extends AbstractSAML1AttributeTranscoder<StringAttributeValue> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML1StringAttributeTranscoder.class);

    protected boolean canEncodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) {
        return value instanceof StringAttributeValue;
    }

    @Nullable
    protected XMLObject encodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule, @Nonnull StringAttributeValue value) throws AttributeEncodingException {
        if (value instanceof ScopedStringAttributeValue) {
            this.log.warn("Attribute '{}': Lossy encoding of attribute value of type {} to SAML1 String Attribute", (Object)attribute.getId(), (Object)value.getClass().getSimpleName());
        }
        Boolean encodeType = (Boolean)rule.getOrDefault("saml1.encodeType", Boolean.class, (Object)Boolean.TRUE);
        assert (encodeType != null);
        return SAMLEncoderSupport.encodeStringValue((IdPAttribute)attribute, (QName)AttributeValue.DEFAULT_ELEMENT_NAME, (String)value.getValue(), (boolean)encodeType);
    }

    @Nullable
    protected IdPAttributeValue decodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull AttributeDesignator attribute, @Nonnull TranscodingRule rule, @Nullable XMLObject value) {
        String stringValue = this.getStringValue(value);
        if (null == stringValue) {
            return null;
        }
        return StringAttributeValue.valueOf((String)stringValue);
    }
}

