/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import net.snowflake.client.jdbc.SnowflakeUtil;

public class SnowflakeTimeWithTimezone
extends Time {
    int nanos = 0;
    boolean useSessionTimeZone = false;
    ZoneOffset offset = ZoneOffset.UTC;

    public SnowflakeTimeWithTimezone(long time, int nanos, boolean useSessionTimeZone) {
        super(time);
        this.nanos = nanos;
        this.useSessionTimeZone = useSessionTimeZone;
    }

    public SnowflakeTimeWithTimezone(Timestamp ts, TimeZone sessionTimeZone, boolean useSessionTimeZone) {
        super(ts.getTime());
        this.nanos = ts.getNanos();
        this.useSessionTimeZone = useSessionTimeZone;
        if (sessionTimeZone != null) {
            this.offset = ZoneId.of(sessionTimeZone.getID()).getRules().getOffset(ts.toInstant());
        }
    }

    @Override
    public synchronized String toString() {
        if (!this.useSessionTimeZone) {
            return super.toString();
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(SnowflakeUtil.getSecondsFromMillis(this.getTime()), this.nanos, this.offset);
        return ldt.format(formatter);
    }
}

