/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.tika.utils;

import net.snowflake.client.jdbc.internal.apache.tika.metadata.Metadata;
import net.snowflake.client.jdbc.internal.apache.tika.metadata.Property;
import net.snowflake.client.jdbc.internal.apache.tika.parser.Parser;
import net.snowflake.client.jdbc.internal.apache.tika.parser.ParserDecorator;
import net.snowflake.client.jdbc.internal.apache.tika.utils.ExceptionUtils;

public class ParserUtils {
    public static final String X_PARSED_BY = "X-Parsed-By";
    public static final Property EMBEDDED_PARSER = Property.internalText("X-TIKA:EXCEPTION:embedded_parser");
    public static final Property EMBEDDED_EXCEPTION = Property.internalText("X-TIKA:EXCEPTION:embedded_exception");

    public static Metadata cloneMetadata(Metadata m3) {
        Metadata clone = new Metadata();
        for (String n : m3.names()) {
            if (!m3.isMultiValued(n)) {
                clone.set(n, m3.get(n));
                continue;
            }
            String[] vals = m3.getValues(n);
            for (int i = 0; i < vals.length; ++i) {
                clone.add(n, vals[i]);
            }
        }
        return clone;
    }

    public static String getParserClassname(Parser parser) {
        if (parser instanceof ParserDecorator) {
            return ((ParserDecorator)parser).getWrappedParser().getClass().getName();
        }
        return parser.getClass().getName();
    }

    public static void recordParserDetails(Parser parser, Metadata metadata) {
        metadata.add(X_PARSED_BY, ParserUtils.getParserClassname(parser));
    }

    public static void recordParserFailure(Parser parser, Throwable failure, Metadata metadata) {
        String trace = ExceptionUtils.getStackTrace(failure);
        metadata.add(EMBEDDED_EXCEPTION, trace);
        metadata.add(EMBEDDED_PARSER, ParserUtils.getParserClassname(parser));
    }
}

