/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage.queue;

import net.snowflake.client.jdbc.internal.microsoft.azure.storage.RequestOptions;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Utility;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.queue.CloudQueueClient;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.queue.QueueEncryptionPolicy;

public final class QueueRequestOptions
extends RequestOptions {
    private QueueEncryptionPolicy encryptionPolicy;

    public QueueRequestOptions() {
    }

    public QueueRequestOptions(QueueRequestOptions other) {
        super(other);
        if (other != null) {
            this.setEncryptionPolicy(other.getEncryptionPolicy());
        }
    }

    protected static final QueueRequestOptions populateAndApplyDefaults(QueueRequestOptions options, CloudQueueClient client) {
        QueueRequestOptions modifiedOptions = new QueueRequestOptions(options);
        QueueRequestOptions.populateRequestOptions(modifiedOptions, client.getDefaultRequestOptions());
        QueueRequestOptions.applyDefaults(modifiedOptions);
        return modifiedOptions;
    }

    protected static void applyDefaults(QueueRequestOptions modifiedOptions) {
        Utility.assertNotNull("modifiedOptions", modifiedOptions);
        RequestOptions.applyBaseDefaultsInternal(modifiedOptions);
    }

    private static void populateRequestOptions(QueueRequestOptions modifiedOptions, QueueRequestOptions clientOptions) {
        RequestOptions.populateRequestOptions(modifiedOptions, clientOptions, true);
        if (modifiedOptions.getEncryptionPolicy() == null) {
            modifiedOptions.setEncryptionPolicy(clientOptions.getEncryptionPolicy());
        }
    }

    public QueueEncryptionPolicy getEncryptionPolicy() {
        return this.encryptionPolicy;
    }

    public void setEncryptionPolicy(QueueEncryptionPolicy encryptionPolicy) {
        this.encryptionPolicy = encryptionPolicy;
    }

    protected void assertPolicyIfRequired() {
        if (this.requireEncryption() != null && this.requireEncryption().booleanValue() && this.getEncryptionPolicy() == null) {
            throw new IllegalArgumentException("Encryption Policy is mandatory when RequireEncryption is set to true. If you do not want to encrypt/decrypt data, please set RequireEncryption to false in request options.");
        }
    }
}

