/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.analytics;

import com.microsoft.azure.storage.core.Utility;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.UUID;
import net.snowflake.client.jdbc.internal.apache.commons.lang3.StringEscapeUtils;

class LogRecordStreamReader
extends InputStreamReader {
    public static final char FIELD_DELIMITER = ';';
    public static final char RECORD_DELIMITER = '\n';
    public static final char QUOTE_CHAR = '\"';
    private boolean isFirstFieldInRecord = true;
    private Integer peekedCharacter = null;

    public LogRecordStreamReader(InputStream stream) {
        super(stream);
    }

    public boolean hasMoreFieldsInRecord() throws IOException {
        return this.tryPeekDelimiter(';');
    }

    public boolean isEndOfFile() throws IOException {
        return this.peek() == -1;
    }

    public String readString() throws IOException {
        String temp = this.readField(false);
        if (Utility.isNullOrEmpty(temp)) {
            return null;
        }
        return temp;
    }

    public String readQuotedString() throws IOException {
        String temp = this.readField(true);
        if (Utility.isNullOrEmpty(temp)) {
            return null;
        }
        return temp;
    }

    public Boolean readBoolean() throws IOException {
        String temp = this.readField(false);
        if (Utility.isNullOrEmpty(temp)) {
            return null;
        }
        return Boolean.parseBoolean(temp);
    }

    public Date readDate(DateFormat format) throws IOException, ParseException {
        String temp = this.readField(false);
        if (Utility.isNullOrEmpty(temp)) {
            return null;
        }
        return format.parse(temp);
    }

    public Double readDouble() throws IOException {
        String temp = this.readField(false);
        if (Utility.isNullOrEmpty(temp)) {
            return null;
        }
        return Double.parseDouble(temp);
    }

    public UUID readUuid() throws IOException {
        String temp = this.readField(false);
        if (Utility.isNullOrEmpty(temp)) {
            return null;
        }
        return UUID.fromString(temp);
    }

    public Integer readInteger() throws IOException {
        String temp = this.readField(false);
        if (Utility.isNullOrEmpty(temp)) {
            return null;
        }
        return Integer.parseInt(temp);
    }

    public Long readLong() throws IOException {
        String temp = this.readField(false);
        if (Utility.isNullOrEmpty(temp)) {
            return null;
        }
        return Long.parseLong(temp);
    }

    public URI readUri() throws URISyntaxException, IOException {
        String temp = this.readField(true);
        if (Utility.isNullOrEmpty(temp)) {
            return null;
        }
        return new URI(StringEscapeUtils.unescapeHtml4((String)temp));
    }

    public void endCurrentRecord() throws IOException {
        this.readDelimiter('\n');
        this.isFirstFieldInRecord = true;
    }

    private void readDelimiter(char delimiter) throws IOException {
        if (this.isEndOfFile()) {
            throw new EOFException("Error parsing log record: unexpected end of stream.");
        }
        int read = this.read();
        if (read == -1 || (char)read != delimiter) {
            throw new IllegalStateException("Error parsing log record: unexpected delimiter encountered.");
        }
    }

    private boolean tryPeekDelimiter(char delimiter) throws IOException {
        if (this.isEndOfFile()) {
            throw new EOFException("Error parsing log record: unexpected end of stream.");
        }
        return (char)this.peek() == delimiter;
    }

    private String readField(boolean isQuotedString) throws IOException {
        StringBuilder fieldBuilder;
        block7: {
            if (!this.isFirstFieldInRecord) {
                this.readDelimiter(';');
            } else {
                this.isFirstFieldInRecord = false;
            }
            fieldBuilder = new StringBuilder();
            boolean hasSeenQuoteForQuotedString = false;
            boolean isExpectingDelimiterForNextCharacterForQuotedString = false;
            while (true) {
                if (this.isEndOfFile()) {
                    throw new EOFException("Error parsing log record: unexpected end of stream.");
                }
                char c = (char)this.peek();
                if ((!isQuotedString || isExpectingDelimiterForNextCharacterForQuotedString || fieldBuilder.length() == 0) && (c == ';' || c == '\n')) break block7;
                if (isExpectingDelimiterForNextCharacterForQuotedString) {
                    throw new IllegalStateException("Error parsing log record: unexpected quote character encountered.");
                }
                this.read();
                fieldBuilder.append(c);
                if (c != '\"') continue;
                if (!isQuotedString) {
                    throw new IllegalStateException("Error parsing log record: unexpected quote character encountered.");
                }
                if (fieldBuilder.length() == 1) {
                    hasSeenQuoteForQuotedString = true;
                    continue;
                }
                if (!hasSeenQuoteForQuotedString) break;
                isExpectingDelimiterForNextCharacterForQuotedString = true;
            }
            throw new IllegalStateException("Error parsing log record: unexpected quote character encountered.");
        }
        String field = isQuotedString && fieldBuilder.length() != 0 ? fieldBuilder.substring(1, fieldBuilder.length() - 1) : fieldBuilder.toString();
        return field;
    }

    @Override
    public int read() throws IOException {
        if (this.peekedCharacter != null) {
            int temp = this.peekedCharacter;
            this.peekedCharacter = null;
            return temp;
        }
        return super.read();
    }

    protected int peek() throws IOException {
        if (this.peekedCharacter != null) {
            return this.peekedCharacter;
        }
        this.peekedCharacter = super.read();
        return this.peekedCharacter;
    }
}

