/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import com.microsoft.azure.storage.core.EncryptionAlgorithm;
import com.microsoft.azure.storage.core.JsonUtilities;
import java.io.IOException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParseException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;

public class EncryptionAgent {
    public EncryptionAlgorithm encryptionAlgorithm;
    public String protocol;

    public EncryptionAgent() {
    }

    public EncryptionAgent(String protocol, EncryptionAlgorithm algorithm) {
        this.protocol = protocol;
        this.encryptionAlgorithm = algorithm;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeStringField("Protocol", this.getProtocol());
        generator.writeStringField("EncryptionAlgorithm", this.getEncryptionAlgorithm().toString());
    }

    public static EncryptionAgent deserialize(JsonParser parser) throws JsonParseException, IOException {
        JsonUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextToken();
        EncryptionAgent agent = new EncryptionAgent();
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String name = parser.getCurrentName();
            parser.nextToken();
            if (name.equals("Protocol")) {
                agent.setProtocol(parser.getValueAsString());
            } else if (name.equals("EncryptionAlgorithm")) {
                agent.setEncryptionAlgorithm(EncryptionAlgorithm.valueOf(parser.getValueAsString()));
            }
            parser.nextToken();
        }
        JsonUtilities.assertIsEndObjectJsonToken(parser);
        return agent;
    }
}

