/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.auth;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.ContainerCredentialsRetryPolicy;
import net.snowflake.client.jdbc.internal.amazonaws.auth.EC2CredentialsFetcher;
import net.snowflake.client.jdbc.internal.amazonaws.internal.CredentialsEndpointProvider;
import net.snowflake.client.jdbc.internal.amazonaws.retry.internal.CredentialsEndpointRetryPolicy;

public class ContainerCredentialsProvider
implements AWSCredentialsProvider {
    static final String ECS_CONTAINER_CREDENTIALS_PATH = "AWS_CONTAINER_CREDENTIALS_RELATIVE_URI";
    private static final String ECS_CREDENTIALS_ENDPOINT = "http://169.254.170.2";
    private final EC2CredentialsFetcher credentialsFetcher;

    public ContainerCredentialsProvider() {
        this(new ECSCredentialsEndpointProvider());
    }

    @SdkInternalApi
    public ContainerCredentialsProvider(CredentialsEndpointProvider credentailsEndpointProvider) {
        this.credentialsFetcher = new EC2CredentialsFetcher(credentailsEndpointProvider);
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.credentialsFetcher.getCredentials();
    }

    @Override
    public void refresh() {
        this.credentialsFetcher.refresh();
    }

    public Date getCredentialsExpiration() {
        return this.credentialsFetcher.getCredentialsExpiration();
    }

    private static class ECSCredentialsEndpointProvider
    extends CredentialsEndpointProvider {
        private ECSCredentialsEndpointProvider() {
        }

        @Override
        public URI getCredentialsEndpoint() throws URISyntaxException {
            String path = System.getenv(ContainerCredentialsProvider.ECS_CONTAINER_CREDENTIALS_PATH);
            if (path == null) {
                throw new SdkClientException("The environment variable AWS_CONTAINER_CREDENTIALS_RELATIVE_URI is empty");
            }
            return new URI(ContainerCredentialsProvider.ECS_CREDENTIALS_ENDPOINT + path);
        }

        @Override
        public CredentialsEndpointRetryPolicy getRetryPolicy() {
            return ContainerCredentialsRetryPolicy.getInstance();
        }
    }
}

