/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.partitions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.partitions.PartitionRegionImpl;
import net.snowflake.client.jdbc.internal.amazonaws.partitions.model.Partition;
import net.snowflake.client.jdbc.internal.amazonaws.partitions.model.Region;
import net.snowflake.client.jdbc.internal.amazonaws.regions.AbstractRegionMetadataProvider;
import net.snowflake.client.jdbc.internal.amazonaws.util.ValidationUtils;

@SdkInternalApi
public class PartitionMetadataProvider
extends AbstractRegionMetadataProvider {
    private final Map<String, Partition> partitionMap = new HashMap<String, Partition>();
    private final Map<String, net.snowflake.client.jdbc.internal.amazonaws.regions.Region> regionCache = new ConcurrentHashMap<String, net.snowflake.client.jdbc.internal.amazonaws.regions.Region>();

    public PartitionMetadataProvider(List<Partition> partitions) {
        ValidationUtils.assertNotNull(partitions, "partitions");
        for (Partition p : partitions) {
            this.partitionMap.put(p.getPartition(), p);
        }
    }

    @Override
    public List<net.snowflake.client.jdbc.internal.amazonaws.regions.Region> getRegions() {
        ArrayList<net.snowflake.client.jdbc.internal.amazonaws.regions.Region> regions = new ArrayList<net.snowflake.client.jdbc.internal.amazonaws.regions.Region>();
        for (Partition p : this.partitionMap.values()) {
            for (Map.Entry<String, Region> entry : p.getRegions().entrySet()) {
                regions.add(new net.snowflake.client.jdbc.internal.amazonaws.regions.Region(new PartitionRegionImpl(entry.getKey(), p)));
            }
        }
        return Collections.unmodifiableList(regions);
    }

    @Override
    public net.snowflake.client.jdbc.internal.amazonaws.regions.Region getRegion(String regionName) {
        if (regionName == null) {
            return null;
        }
        net.snowflake.client.jdbc.internal.amazonaws.regions.Region regionFromCache = this.getRegionFromCache(regionName);
        if (regionFromCache != null) {
            return regionFromCache;
        }
        return this.createNewRegion(regionName);
    }

    private net.snowflake.client.jdbc.internal.amazonaws.regions.Region createNewRegion(String regionName) {
        for (Partition p : this.partitionMap.values()) {
            if (!p.hasRegion(regionName)) continue;
            return this.cacheRegion(new PartitionRegionImpl(regionName, p));
        }
        return null;
    }

    private net.snowflake.client.jdbc.internal.amazonaws.regions.Region getRegionFromCache(String regionName) {
        return this.regionCache.get(regionName);
    }

    private net.snowflake.client.jdbc.internal.amazonaws.regions.Region cacheRegion(PartitionRegionImpl regionImpl) {
        net.snowflake.client.jdbc.internal.amazonaws.regions.Region region = new net.snowflake.client.jdbc.internal.amazonaws.regions.Region(regionImpl);
        this.regionCache.put(region.getName(), region);
        return region;
    }

    @Override
    public List<net.snowflake.client.jdbc.internal.amazonaws.regions.Region> getRegionsForService(String serviceName) {
        List<net.snowflake.client.jdbc.internal.amazonaws.regions.Region> allRegions = this.getRegions();
        ArrayList<net.snowflake.client.jdbc.internal.amazonaws.regions.Region> serviceSupportedRegions = new ArrayList<net.snowflake.client.jdbc.internal.amazonaws.regions.Region>();
        for (net.snowflake.client.jdbc.internal.amazonaws.regions.Region r : allRegions) {
            if (!r.isServiceSupported(serviceName)) continue;
            serviceSupportedRegions.add(r);
        }
        return serviceSupportedRegions;
    }
}

