/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.datatype.joda.ser;

import java.io.IOException;
import java.lang.reflect.Type;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerationException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.datatype.joda.ser.JodaSerializerBase;
import net.snowflake.client.jdbc.internal.joda.time.LocalTime;
import net.snowflake.client.jdbc.internal.joda.time.format.DateTimeFormatter;
import net.snowflake.client.jdbc.internal.joda.time.format.ISODateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalTimeSerializer
extends JodaSerializerBase<LocalTime> {
    static final DateTimeFormatter format = ISODateTimeFormat.time();

    public LocalTimeSerializer() {
        super(LocalTime.class);
    }

    @Override
    public void serialize(LocalTime tm, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jgen.writeStartArray();
            jgen.writeNumber(tm.hourOfDay().get());
            jgen.writeNumber(tm.minuteOfHour().get());
            jgen.writeNumber(tm.secondOfMinute().get());
            jgen.writeNumber(tm.millisOfSecond().get());
            jgen.writeEndArray();
        } else {
            jgen.writeString(format.print(tm));
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS) ? "array" : "string", true);
    }
}

