/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.loader;

import java.io.File;
import java.sql.ResultSet;
import java.sql.Statement;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.loader.Loader;
import net.snowflake.client.loader.PutQueue;
import net.snowflake.client.loader.StreamLoader;
import net.snowflake.client.loader.Utils;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class FileUploader
implements Runnable {
    private static final SFLogger LOGGER = SFLoggerFactory.getLogger(PutQueue.class);
    private static final int RETRY = 6;
    private final Thread _thread;
    private final StreamLoader _loader;
    private final String _stage;
    private final File _file;

    public FileUploader(StreamLoader loader, String stage, File file) {
        LOGGER.debug("");
        this._loader = loader;
        this._thread = new Thread(this);
        this._thread.setName("FileUploaderThread");
        this._stage = stage;
        this._file = file;
    }

    public synchronized void upload() {
        LOGGER.debug("");
        this._loader.throttleUp();
        this._thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable previousException = null;
        try {
            for (int attempt = 0; attempt <= 6; ++attempt) {
                if (attempt == 6) {
                    if (previousException != null) {
                        this._loader.abort(new Loader.ConnectionError(String.format("File could not be uploaded to remote stage after retrying %d times: %s", 6, this._file.getCanonicalPath()), Utils.getCause(previousException)));
                    } else {
                        this._loader.abort(new Loader.ConnectionError(String.format("File could not be uploaded to remote stage after retrying %d times: %s", 6, this._file.getCanonicalPath())));
                    }
                    break;
                }
                if (attempt > 0) {
                    LOGGER.info("Will retry PUT after {} seconds", Math.pow(2.0, attempt));
                    Thread.sleep(1000 * (int)Math.pow(2.0, attempt));
                }
                if (this._loader._testMode) {
                    if (attempt < 2) {
                        ((SnowflakeConnectionV1)this._loader.getPutConnection()).setInjectFileUploadFailure(this._file.getName());
                    } else {
                        ((SnowflakeConnectionV1)this._loader.getPutConnection()).setInjectFileUploadFailure(null);
                    }
                }
                String remoteStage = "@" + this._loader.getRemoteStage() + "/" + this.remoteSeparator(this._stage);
                String putStatement = "PUT " + (attempt > 0 ? "/* retry:" + attempt + " */ " : "") + "file://" + this._file.getCanonicalPath() + " '" + remoteStage + "' parallel=10 auto_compress=false source_compression=gzip";
                Statement statement = this._loader.getPutConnection().createStatement();
                try {
                    LOGGER.debug("Put Statement: {}", putStatement);
                    statement.execute(putStatement);
                    ResultSet putResult = statement.getResultSet();
                    putResult.next();
                    String file = this.localSeparator(putResult.getString(SnowflakeFileTransferAgent.UploadColumns.source.name()));
                    String status = putResult.getString(SnowflakeFileTransferAgent.UploadColumns.status.name());
                    String message = putResult.getString(SnowflakeFileTransferAgent.UploadColumns.message.name());
                    if (status != null && status.equals(SnowflakeFileTransferAgent.ResultStatus.UPLOADED.name())) {
                        this._file.delete();
                        break;
                    }
                    if (message.startsWith("Simulated upload failure")) {
                        LOGGER.info("Failed to upload a file: status={}, filename={}, message={}", status, file, message);
                        continue;
                    }
                    LOGGER.warn("Failed to upload a file: status={}, filename={}, message={}", status, file, message);
                    continue;
                }
                catch (Throwable t) {
                    LOGGER.error(String.format("Failed to PUT on attempt: attempt=[%s], Message=[%s]", attempt, t.getMessage()), t.getCause());
                    previousException = t;
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("PUT exception", t);
            this._loader.abort(new Loader.ConnectionError(t.getMessage(), t.getCause()));
        }
        finally {
            this._loader.throttleDown();
        }
    }

    public void join() {
        LOGGER.debug("");
        try {
            this._thread.join(0L);
        }
        catch (InterruptedException ex) {
            LOGGER.error(ex.getMessage(), ex);
        }
    }

    private String remoteSeparator(String fname) {
        if (File.separatorChar == '\\') {
            return fname.replace("\\", "/");
        }
        return fname;
    }

    private String localSeparator(String fname) {
        if (File.separatorChar == '\\') {
            return fname.replace("/", "\\");
        }
        return fname;
    }
}

