/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto;

import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.CriticalHeaderParamsAware;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEDecrypter;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEHeader;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.KeyLengthException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.AlgorithmSupportMessage;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.ContentCryptoProvider;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.CriticalHeaderParamsDeferral;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.DirectCryptoProvider;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.OctetSequenceKey;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DirectDecrypter
extends DirectCryptoProvider
implements JWEDecrypter,
CriticalHeaderParamsAware {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public DirectDecrypter(SecretKey key) throws KeyLengthException {
        super(key);
    }

    public DirectDecrypter(byte[] keyBytes) throws KeyLengthException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public DirectDecrypter(OctetSequenceKey octJWK) throws KeyLengthException {
        this(octJWK.toSecretKey("AES"));
    }

    public DirectDecrypter(SecretKey key, Set<String> defCritHeaders) throws KeyLengthException {
        super(key);
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        if (encryptedKey != null) {
            throw new JOSEException("Unexpected present JWE encrypted key");
        }
        if (iv == null) {
            throw new JOSEException("Unexpected present JWE initialization vector (IV)");
        }
        if (authTag == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        JWEAlgorithm alg = header.getAlgorithm();
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        this.critPolicy.ensureHeaderPasses(header);
        return ContentCryptoProvider.decrypt(header, null, iv, cipherText, authTag, this.getKey(), this.getJCAContext());
    }
}

