/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto;

import java.util.Set;
import javax.crypto.SecretKey;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.CriticalHeaderParamsAware;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSHeader;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSVerifier;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.CriticalHeaderParamsDeferral;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.HMAC;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.MACProvider;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.utils.ConstantTimeUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.OctetSequenceKey;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.StandardCharset;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MACVerifier
extends MACProvider
implements JWSVerifier,
CriticalHeaderParamsAware {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public MACVerifier(byte[] secret) throws JOSEException {
        this(secret, (Set<String>)null);
    }

    public MACVerifier(String secretString) throws JOSEException {
        this(secretString.getBytes(StandardCharset.UTF_8));
    }

    public MACVerifier(SecretKey secretKey) throws JOSEException {
        this(secretKey.getEncoded());
    }

    public MACVerifier(OctetSequenceKey jwk) throws JOSEException {
        this(jwk.toByteArray());
    }

    public MACVerifier(byte[] secret, Set<String> defCritHeaders) throws JOSEException {
        super(secret, SUPPORTED_ALGORITHMS);
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public boolean verify(JWSHeader header, byte[] signedContent, Base64URL signature) throws JOSEException {
        if (!this.critPolicy.headerPasses(header)) {
            return false;
        }
        String jcaAlg = MACVerifier.getJCAAlgorithmName(header.getAlgorithm());
        byte[] expectedHMAC = HMAC.compute(jcaAlg, this.getSecret(), signedContent, this.getJCAContext().getProvider());
        return ConstantTimeUtils.areEqual(expectedHMAC, signature.decode());
    }
}

