/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage.file;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.AccessCondition;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.DoesServiceRequest;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.IPRange;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.OperationContext;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.RequestOptions;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.SharedAccessPolicyHandler;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.SharedAccessPolicySerializer;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.SharedAccessProtocols;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentials;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageUri;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.ExecutionEngine;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.PathUtility;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.RequestLocationMode;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.SharedAccessSignatureHelper;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.StorageCredentialsHelper;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.StorageRequest;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.UriQueryBuilder;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Utility;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.CloudFileClient;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.CloudFileDirectory;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.FileRequest;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.FileRequestOptions;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.FileResponse;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.FileShareAttributes;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.FileSharePermissions;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.FileShareProperties;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.ShareStats;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.ShareStatsHandler;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.file.SharedAccessFilePolicy;

public final class CloudFileShare {
    private HashMap<String, String> metadata = new HashMap();
    FileShareProperties properties = new FileShareProperties();
    String name = null;
    private StorageUri storageUri;
    private CloudFileClient fileServiceClient;

    protected CloudFileShare(String shareName, CloudFileClient client) throws URISyntaxException, StorageException {
        Utility.assertNotNull("client", client);
        Utility.assertNotNull("shareName", shareName);
        this.storageUri = PathUtility.appendPathToUri(client.getStorageUri(), shareName);
        this.name = shareName;
        this.fileServiceClient = client;
    }

    public CloudFileShare(URI uri) throws StorageException {
        this(new StorageUri(uri));
    }

    public CloudFileShare(StorageUri storageUri) throws StorageException {
        this(storageUri, (StorageCredentials)null);
    }

    public CloudFileShare(URI uri, StorageCredentials credentials) throws StorageException {
        this(new StorageUri(uri), credentials);
    }

    public CloudFileShare(StorageUri storageUri, StorageCredentials credentials) throws StorageException {
        this.parseQueryAndVerify(storageUri, credentials);
    }

    @DoesServiceRequest
    public void create() throws StorageException {
        this.create(null, null);
    }

    @DoesServiceRequest
    public void create(FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.createImpl(options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileShare, Void> createImpl(final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileShare, Void> putRequest = new StorageRequest<CloudFileClient, CloudFileShare, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileShare share, OperationContext context) throws Exception {
                HttpURLConnection request = FileRequest.createShare(share.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, share.getProperties());
                return request;
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudFileShare share, OperationContext context) {
                FileRequest.addMetadata(connection, share.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudFileShare share, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                FileShareAttributes attributes = FileResponse.getFileShareAttributes(this.getConnection(), client.isUsePathStyleUris());
                Integer oldShareQuota = share.properties.getShareQuota();
                share.properties = attributes.getProperties();
                share.properties.setShareQuota(oldShareQuota);
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public boolean createIfNotExists() throws StorageException {
        return this.createIfNotExists(null, null);
    }

    @DoesServiceRequest
    public boolean createIfNotExists(FileRequestOptions options, OperationContext opContext) throws StorageException {
        boolean exists = this.exists(true, null, options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient), opContext);
        if (exists) {
            return false;
        }
        try {
            this.create(options, opContext);
            return true;
        }
        catch (StorageException e) {
            if (e.getHttpStatusCode() == 409 && "ShareAlreadyExists".equals(e.getErrorCode())) {
                return false;
            }
            throw e;
        }
    }

    @DoesServiceRequest
    public void delete() throws StorageException {
        this.delete(null, null, null);
    }

    @DoesServiceRequest
    public void delete(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.deleteImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileShare, Void> deleteImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileShare, Void> putRequest = new StorageRequest<CloudFileClient, CloudFileShare, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileShare share, OperationContext context) throws Exception {
                return FileRequest.deleteShare(share.getTransformedAddress().getPrimaryUri(), options, context, accessCondition);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public Void preProcessResponse(CloudFileShare share, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public boolean deleteIfExists() throws StorageException {
        return this.deleteIfExists(null, null, null);
    }

    @DoesServiceRequest
    public boolean deleteIfExists(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        boolean exists = this.exists(true, accessCondition, options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient), opContext);
        if (exists) {
            try {
                this.delete(accessCondition, options, opContext);
                return true;
            }
            catch (StorageException e) {
                if (e.getHttpStatusCode() == 404 && "ShareNotFound".equals(e.getErrorCode())) {
                    return false;
                }
                throw e;
            }
        }
        return false;
    }

    @DoesServiceRequest
    public void downloadAttributes() throws StorageException {
        this.downloadAttributes(null, null, null);
    }

    @DoesServiceRequest
    public void downloadAttributes(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.downloadAttributesImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileShare, Void> downloadAttributesImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileShare, Void> getRequest = new StorageRequest<CloudFileClient, CloudFileShare, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileShare share, OperationContext context) throws Exception {
                return FileRequest.getShareProperties(share.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public Void preProcessResponse(CloudFileShare share, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                FileShareAttributes attributes = FileResponse.getFileShareAttributes(this.getConnection(), client.isUsePathStyleUris());
                share.metadata = attributes.getMetadata();
                share.properties = attributes.getProperties();
                return null;
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public FileSharePermissions downloadPermissions() throws StorageException {
        return this.downloadPermissions(null, null, null);
    }

    @DoesServiceRequest
    public FileSharePermissions downloadPermissions(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        return ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.downloadPermissionsImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileShare, FileSharePermissions> downloadPermissionsImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileShare, FileSharePermissions> getRequest = new StorageRequest<CloudFileClient, CloudFileShare, FileSharePermissions>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileShare share, OperationContext context) throws Exception {
                return FileRequest.getAcl(share.getTransformedAddress().getUri(this.getCurrentLocation()), options, accessCondition, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public FileSharePermissions preProcessResponse(CloudFileShare share, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                share.updatePropertiesFromResponse(this.getConnection());
                return new FileSharePermissions();
            }

            @Override
            public FileSharePermissions postProcessResponse(HttpURLConnection connection, CloudFileShare share, CloudFileClient client, OperationContext context, FileSharePermissions shareAcl) throws Exception {
                HashMap<String, SharedAccessFilePolicy> accessIds = SharedAccessPolicyHandler.getAccessIdentifiers(this.getConnection().getInputStream(), SharedAccessFilePolicy.class);
                for (String key : accessIds.keySet()) {
                    shareAcl.getSharedAccessPolicies().put(key, accessIds.get(key));
                }
                return shareAcl;
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public ShareStats getStats() throws StorageException {
        return this.getStats(null, null);
    }

    @DoesServiceRequest
    public ShareStats getStats(FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        return ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.getStatsImpl(options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileShare, ShareStats> getStatsImpl(final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileShare, ShareStats> getRequest = new StorageRequest<CloudFileClient, CloudFileShare, ShareStats>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileShare share, OperationContext context) throws Exception {
                return FileRequest.getShareStats(share.getTransformedAddress().getUri(this.getCurrentLocation()), options, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public ShareStats preProcessResponse(CloudFileShare share, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                share.updatePropertiesFromResponse(this.getConnection());
                return null;
            }

            @Override
            public ShareStats postProcessResponse(HttpURLConnection connection, CloudFileShare share, CloudFileClient client, OperationContext context, ShareStats shareStats) throws Exception {
                return ShareStatsHandler.readShareStatsFromStream(connection.getInputStream());
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public boolean exists() throws StorageException {
        return this.exists(null, null, null);
    }

    @DoesServiceRequest
    public boolean exists(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        return this.exists(false, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    private boolean exists(boolean primaryOnly, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        return ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.existsImpl(primaryOnly, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileShare, Boolean> existsImpl(final boolean primaryOnly, final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileShare, Boolean> getRequest = new StorageRequest<CloudFileClient, CloudFileShare, Boolean>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(primaryOnly ? RequestLocationMode.PRIMARY_ONLY : RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileShare share, OperationContext context) throws Exception {
                return FileRequest.getShareProperties(share.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public Boolean preProcessResponse(CloudFileShare share, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() == 200) {
                    share.updatePropertiesFromResponse(this.getConnection());
                    return true;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return false;
                }
                this.setNonExceptionedRetryableFailure(true);
                return false;
            }
        };
        return getRequest;
    }

    private void updatePropertiesFromResponse(HttpURLConnection request) {
        this.getProperties().setEtag(request.getHeaderField("ETag"));
        if (0L != request.getLastModified()) {
            Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
            lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
            lastModifiedCalendar.setTime(new Date(request.getLastModified()));
            this.getProperties().setLastModified(lastModifiedCalendar.getTime());
        }
    }

    public String generateSharedAccessSignature(SharedAccessFilePolicy policy, String groupPolicyIdentifier) throws InvalidKeyException, StorageException {
        return this.generateSharedAccessSignature(policy, groupPolicyIdentifier, null, null);
    }

    public String generateSharedAccessSignature(SharedAccessFilePolicy policy, String groupPolicyIdentifier, IPRange ipRange, SharedAccessProtocols protocols) throws InvalidKeyException, StorageException {
        if (!StorageCredentialsHelper.canCredentialsSignRequest(this.fileServiceClient.getCredentials())) {
            String errorMessage = "Cannot create Shared Access Signature unless the Account Key credentials are used by the ServiceClient.";
            throw new IllegalArgumentException("Cannot create Shared Access Signature unless the Account Key credentials are used by the ServiceClient.");
        }
        String resourceName = this.getSharedAccessCanonicalName();
        String signature = SharedAccessSignatureHelper.generateSharedAccessSignatureHashForBlobAndFile(policy, null, groupPolicyIdentifier, resourceName, ipRange, protocols, this.fileServiceClient);
        UriQueryBuilder builder = SharedAccessSignatureHelper.generateSharedAccessSignatureForBlobAndFile(policy, null, groupPolicyIdentifier, "s", ipRange, protocols, signature);
        return builder.toString();
    }

    private String getSharedAccessCanonicalName() {
        String accountName = this.getServiceClient().getCredentials().getAccountName();
        String shareName = this.getName();
        return String.format("/%s/%s/%s", "file", accountName, shareName);
    }

    @DoesServiceRequest
    public void uploadMetadata() throws StorageException {
        this.uploadMetadata(null, null, null);
    }

    @DoesServiceRequest
    public void uploadMetadata(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.uploadMetadataImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileShare, Void> uploadMetadataImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileShare, Void> putRequest = new StorageRequest<CloudFileClient, CloudFileShare, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileShare share, OperationContext context) throws Exception {
                return FileRequest.setShareMetadata(share.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudFileShare share, OperationContext context) {
                FileRequest.addMetadata(connection, share.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudFileShare share, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                share.updatePropertiesFromResponse(this.getConnection());
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public final void uploadProperties() throws StorageException {
        this.uploadProperties(null, null, null);
    }

    @DoesServiceRequest
    public final void uploadProperties(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.uploadPropertiesImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileShare, Void> uploadPropertiesImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileShare, Void> putRequest = new StorageRequest<CloudFileClient, CloudFileShare, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileShare share, OperationContext context) throws Exception {
                return FileRequest.setShareProperties(share.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, accessCondition, share.properties);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudFileShare share, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                share.updatePropertiesFromResponse(this.getConnection());
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public void uploadPermissions(FileSharePermissions permissions) throws StorageException {
        this.uploadPermissions(permissions, null, null, null);
    }

    @DoesServiceRequest
    public void uploadPermissions(FileSharePermissions permissions, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.uploadPermissionsImpl(permissions, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileShare, Void> uploadPermissionsImpl(FileSharePermissions permissions, final AccessCondition accessCondition, final FileRequestOptions options) throws StorageException {
        try {
            StringWriter outBuffer = new StringWriter();
            SharedAccessPolicySerializer.writeSharedAccessIdentifiersToStream(permissions.getSharedAccessPolicies(), outBuffer);
            final byte[] aclBytes = outBuffer.toString().getBytes("UTF-8");
            StorageRequest<CloudFileClient, CloudFileShare, Void> putRequest = new StorageRequest<CloudFileClient, CloudFileShare, Void>((RequestOptions)options, this.getStorageUri()){

                @Override
                public HttpURLConnection buildRequest(CloudFileClient client, CloudFileShare share, OperationContext context) throws Exception {
                    this.setSendStream(new ByteArrayInputStream(aclBytes));
                    this.setLength(Long.valueOf(aclBytes.length));
                    return FileRequest.setAcl(share.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, accessCondition);
                }

                @Override
                public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                    StorageRequest.signBlobQueueAndFileRequest(connection, client, aclBytes.length, context);
                }

                @Override
                public Void preProcessResponse(CloudFileShare share, CloudFileClient client, OperationContext context) throws Exception {
                    if (this.getResult().getStatusCode() != 200) {
                        this.setNonExceptionedRetryableFailure(true);
                        return null;
                    }
                    share.updatePropertiesFromResponse(this.getConnection());
                    return null;
                }
            };
            return putRequest;
        }
        catch (IllegalArgumentException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
        catch (XMLStreamException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
        catch (UnsupportedEncodingException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
    }

    public CloudFileDirectory getRootDirectoryReference() throws StorageException, URISyntaxException {
        return new CloudFileDirectory(this.storageUri, "", this);
    }

    private void parseQueryAndVerify(StorageUri completeUri, StorageCredentials credentials) throws StorageException {
        Utility.assertNotNull("completeUri", completeUri);
        if (!completeUri.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Address %s is a relative address. Only absolute addresses are permitted.", completeUri.toString()));
        }
        this.storageUri = PathUtility.stripURIQueryAndFragment(completeUri);
        StorageCredentialsSharedAccessSignature parsedCredentials = SharedAccessSignatureHelper.parseQuery(completeUri);
        if (credentials != null && parsedCredentials != null) {
            throw new IllegalArgumentException("Cannot provide credentials as part of the address and as constructor parameter. Either pass in the address or use a different constructor.");
        }
        try {
            boolean usePathStyleUris = Utility.determinePathStyleFromUri(this.storageUri.getPrimaryUri());
            this.fileServiceClient = new CloudFileClient(PathUtility.getServiceClientBaseAddress(this.getStorageUri(), usePathStyleUris), credentials != null ? credentials : parsedCredentials);
            this.name = PathUtility.getShareNameFromUri(this.storageUri.getPrimaryUri(), usePathStyleUris);
        }
        catch (URISyntaxException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }

    public CloudFileClient getServiceClient() {
        return this.fileServiceClient;
    }

    public URI getUri() {
        return this.storageUri.getPrimaryUri();
    }

    public StorageUri getStorageUri() {
        return this.storageUri;
    }

    public String getName() {
        return this.name;
    }

    public HashMap<String, String> getMetadata() {
        return this.metadata;
    }

    public FileShareProperties getProperties() {
        return this.properties;
    }

    public void setMetadata(HashMap<String, String> metadata) {
        this.metadata = metadata;
    }

    protected void setProperties(FileShareProperties properties) {
        this.properties = properties;
    }

    private StorageUri getTransformedAddress() throws URISyntaxException, StorageException {
        return this.fileServiceClient.getCredentials().transformUri(this.storageUri);
    }
}

