/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.yammer.metrics.stats;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import net.snowflake.client.jdbc.internal.yammer.metrics.stats.Sample;
import net.snowflake.client.jdbc.internal.yammer.metrics.stats.Snapshot;
import net.snowflake.client.jdbc.internal.yammer.metrics.stats.ThreadLocalRandom;

public class UniformSample
implements Sample {
    private static final int BITS_PER_LONG = 63;
    private final AtomicLong count = new AtomicLong();
    private final AtomicLongArray values;

    public UniformSample(int reservoirSize) {
        this.values = new AtomicLongArray(reservoirSize);
        this.clear();
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.values.length(); ++i) {
            this.values.set(i, 0L);
        }
        this.count.set(0L);
    }

    @Override
    public int size() {
        long c = this.count.get();
        if (c > (long)this.values.length()) {
            return this.values.length();
        }
        return (int)c;
    }

    @Override
    public void update(long value) {
        long c = this.count.incrementAndGet();
        if (c <= (long)this.values.length()) {
            this.values.set((int)c - 1, value);
        } else {
            long r = UniformSample.nextLong(c);
            if (r < (long)this.values.length()) {
                this.values.set((int)r, value);
            }
        }
    }

    private static long nextLong(long n) {
        long val;
        long bits;
        while ((bits = ThreadLocalRandom.current().nextLong() & Long.MAX_VALUE) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    @Override
    public Snapshot getSnapshot() {
        int s = this.size();
        ArrayList<Long> copy = new ArrayList<Long>(s);
        for (int i = 0; i < s; ++i) {
            copy.add(this.values.get(i));
        }
        return new Snapshot(copy);
    }
}

