/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.protocol.json;

import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkProtectedApi;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallLocation;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingType;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.OperationInfo;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.ProtocolRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.json.StructuredJsonGenerator;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.json.StructuredJsonMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.json.internal.JsonProtocolMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.json.internal.MarshallerRegistry;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.json.internal.NullAsEmptyBodyProtocolRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.json.internal.SimpleTypeJsonMarshallers;

@SdkProtectedApi
public class JsonProtocolMarshallerBuilder<T> {
    private StructuredJsonGenerator jsonGenerator;
    private String contentType;
    private OperationInfo operationInfo;
    private boolean sendExplicitNullForPayload;
    private T originalRequest;
    private MarshallerRegistry.Builder marshallerRegistry;

    public static <T> JsonProtocolMarshallerBuilder<T> standard() {
        return new JsonProtocolMarshallerBuilder<T>();
    }

    public JsonProtocolMarshallerBuilder<T> jsonGenerator(StructuredJsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> operationInfo(OperationInfo operationInfo) {
        this.operationInfo = operationInfo;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> sendExplicitNullForPayload(boolean sendExplicitNullForPayload) {
        this.sendExplicitNullForPayload = sendExplicitNullForPayload;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> originalRequest(T originalRequest) {
        this.originalRequest = originalRequest;
        return this;
    }

    public <MarshallT> JsonProtocolMarshallerBuilder<T> marshallerOverride(MarshallLocation marshallLocation, MarshallingType<MarshallT> marshallingType, StructuredJsonMarshaller<MarshallT> marshaller) {
        if (this.marshallerRegistry == null) {
            this.marshallerRegistry = MarshallerRegistry.builder();
        }
        this.marshallerRegistry.addMarshaller(marshallLocation, marshallingType, SimpleTypeJsonMarshallers.adapt(marshaller));
        return this;
    }

    public ProtocolRequestMarshaller<T> build() {
        JsonProtocolMarshaller<T> protocolMarshaller = new JsonProtocolMarshaller<T>(this.jsonGenerator, this.contentType, this.operationInfo, this.originalRequest, this.marshallerRegistry);
        return this.sendExplicitNullForPayload ? protocolMarshaller : new NullAsEmptyBodyProtocolRequestMarshaller<T>(protocolMarshaller);
    }
}

