/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import net.snowflake.client.jdbc.internal.amazonaws.internal.SdkFilterInputStream;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.AWSKMS;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3EncryptionClient;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.S3Direct;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.AdjustedRangeInputStream;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.CipherLite;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.CipherLiteInputStream;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.ContentCryptoMaterial;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.CryptoRuntime;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.MultipartUploadCryptoContext;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.S3CryptoModuleBase;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.S3ObjectWrapper;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.CryptoConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.CryptoMode;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.EncryptedGetObjectRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ExtraMaterialsDescription;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.GetObjectRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.S3Object;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.S3ObjectId;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.S3ObjectInputStream;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.UploadPartRequest;
import net.snowflake.client.jdbc.internal.amazonaws.util.IOUtils;
import net.snowflake.client.jdbc.internal.amazonaws.util.json.Jackson;

class S3CryptoModuleAE
extends S3CryptoModuleBase<MultipartUploadCryptoContext> {
    S3CryptoModuleAE(AWSKMS kms, S3Direct s3, AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        super(kms, s3, credentialsProvider, encryptionMaterialsProvider, cryptoConfig);
        CryptoMode mode = cryptoConfig.getCryptoMode();
        if (mode != CryptoMode.StrictAuthenticatedEncryption && mode != CryptoMode.AuthenticatedEncryption) {
            throw new IllegalArgumentException();
        }
    }

    S3CryptoModuleAE(S3Direct s3, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        this(null, s3, new DefaultAWSCredentialsProviderChain(), encryptionMaterialsProvider, cryptoConfig);
    }

    S3CryptoModuleAE(AWSKMS kms, S3Direct s3, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        this(kms, s3, new DefaultAWSCredentialsProviderChain(), encryptionMaterialsProvider, cryptoConfig);
    }

    protected boolean isStrict() {
        return false;
    }

    @Override
    public S3Object getObjectSecurely(GetObjectRequest req) {
        S3Object retrieved;
        this.appendUserAgent(req, AmazonS3EncryptionClient.USER_AGENT);
        long[] desiredRange = req.getRange();
        if (this.isStrict() && (desiredRange != null || req.getPartNumber() != null)) {
            throw new SecurityException("Range get and getting a part are not allowed in strict crypto mode");
        }
        long[] adjustedCryptoRange = S3CryptoModuleAE.getAdjustedCryptoRange(desiredRange);
        if (adjustedCryptoRange != null) {
            req.setRange(adjustedCryptoRange[0], adjustedCryptoRange[1]);
        }
        if ((retrieved = this.s3.getObject(req)) == null) {
            return null;
        }
        String suffix = null;
        if (req instanceof EncryptedGetObjectRequest) {
            EncryptedGetObjectRequest ereq = (EncryptedGetObjectRequest)req;
            suffix = ereq.getInstructionFileSuffix();
        }
        try {
            return suffix == null || suffix.trim().isEmpty() ? this.decipher(req, desiredRange, adjustedCryptoRange, retrieved) : this.decipherWithInstFileSuffix(req, desiredRange, adjustedCryptoRange, retrieved, suffix);
        }
        catch (RuntimeException ex) {
            IOUtils.closeQuietly(retrieved, this.log);
            throw ex;
        }
        catch (Error error) {
            IOUtils.closeQuietly(retrieved, this.log);
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3Object decipher(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, S3Object retrieved) {
        S3ObjectWrapper wrapped = new S3ObjectWrapper(retrieved, req.getS3ObjectId());
        if (wrapped.hasEncryptionInfo()) {
            return this.decipherWithMetadata(req, desiredRange, cryptoRange, wrapped);
        }
        S3ObjectWrapper ifile = this.fetchInstructionFile(req.getS3ObjectId(), null);
        if (ifile != null) {
            try {
                S3Object s3Object = this.decipherWithInstructionFile(req, desiredRange, cryptoRange, wrapped, ifile);
                return s3Object;
            }
            finally {
                IOUtils.closeQuietly(ifile, this.log);
            }
        }
        if (this.isStrict() || !this.cryptoConfig.isIgnoreMissingInstructionFile()) {
            IOUtils.closeQuietly(wrapped, this.log);
            throw new SecurityException("Instruction file not found for S3 object with bucket name: " + retrieved.getBucketName() + ", key: " + retrieved.getKey());
        }
        this.log.warn(String.format("Unable to detect encryption information for object '%s' in bucket '%s'. Returning object without decryption.", retrieved.getKey(), retrieved.getBucketName()));
        S3ObjectWrapper adjusted = this.adjustToDesiredRange(wrapped, desiredRange, null);
        return adjusted.getS3Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3Object decipherWithInstFileSuffix(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, S3Object retrieved, String instFileSuffix) {
        S3ObjectId id = req.getS3ObjectId();
        S3ObjectWrapper ifile = this.fetchInstructionFile(id, instFileSuffix);
        if (ifile == null) {
            throw new SdkClientException("Instruction file with suffix " + instFileSuffix + " is not found for " + retrieved);
        }
        try {
            S3Object s3Object = this.decipherWithInstructionFile(req, desiredRange, cryptoRange, new S3ObjectWrapper(retrieved, id), ifile);
            return s3Object;
        }
        finally {
            IOUtils.closeQuietly(ifile, this.log);
        }
    }

    private S3Object decipherWithInstructionFile(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, S3ObjectWrapper retrieved, S3ObjectWrapper instructionFile) {
        ExtraMaterialsDescription extraMatDesc = ExtraMaterialsDescription.NONE;
        boolean keyWrapExpected = this.isStrict();
        if (req instanceof EncryptedGetObjectRequest) {
            EncryptedGetObjectRequest ereq = (EncryptedGetObjectRequest)req;
            extraMatDesc = ereq.getExtraMaterialDescription();
            if (!keyWrapExpected) {
                keyWrapExpected = ereq.isKeyWrapExpected();
            }
        }
        String json = instructionFile.toJsonString();
        Map<String, String> matdesc = Collections.unmodifiableMap(Jackson.fromJsonString(json, Map.class));
        ContentCryptoMaterial cekMaterial = ContentCryptoMaterial.fromInstructionFile(matdesc, this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), cryptoRange, extraMatDesc, keyWrapExpected, this.kms);
        this.securityCheck(cekMaterial, retrieved);
        S3ObjectWrapper decrypted = this.decrypt(retrieved, cekMaterial, cryptoRange);
        S3ObjectWrapper adjusted = this.adjustToDesiredRange(decrypted, desiredRange, matdesc);
        return adjusted.getS3Object();
    }

    private S3Object decipherWithMetadata(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, S3ObjectWrapper retrieved) {
        ExtraMaterialsDescription extraMatDesc = ExtraMaterialsDescription.NONE;
        boolean keyWrapExpected = this.isStrict();
        if (req instanceof EncryptedGetObjectRequest) {
            EncryptedGetObjectRequest ereq = (EncryptedGetObjectRequest)req;
            extraMatDesc = ereq.getExtraMaterialDescription();
            if (!keyWrapExpected) {
                keyWrapExpected = ereq.isKeyWrapExpected();
            }
        }
        ContentCryptoMaterial cekMaterial = ContentCryptoMaterial.fromObjectMetadata(retrieved.getObjectMetadata(), this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), cryptoRange, extraMatDesc, keyWrapExpected, this.kms);
        this.securityCheck(cekMaterial, retrieved);
        S3ObjectWrapper decrypted = this.decrypt(retrieved, cekMaterial, cryptoRange);
        S3ObjectWrapper adjusted = this.adjustToDesiredRange(decrypted, desiredRange, null);
        return adjusted.getS3Object();
    }

    protected final S3ObjectWrapper adjustToDesiredRange(S3ObjectWrapper s3object, long[] range, Map<String, String> instruction) {
        if (range == null) {
            return s3object;
        }
        ContentCryptoScheme encryptionScheme = s3object.encryptionSchemeOf(instruction);
        long instanceLen = s3object.getObjectMetadata().getInstanceLength();
        long maxOffset = instanceLen - (long)(encryptionScheme.getTagLengthInBits() / 8) - 1L;
        if (range[1] > maxOffset) {
            range[1] = maxOffset;
            if (range[0] > range[1]) {
                IOUtils.closeQuietly(s3object.getObjectContent(), this.log);
                s3object.setObjectContent(new ByteArrayInputStream(new byte[0]));
                return s3object;
            }
        }
        if (range[0] > range[1]) {
            return s3object;
        }
        try {
            S3ObjectInputStream objectContent = s3object.getObjectContent();
            AdjustedRangeInputStream adjustedRangeContents = new AdjustedRangeInputStream(objectContent, range[0], range[1]);
            s3object.setObjectContent(new S3ObjectInputStream(adjustedRangeContents, objectContent.getHttpRequest()));
            return s3object;
        }
        catch (IOException e) {
            throw new SdkClientException("Error adjusting output to desired byte range: " + e.getMessage());
        }
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File destinationFile) {
        this.assertParameterNotNull(destinationFile, "The destination file parameter must be specified when downloading an object directly to a file");
        S3Object s3Object = this.getObjectSecurely(getObjectRequest);
        if (s3Object == null) {
            return null;
        }
        BufferedOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            byte[] buffer = new byte[10240];
            while ((bytesRead = s3Object.getObjectContent().read(buffer)) > -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            try {
                throw new SdkClientException("Unable to store object contents to disk: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream, this.log);
                IOUtils.closeQuietly(s3Object.getObjectContent(), this.log);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(outputStream, this.log);
        IOUtils.closeQuietly(s3Object.getObjectContent(), this.log);
        return s3Object.getObjectMetadata();
    }

    @Override
    final MultipartUploadCryptoContext newUploadContext(InitiateMultipartUploadRequest req, ContentCryptoMaterial cekMaterial) {
        return new MultipartUploadCryptoContext(req.getBucketName(), req.getKey(), cekMaterial);
    }

    @Override
    final CipherLite cipherLiteForNextPart(MultipartUploadCryptoContext uploadContext) {
        return uploadContext.getCipherLite();
    }

    @Override
    final SdkFilterInputStream wrapForMultipart(CipherLiteInputStream is, long partSize) {
        return is;
    }

    @Override
    final long computeLastPartSize(UploadPartRequest req) {
        return req.getPartSize() + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }

    @Override
    final void updateUploadContext(MultipartUploadCryptoContext uploadContext, SdkFilterInputStream is) {
    }

    private S3ObjectWrapper decrypt(S3ObjectWrapper wrapper, ContentCryptoMaterial cekMaterial, long[] range) {
        S3ObjectInputStream objectContent = wrapper.getObjectContent();
        wrapper.setObjectContent(new S3ObjectInputStream(new CipherLiteInputStream(objectContent, cekMaterial.getCipherLite(), 2048), objectContent.getHttpRequest()));
        return wrapper;
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    protected final long ciphertextLength(long originalContentLength) {
        return originalContentLength + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }

    static {
        CryptoRuntime.enableBouncyCastle();
    }
}

