/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.dataformat.cbor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonEncoding;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.ObjectCodec;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.Version;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.format.InputAccessor;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.format.MatchStrength;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.io.IOContext;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.dataformat.cbor.CBORParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.dataformat.cbor.CBORParserBootstrapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.dataformat.cbor.PackageVersion;

public class CBORFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME = "CBOR";
    static final int DEFAULT_CBOR_PARSER_FEATURE_FLAGS = CBORParser.Feature.collectDefaults();
    static final int DEFAULT_CBOR_GENERATOR_FEATURE_FLAGS = CBORGenerator.Feature.collectDefaults();
    protected int _formatParserFeatures;
    protected int _formatGeneratorFeatures;

    public CBORFactory() {
        this(null);
    }

    public CBORFactory(ObjectCodec oc) {
        super(oc);
        this._formatParserFeatures = DEFAULT_CBOR_PARSER_FEATURE_FLAGS;
        this._formatGeneratorFeatures = DEFAULT_CBOR_GENERATOR_FEATURE_FLAGS;
    }

    public CBORFactory(CBORFactory src, ObjectCodec oc) {
        super(src, oc);
        this._formatParserFeatures = src._formatParserFeatures;
        this._formatGeneratorFeatures = src._formatGeneratorFeatures;
    }

    @Override
    public CBORFactory copy() {
        this._checkInvalidCopy(CBORFactory.class);
        return new CBORFactory(this, null);
    }

    @Override
    protected Object readResolve() {
        return new CBORFactory(this, this._objectCodec);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        return CBORParserBootstrapper.hasCBORFormat(acc);
    }

    @Override
    public boolean canHandleBinaryNatively() {
        return true;
    }

    public Class<CBORParser.Feature> getFormatReadFeatureType() {
        return CBORParser.Feature.class;
    }

    public Class<CBORGenerator.Feature> getFormatWriteFeatureType() {
        return CBORGenerator.Feature.class;
    }

    public final CBORFactory configure(CBORParser.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public CBORFactory enable(CBORParser.Feature f) {
        this._formatParserFeatures |= f.getMask();
        return this;
    }

    public CBORFactory disable(CBORParser.Feature f) {
        this._formatParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(CBORParser.Feature f) {
        return (this._formatParserFeatures & f.getMask()) != 0;
    }

    public final CBORFactory configure(CBORGenerator.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public CBORFactory enable(CBORGenerator.Feature f) {
        this._formatGeneratorFeatures |= f.getMask();
        return this;
    }

    public CBORFactory disable(CBORGenerator.Feature f) {
        this._formatGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(CBORGenerator.Feature f) {
        return (this._formatGeneratorFeatures & f.getMask()) != 0;
    }

    @Override
    public CBORParser createParser(File f) throws IOException {
        return this._createParser(new FileInputStream(f), this._createContext(f, true));
    }

    @Override
    public CBORParser createParser(URL url) throws IOException {
        return this._createParser(this._optimizedStreamFromURL(url), this._createContext(url, true));
    }

    @Override
    public CBORParser createParser(InputStream in) throws IOException {
        return this._createParser(in, this._createContext(in, false));
    }

    @Override
    public CBORParser createParser(byte[] data) throws IOException {
        return this._createParser(data, 0, data.length, this._createContext(data, true));
    }

    @Override
    public CBORParser createParser(byte[] data, int offset, int len) throws IOException {
        return this._createParser(data, offset, len, this._createContext(data, true));
    }

    @Override
    public CBORGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this._createCBORGenerator(this._createContext(out, false), this._generatorFeatures, this._formatGeneratorFeatures, this._objectCodec, out);
    }

    @Override
    public CBORGenerator createGenerator(OutputStream out) throws IOException {
        return this._createCBORGenerator(this._createContext(out, false), this._generatorFeatures, this._formatGeneratorFeatures, this._objectCodec, out);
    }

    @Override
    protected IOContext _createContext(Object srcRef, boolean resourceManaged) {
        return super._createContext(srcRef, resourceManaged);
    }

    @Override
    protected CBORParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        return new CBORParserBootstrapper(ctxt, in).constructParser(this._factoryFeatures, this._parserFeatures, this._formatParserFeatures, this._objectCodec, this._byteSymbolCanonicalizer);
    }

    @Override
    protected JsonParser _createParser(Reader r, IOContext ctxt) throws IOException {
        return (JsonParser)this._nonByteSource();
    }

    @Override
    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        return (JsonParser)this._nonByteSource();
    }

    @Override
    protected CBORParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        return new CBORParserBootstrapper(ctxt, data, offset, len).constructParser(this._factoryFeatures, this._parserFeatures, this._formatParserFeatures, this._objectCodec, this._byteSymbolCanonicalizer);
    }

    @Override
    protected CBORGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        return (CBORGenerator)this._nonByteTarget();
    }

    @Override
    protected CBORGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createCBORGenerator(ctxt, this._generatorFeatures, this._formatGeneratorFeatures, this._objectCodec, out);
    }

    @Override
    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        return (Writer)this._nonByteTarget();
    }

    private final CBORGenerator _createCBORGenerator(IOContext ctxt, int stdFeat, int formatFeat, ObjectCodec codec, OutputStream out) throws IOException {
        CBORGenerator gen = new CBORGenerator(ctxt, stdFeat, formatFeat, this._objectCodec, out);
        if (CBORGenerator.Feature.WRITE_TYPE_HEADER.enabledIn(formatFeat)) {
            gen.writeTag(55799);
        }
        return gen;
    }

    protected <T> T _nonByteTarget() {
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    protected <T> T _nonByteSource() {
        throw new UnsupportedOperationException("Can not create generator for non-byte-based source");
    }
}

