/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage.core;

public final class Base64 {
    private static final String BASE_64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final byte[] DECODE_64 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    public static byte[] decode(String data) {
        if (data == null) {
            throw new IllegalArgumentException("The String is not a valid Base64-encoded string.");
        }
        int byteArrayLength = 3 * data.length() / 4;
        if (data.endsWith("==")) {
            byteArrayLength -= 2;
        } else if (data.endsWith("=")) {
            --byteArrayLength;
        }
        byte[] retArray = new byte[byteArrayLength];
        int byteDex = 0;
        for (int charDex = 0; charDex < data.length(); charDex += 4) {
            byte char1 = DECODE_64[(byte)data.charAt(charDex)];
            byte char2 = DECODE_64[(byte)data.charAt(charDex + 1)];
            byte char3 = DECODE_64[(byte)data.charAt(charDex + 2)];
            byte char4 = DECODE_64[(byte)data.charAt(charDex + 3)];
            if (char1 < 0 || char2 < 0 || char3 == -1 || char4 == -1) {
                throw new IllegalArgumentException("The String is not a valid Base64-encoded string.");
            }
            int tVal = char1 << 18;
            tVal += char2 << 12;
            tVal += (char3 & 0xFF) << 6;
            tVal += char4 & 0xFF;
            if (char3 == -2) {
                retArray[byteDex++] = (byte)((tVal &= 0xFFF000) >> 16 & 0xFF);
                continue;
            }
            if (char4 == -2) {
                retArray[byteDex++] = (byte)((tVal &= 0xFFFFC0) >> 16 & 0xFF);
                retArray[byteDex++] = (byte)(tVal >> 8 & 0xFF);
                continue;
            }
            retArray[byteDex++] = (byte)(tVal >> 16 & 0xFF);
            retArray[byteDex++] = (byte)(tVal >> 8 & 0xFF);
            retArray[byteDex++] = (byte)(tVal & 0xFF);
        }
        return retArray;
    }

    public static Byte[] decodeAsByteObjectArray(String data) {
        int byteArrayLength = 3 * data.length() / 4;
        if (data.endsWith("==")) {
            byteArrayLength -= 2;
        } else if (data.endsWith("=")) {
            --byteArrayLength;
        }
        Byte[] retArray = new Byte[byteArrayLength];
        int byteDex = 0;
        for (int charDex = 0; charDex < data.length(); charDex += 4) {
            byte char1 = DECODE_64[(byte)data.charAt(charDex)];
            byte char2 = DECODE_64[(byte)data.charAt(charDex + 1)];
            byte char3 = DECODE_64[(byte)data.charAt(charDex + 2)];
            byte char4 = DECODE_64[(byte)data.charAt(charDex + 3)];
            if (char1 < 0 || char2 < 0 || char3 == -1 || char4 == -1) {
                throw new IllegalArgumentException("The String is not a valid Base64-encoded string.");
            }
            int tVal = char1 << 18;
            tVal += char2 << 12;
            tVal += (char3 & 0xFF) << 6;
            tVal += char4 & 0xFF;
            if (char3 == -2) {
                retArray[byteDex++] = (byte)((tVal &= 0xFFF000) >> 16 & 0xFF);
                continue;
            }
            if (char4 == -2) {
                retArray[byteDex++] = (byte)((tVal &= 0xFFFFC0) >> 16 & 0xFF);
                retArray[byteDex++] = (byte)(tVal >> 8 & 0xFF);
                continue;
            }
            retArray[byteDex++] = (byte)(tVal >> 16 & 0xFF);
            retArray[byteDex++] = (byte)(tVal >> 8 & 0xFF);
            retArray[byteDex++] = (byte)(tVal & 0xFF);
        }
        return retArray;
    }

    public static String encode(byte[] data) {
        StringBuilder builder = new StringBuilder();
        int dataRemainder = data.length % 3;
        int n = 0;
        for (int j = 0; j < data.length; j += 3) {
            if (j < data.length - dataRemainder) {
                n = ((data[j] & 0xFF) << 16) + ((data[j + 1] & 0xFF) << 8) + (data[j + 2] & 0xFF);
            } else if (dataRemainder == 1) {
                n = (data[j] & 0xFF) << 16;
            } else if (dataRemainder == 2) {
                n = ((data[j] & 0xFF) << 16) + ((data[j + 1] & 0xFF) << 8);
            }
            builder.append(BASE_64_CHARS.charAt((byte)(n >>> 18 & 0x3F)));
            builder.append(BASE_64_CHARS.charAt((byte)(n >>> 12 & 0x3F)));
            builder.append(BASE_64_CHARS.charAt((byte)(n >>> 6 & 0x3F)));
            builder.append(BASE_64_CHARS.charAt((byte)(n & 0x3F)));
        }
        int bLength = builder.length();
        if (data.length % 3 == 1) {
            builder.replace(bLength - 2, bLength, "==");
        } else if (data.length % 3 == 2) {
            builder.replace(bLength - 1, bLength, "=");
        }
        return builder.toString();
    }

    public static String encode(Byte[] data) {
        StringBuilder builder = new StringBuilder();
        int dataRemainder = data.length % 3;
        int n = 0;
        for (int j = 0; j < data.length; j += 3) {
            if (j < data.length - dataRemainder) {
                n = ((data[j] & 0xFF) << 16) + ((data[j + 1] & 0xFF) << 8) + (data[j + 2] & 0xFF);
            } else if (dataRemainder == 1) {
                n = (data[j] & 0xFF) << 16;
            } else if (dataRemainder == 2) {
                n = ((data[j] & 0xFF) << 16) + ((data[j + 1] & 0xFF) << 8);
            }
            builder.append(BASE_64_CHARS.charAt((byte)(n >>> 18 & 0x3F)));
            builder.append(BASE_64_CHARS.charAt((byte)(n >>> 12 & 0x3F)));
            builder.append(BASE_64_CHARS.charAt((byte)(n >>> 6 & 0x3F)));
            builder.append(BASE_64_CHARS.charAt((byte)(n & 0x3F)));
        }
        int bLength = builder.length();
        if (data.length % 3 == 1) {
            builder.replace(bLength - 2, bLength, "==");
        } else if (data.length % 3 == 2) {
            builder.replace(bLength - 1, bLength, "=");
        }
        return builder.toString();
    }

    public static boolean validateIsBase64String(String data) {
        if (data == null || data.length() % 4 != 0) {
            return false;
        }
        for (int m = 0; m < data.length(); ++m) {
            byte charByte = (byte)data.charAt(m);
            if (DECODE_64[charByte] == -2) {
                if (m < data.length() - 2) {
                    return false;
                }
                if (m == data.length() - 2 && DECODE_64[(byte)data.charAt(m + 1)] != -2) {
                    return false;
                }
            }
            if (charByte >= 0 && DECODE_64[charByte] != -1) continue;
            return false;
        }
        return true;
    }

    private Base64() {
    }
}

