/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.adhoc.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.adhoc.configuration.AdhocColumn;
import net.sf.dynamicreports.adhoc.configuration.AdhocComponent;
import net.sf.dynamicreports.adhoc.configuration.AdhocGroup;
import net.sf.dynamicreports.adhoc.configuration.AdhocPage;
import net.sf.dynamicreports.adhoc.configuration.AdhocProperties;
import net.sf.dynamicreports.adhoc.configuration.AdhocSort;
import net.sf.dynamicreports.adhoc.configuration.AdhocStyle;
import net.sf.dynamicreports.adhoc.configuration.AdhocSubtotal;

public class AdhocReport
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private AdhocStyle textStyle;
    private AdhocStyle columnStyle;
    private AdhocStyle columnTitleStyle;
    private AdhocStyle groupStyle;
    private AdhocStyle groupTitleStyle;
    private AdhocStyle subtotalStyle;
    private AdhocStyle detailOddRowStyle;
    private Boolean highlightDetailOddRows;
    private AdhocStyle detailEvenRowStyle;
    private Boolean highlightDetailEvenRows;
    private Boolean ignorePagination;
    private Boolean tableOfContents;
    private AdhocPage page;
    private List<AdhocColumn> columns = new ArrayList<AdhocColumn>();
    private List<AdhocGroup> groups = new ArrayList<AdhocGroup>();
    private List<AdhocSort> sorts = new ArrayList<AdhocSort>();
    private List<AdhocSubtotal> subtotals = new ArrayList<AdhocSubtotal>();
    private List<AdhocComponent> components = new ArrayList<AdhocComponent>();
    private AdhocProperties properties = new AdhocProperties();

    public AdhocStyle getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(AdhocStyle textStyle) {
        this.textStyle = textStyle;
    }

    public AdhocStyle getColumnStyle() {
        return this.columnStyle;
    }

    public void setColumnStyle(AdhocStyle columnStyle) {
        this.columnStyle = columnStyle;
    }

    public AdhocStyle getColumnTitleStyle() {
        return this.columnTitleStyle;
    }

    public void setColumnTitleStyle(AdhocStyle columnTitleStyle) {
        this.columnTitleStyle = columnTitleStyle;
    }

    public AdhocStyle getGroupStyle() {
        return this.groupStyle;
    }

    public void setGroupStyle(AdhocStyle groupStyle) {
        this.groupStyle = groupStyle;
    }

    public AdhocStyle getGroupTitleStyle() {
        return this.groupTitleStyle;
    }

    public void setGroupTitleStyle(AdhocStyle groupTitleStyle) {
        this.groupTitleStyle = groupTitleStyle;
    }

    public AdhocStyle getSubtotalStyle() {
        return this.subtotalStyle;
    }

    public void setSubtotalStyle(AdhocStyle subtotalStyle) {
        this.subtotalStyle = subtotalStyle;
    }

    public AdhocStyle getDetailOddRowStyle() {
        return this.detailOddRowStyle;
    }

    public void setDetailOddRowStyle(AdhocStyle detailOddRowStyle) {
        this.detailOddRowStyle = detailOddRowStyle;
    }

    public Boolean getHighlightDetailOddRows() {
        return this.highlightDetailOddRows;
    }

    public void setHighlightDetailOddRows(Boolean highlightDetailOddRows) {
        this.highlightDetailOddRows = highlightDetailOddRows;
    }

    public AdhocStyle getDetailEvenRowStyle() {
        return this.detailEvenRowStyle;
    }

    public void setDetailEvenRowStyle(AdhocStyle detailEvenRowStyle) {
        this.detailEvenRowStyle = detailEvenRowStyle;
    }

    public Boolean getHighlightDetailEvenRows() {
        return this.highlightDetailEvenRows;
    }

    public void setHighlightDetailEvenRows(Boolean highlightDetailEvenRows) {
        this.highlightDetailEvenRows = highlightDetailEvenRows;
    }

    public Boolean getIgnorePagination() {
        return this.ignorePagination;
    }

    public void setIgnorePagination(Boolean ignorePagination) {
        this.ignorePagination = ignorePagination;
    }

    public Boolean getTableOfContents() {
        return this.tableOfContents;
    }

    public void setTableOfContents(Boolean tableOfContents) {
        this.tableOfContents = tableOfContents;
    }

    public AdhocPage getPage() {
        return this.page;
    }

    public void setPage(AdhocPage page) {
        this.page = page;
    }

    public List<AdhocColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<AdhocColumn> columns) {
        this.columns = columns;
    }

    public AdhocColumn getColumn(String name) {
        if (this.columns == null) {
            return null;
        }
        for (AdhocColumn column : this.columns) {
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    public void addColumn(AdhocColumn column) {
        this.columns.add(column);
    }

    public List<AdhocGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<AdhocGroup> groups) {
        this.groups = groups;
    }

    public void addGroup(AdhocGroup group) {
        this.groups.add(group);
    }

    public List<AdhocSort> getSorts() {
        return this.sorts;
    }

    public void setSorts(List<AdhocSort> sorts) {
        this.sorts = sorts;
    }

    public void addSort(AdhocSort sort) {
        this.sorts.add(sort);
    }

    public List<AdhocSubtotal> getSubtotals() {
        return this.subtotals;
    }

    public void setSubtotals(List<AdhocSubtotal> subtotals) {
        this.subtotals = subtotals;
    }

    public void addSubtotal(AdhocSubtotal subtotal) {
        this.subtotals.add(subtotal);
    }

    public List<AdhocComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<AdhocComponent> components) {
        this.components = components;
    }

    public AdhocComponent getComponent(String key) {
        if (this.components == null) {
            return null;
        }
        for (AdhocComponent component : this.components) {
            if (!key.equals(component.getKey())) continue;
            return component;
        }
        return null;
    }

    public void addComponent(AdhocComponent component) {
        this.components.add(component);
    }

    public void setComponent(String key, AdhocComponent component) {
        int index = -1;
        for (AdhocComponent cmp : this.components) {
            if (!key.equals(cmp.getKey())) continue;
            index = this.components.indexOf(cmp);
            break;
        }
        if (index != -1) {
            this.components.set(index, component);
        } else {
            this.addComponent(component);
        }
    }

    public AdhocProperties getProperties() {
        return this.properties;
    }

    public void setProperties(AdhocProperties properties) {
        this.properties = properties;
    }

    public <T> T getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.setProperty(key, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdhocReport)) {
            return false;
        }
        AdhocReport object = (AdhocReport)obj;
        if (!(this.textStyle != null ? this.textStyle.equals(object.getTextStyle()) : object.getTextStyle() == null)) {
            return false;
        }
        if (!(this.columnStyle != null ? this.columnStyle.equals(object.getColumnStyle()) : object.getColumnStyle() == null)) {
            return false;
        }
        if (!(this.columnTitleStyle != null ? this.columnTitleStyle.equals(object.getColumnTitleStyle()) : object.getColumnTitleStyle() == null)) {
            return false;
        }
        if (!(this.groupStyle != null ? this.groupStyle.equals(object.getGroupStyle()) : object.getGroupStyle() == null)) {
            return false;
        }
        if (!(this.groupTitleStyle != null ? this.groupTitleStyle.equals(object.getGroupTitleStyle()) : object.getGroupTitleStyle() == null)) {
            return false;
        }
        if (!(this.subtotalStyle != null ? this.subtotalStyle.equals(object.getSubtotalStyle()) : object.getSubtotalStyle() == null)) {
            return false;
        }
        if (!(this.detailOddRowStyle != null ? this.detailOddRowStyle.equals(object.getDetailOddRowStyle()) : object.getDetailOddRowStyle() == null)) {
            return false;
        }
        if (!(this.highlightDetailOddRows != null ? this.highlightDetailOddRows.equals(object.getHighlightDetailOddRows()) : object.getHighlightDetailOddRows() == null)) {
            return false;
        }
        if (!(this.detailEvenRowStyle != null ? this.detailEvenRowStyle.equals(object.getDetailEvenRowStyle()) : object.getDetailEvenRowStyle() == null)) {
            return false;
        }
        if (!(this.highlightDetailEvenRows != null ? this.highlightDetailEvenRows.equals(object.getHighlightDetailEvenRows()) : object.getHighlightDetailEvenRows() == null)) {
            return false;
        }
        if (!(this.ignorePagination != null ? this.ignorePagination.equals(object.getIgnorePagination()) : object.getIgnorePagination() == null)) {
            return false;
        }
        if (!(this.tableOfContents != null ? this.tableOfContents.equals(object.getTableOfContents()) : object.getTableOfContents() == null)) {
            return false;
        }
        if (!(this.page != null ? this.page.equals(object.getPage()) : object.getPage() == null)) {
            return false;
        }
        if (!(this.columns != null ? this.columns.equals(object.getColumns()) : object.getColumns() == null)) {
            return false;
        }
        if (!(this.groups != null ? this.groups.equals(object.getGroups()) : object.getGroups() == null)) {
            return false;
        }
        if (!(this.sorts != null ? this.sorts.equals(object.getSorts()) : object.getSorts() == null)) {
            return false;
        }
        if (!(this.subtotals != null ? this.subtotals.equals(object.getSubtotals()) : object.getSubtotals() == null)) {
            return false;
        }
        if (!(this.components != null ? this.components.equals(object.getComponents()) : object.getComponents() == null)) {
            return false;
        }
        return this.properties != null ? this.properties.equals(object.getProperties()) : object.getProperties() == null;
    }

    public AdhocReport clone() {
        AdhocReport clone;
        try {
            clone = (AdhocReport)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.textStyle != null) {
            clone.textStyle = this.textStyle.clone();
        }
        if (this.columnStyle != null) {
            clone.columnStyle = this.columnStyle.clone();
        }
        if (this.columnTitleStyle != null) {
            clone.columnTitleStyle = this.columnTitleStyle.clone();
        }
        if (this.groupStyle != null) {
            clone.groupStyle = this.groupStyle.clone();
        }
        if (this.groupTitleStyle != null) {
            clone.groupTitleStyle = this.groupTitleStyle.clone();
        }
        if (this.subtotalStyle != null) {
            clone.subtotalStyle = this.subtotalStyle.clone();
        }
        if (this.detailOddRowStyle != null) {
            clone.detailOddRowStyle = this.detailOddRowStyle.clone();
        }
        if (this.detailEvenRowStyle != null) {
            clone.detailEvenRowStyle = this.detailEvenRowStyle.clone();
        }
        if (this.page != null) {
            clone.page = this.page.clone();
        }
        if (this.columns != null) {
            clone.columns = new ArrayList<AdhocColumn>();
            for (AdhocColumn adhocColumn : this.columns) {
                clone.addColumn(adhocColumn.clone());
            }
        }
        if (this.groups != null) {
            clone.groups = new ArrayList<AdhocGroup>();
            for (AdhocGroup adhocGroup : this.groups) {
                clone.addGroup(adhocGroup);
            }
        }
        if (this.sorts != null) {
            clone.sorts = new ArrayList<AdhocSort>();
            for (AdhocSort adhocSort : this.sorts) {
                clone.addSort(adhocSort);
            }
        }
        if (this.subtotals != null) {
            clone.subtotals = new ArrayList<AdhocSubtotal>();
            for (AdhocSubtotal adhocSubtotal : this.subtotals) {
                clone.addSubtotal(adhocSubtotal);
            }
        }
        if (this.components != null) {
            clone.components = new ArrayList<AdhocComponent>();
            for (AdhocComponent adhocComponent : this.components) {
                clone.addComponent(adhocComponent);
            }
        }
        if (this.properties != null) {
            clone.properties = this.properties.clone();
        }
        return clone;
    }
}

