/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.adhoc.report;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.dynamicreports.adhoc.configuration.AdhocAxisFormat;
import net.sf.dynamicreports.adhoc.configuration.AdhocCalculation;
import net.sf.dynamicreports.adhoc.configuration.AdhocChart;
import net.sf.dynamicreports.adhoc.configuration.AdhocChartSerie;
import net.sf.dynamicreports.adhoc.configuration.AdhocChartType;
import net.sf.dynamicreports.adhoc.configuration.AdhocColumn;
import net.sf.dynamicreports.adhoc.configuration.AdhocComponent;
import net.sf.dynamicreports.adhoc.configuration.AdhocFont;
import net.sf.dynamicreports.adhoc.configuration.AdhocGroup;
import net.sf.dynamicreports.adhoc.configuration.AdhocGroupHeaderLayout;
import net.sf.dynamicreports.adhoc.configuration.AdhocHorizontalAlignment;
import net.sf.dynamicreports.adhoc.configuration.AdhocOrderType;
import net.sf.dynamicreports.adhoc.configuration.AdhocOrientation;
import net.sf.dynamicreports.adhoc.configuration.AdhocPage;
import net.sf.dynamicreports.adhoc.configuration.AdhocPageOrientation;
import net.sf.dynamicreports.adhoc.configuration.AdhocPen;
import net.sf.dynamicreports.adhoc.configuration.AdhocReport;
import net.sf.dynamicreports.adhoc.configuration.AdhocSort;
import net.sf.dynamicreports.adhoc.configuration.AdhocStyle;
import net.sf.dynamicreports.adhoc.configuration.AdhocSubtotal;
import net.sf.dynamicreports.adhoc.configuration.AdhocSubtotalPosition;
import net.sf.dynamicreports.adhoc.configuration.AdhocTextField;
import net.sf.dynamicreports.adhoc.configuration.AdhocTimePeriod;
import net.sf.dynamicreports.adhoc.configuration.AdhocVerticalAlignment;
import net.sf.dynamicreports.adhoc.exception.AdhocException;
import net.sf.dynamicreports.adhoc.report.AdhocReportCustomizer;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.MarginBuilder;
import net.sf.dynamicreports.report.builder.ReportBuilder;
import net.sf.dynamicreports.report.builder.SortBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractBaseChartBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractCategoryChartBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractCategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractChartBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractPieChartBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractTimeSeriesChartBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractXyChartBuilder;
import net.sf.dynamicreports.report.builder.chart.AreaChartBuilder;
import net.sf.dynamicreports.report.builder.chart.AxisFormatBuilder;
import net.sf.dynamicreports.report.builder.chart.Bar3DChartBuilder;
import net.sf.dynamicreports.report.builder.chart.BarChartBuilder;
import net.sf.dynamicreports.report.builder.chart.BubbleChartBuilder;
import net.sf.dynamicreports.report.builder.chart.CategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.Charts;
import net.sf.dynamicreports.report.builder.chart.DifferenceChartBuilder;
import net.sf.dynamicreports.report.builder.chart.GroupedCategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.GroupedStackedBarChartBuilder;
import net.sf.dynamicreports.report.builder.chart.LayeredBarChartBuilder;
import net.sf.dynamicreports.report.builder.chart.LineChartBuilder;
import net.sf.dynamicreports.report.builder.chart.Pie3DChartBuilder;
import net.sf.dynamicreports.report.builder.chart.PieChartBuilder;
import net.sf.dynamicreports.report.builder.chart.ScatterChartBuilder;
import net.sf.dynamicreports.report.builder.chart.SpiderChartBuilder;
import net.sf.dynamicreports.report.builder.chart.StackedAreaChartBuilder;
import net.sf.dynamicreports.report.builder.chart.StackedBar3DChartBuilder;
import net.sf.dynamicreports.report.builder.chart.StackedBarChartBuilder;
import net.sf.dynamicreports.report.builder.chart.TimeSeriesChartBuilder;
import net.sf.dynamicreports.report.builder.chart.WaterfallBarChartBuilder;
import net.sf.dynamicreports.report.builder.chart.XyAreaChartBuilder;
import net.sf.dynamicreports.report.builder.chart.XyBarChartBuilder;
import net.sf.dynamicreports.report.builder.chart.XyChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.XyLineChartBuilder;
import net.sf.dynamicreports.report.builder.chart.XyStepChartBuilder;
import net.sf.dynamicreports.report.builder.chart.XyzChartSerieBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.Columns;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.Components;
import net.sf.dynamicreports.report.builder.component.DimensionComponentBuilder;
import net.sf.dynamicreports.report.builder.component.TextFieldBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.group.Groups;
import net.sf.dynamicreports.report.builder.style.BaseStyleBuilder;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.builder.style.PenBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.SimpleStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.builder.style.Styles;
import net.sf.dynamicreports.report.builder.subtotal.AggregationSubtotalBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.builder.subtotal.Subtotals;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.GroupHeaderLayout;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.constant.OrderType;
import net.sf.dynamicreports.report.constant.Orientation;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.TimePeriod;
import net.sf.dynamicreports.report.constant.VerticalTextAlignment;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class DefaultAdhocReportCustomizer
implements AdhocReportCustomizer {
    protected ReportBuilder<?> report;
    protected AdhocReport adhocReport;
    protected Map<String, ColumnBuilder<?, ?>> columns = new LinkedHashMap();
    protected Map<String, GroupBuilder<?>> groups = new LinkedHashMap();
    protected Map<String, ComponentBuilder<?, ?>> components = new LinkedHashMap();

    @Override
    public void customize(ReportBuilder<?> report, AdhocReport adhocReport) throws DRException {
        this.report = report;
        this.adhocReport = adhocReport;
        report.setTextStyle((ReportStyleBuilder)this.style(adhocReport.getTextStyle()));
        report.setColumnStyle((ReportStyleBuilder)this.style(adhocReport.getColumnStyle()));
        report.setColumnTitleStyle((ReportStyleBuilder)this.style(adhocReport.getColumnTitleStyle()));
        report.setGroupStyle((ReportStyleBuilder)this.style(adhocReport.getGroupStyle()));
        report.setGroupTitleStyle((ReportStyleBuilder)this.style(adhocReport.getGroupTitleStyle()));
        report.setSubtotalStyle((ReportStyleBuilder)this.style(adhocReport.getSubtotalStyle()));
        report.setDetailOddRowStyle(this.simpleStyle(adhocReport.getDetailOddRowStyle()));
        report.setHighlightDetailOddRows(adhocReport.getHighlightDetailOddRows());
        report.setDetailEvenRowStyle(this.simpleStyle(adhocReport.getDetailEvenRowStyle()));
        report.setHighlightDetailEvenRows(adhocReport.getHighlightDetailEvenRows());
        report.setIgnorePagination(adhocReport.getIgnorePagination());
        report.setTableOfContents(adhocReport.getTableOfContents());
        this.page(report, adhocReport.getPage());
        if (adhocReport.getPage() != null) {
            report.setIgnorePageWidth(adhocReport.getPage().getIgnorePageWidth());
        }
        for (AdhocColumn adhocColumn : adhocReport.getColumns()) {
            ColumnBuilder<?, ?> column = this.column(adhocColumn);
            if (column == null) continue;
            report.addColumn(new ColumnBuilder[]{column});
            this.columns.put(adhocColumn.getName(), column);
        }
        for (AdhocGroup adhocGroup : adhocReport.getGroups()) {
            GroupBuilder<?> group = this.group(adhocGroup);
            report.addGroup(new GroupBuilder[]{group});
            this.groups.put(adhocGroup.getName(), group);
        }
        for (AdhocSort adhocSort : adhocReport.getSorts()) {
            SortBuilder sort = this.sort(adhocSort);
            report.addSort(new SortBuilder[]{sort});
        }
        for (AdhocComponent adhocComponent : adhocReport.getComponents()) {
            ComponentBuilder<?, ?> component = this.component(adhocComponent);
            this.components.put(adhocComponent.getKey(), component);
        }
        this.addSubtotals();
        this.addComponents();
    }

    protected String getFieldLabel(String name) {
        return name;
    }

    protected DRIDataType<?, ?> getFieldType(String name) {
        return null;
    }

    protected DRIExpression<?> getFieldExpression(String name) {
        DRIDataType<?, ?> type = this.getFieldType(name);
        if (type != null) {
            return (DRIExpression)DynamicReports.field((String)name, type).build();
        }
        return (DRIExpression)DynamicReports.field((String)name, Object.class).build();
    }

    protected ColumnBuilder<?, ?> column(AdhocColumn adhocColumn) {
        TextColumnBuilder column = Columns.column(this.getFieldExpression(adhocColumn.getName()));
        if (adhocColumn.getTitle() != null) {
            column.setTitle(adhocColumn.getTitle());
        } else {
            String columnTitle = this.getFieldLabel(adhocColumn.getName());
            if (columnTitle != null) {
                column.setTitle(columnTitle);
            }
        }
        if (adhocColumn.getWidth() != null) {
            column.setFixedWidth(adhocColumn.getWidth());
        }
        column.setStyle((ReportStyleBuilder)this.style(adhocColumn.getStyle()));
        column.setTitleStyle((ReportStyleBuilder)this.style(adhocColumn.getTitleStyle()));
        return column;
    }

    protected GroupBuilder<?> group(AdhocGroup adhocGroup) {
        ColumnBuilder<?, ?> groupColumn = this.columns.get(adhocGroup.getName());
        Object group = groupColumn != null && groupColumn instanceof ValueColumnBuilder ? Groups.group((ValueColumnBuilder)((ValueColumnBuilder)groupColumn)) : Groups.group(this.getFieldExpression(adhocGroup.getName()));
        group.setStartInNewPage(adhocGroup.getStartInNewPage());
        group.setHeaderLayout(this.groupHeaderLayout(adhocGroup.getHeaderLayout()));
        group.setStyle((ReportStyleBuilder)this.style(adhocGroup.getStyle()));
        group.setTitleStyle((ReportStyleBuilder)this.style(adhocGroup.getTitleStyle()));
        return group;
    }

    protected GroupHeaderLayout groupHeaderLayout(AdhocGroupHeaderLayout groupHeaderLayout) {
        if (groupHeaderLayout == null) {
            return null;
        }
        switch (groupHeaderLayout) {
            case EMPTY: {
                return GroupHeaderLayout.EMPTY;
            }
            case VALUE: {
                return GroupHeaderLayout.VALUE;
            }
            case TITLE_AND_VALUE: {
                return GroupHeaderLayout.TITLE_AND_VALUE;
            }
        }
        throw new AdhocException("Group header layout" + groupHeaderLayout.name() + " is not supported");
    }

    protected void addSubtotals() {
        for (AdhocSubtotal adhocSubtotal : this.adhocReport.getSubtotals()) {
            SubtotalBuilder<?, ?> subtotal;
            if (adhocSubtotal.getPosition() == null || (subtotal = this.subtotal(adhocSubtotal)) == null) continue;
            this.addSubtotal(subtotal, adhocSubtotal.getPosition(), adhocSubtotal.getGroupName());
        }
        this.report.subtotalsAtSummary(this.subtotals());
    }

    protected SubtotalBuilder<?, ?>[] subtotals() {
        ArrayList subtotals = new ArrayList();
        for (AdhocSubtotal adhocSubtotal : this.adhocReport.getSubtotals()) {
            SubtotalBuilder<?, ?> subtotal;
            if (adhocSubtotal.getPosition() != null || (subtotal = this.subtotal(adhocSubtotal)) == null) continue;
            subtotals.add(subtotal);
        }
        return subtotals.toArray(new SubtotalBuilder[subtotals.size()]);
    }

    protected SubtotalBuilder<?, ?> subtotal(AdhocSubtotal adhocSubtotal) {
        if (this.adhocReport.getColumns().isEmpty()) {
            return null;
        }
        ColumnBuilder<?, ?> subtotalColumn = this.columns.get(adhocSubtotal.getName());
        AggregationSubtotalBuilder subtotal = subtotalColumn != null && subtotalColumn instanceof ValueColumnBuilder ? Subtotals.aggregate((ValueColumnBuilder)((ValueColumnBuilder)subtotalColumn), (Calculation)this.calculation(adhocSubtotal.getCalculation())) : Subtotals.aggregate(this.getFieldExpression(adhocSubtotal.getName()), (ColumnBuilder)((ValueColumnBuilder)subtotalColumn), (Calculation)this.calculation(adhocSubtotal.getCalculation()));
        if (adhocSubtotal.getLabel() != null) {
            subtotal.setLabel(adhocSubtotal.getLabel());
        }
        subtotal.setStyle((ReportStyleBuilder)this.style(adhocSubtotal.getStyle()));
        subtotal.setLabelStyle((ReportStyleBuilder)this.style(adhocSubtotal.getLabelStyle()));
        return subtotal;
    }

    protected Calculation calculation(AdhocCalculation adhocCalculation) {
        if (adhocCalculation == null) {
            return Calculation.NOTHING;
        }
        switch (adhocCalculation) {
            case NOTHING: {
                return Calculation.NOTHING;
            }
            case COUNT: {
                return Calculation.COUNT;
            }
            case SUM: {
                return Calculation.SUM;
            }
            case AVERAGE: {
                return Calculation.AVERAGE;
            }
            case LOWEST: {
                return Calculation.LOWEST;
            }
            case HIGHEST: {
                return Calculation.HIGHEST;
            }
            case STANDARD_DEVIATION: {
                return Calculation.STANDARD_DEVIATION;
            }
            case VARIANCE: {
                return Calculation.VARIANCE;
            }
            case FIRST: {
                return Calculation.FIRST;
            }
            case DISTINCT_COUNT: {
                return Calculation.DISTINCT_COUNT;
            }
        }
        throw new AdhocException("Calculation " + adhocCalculation.name() + " not supported");
    }

    protected void addSubtotal(SubtotalBuilder<?, ?> subtotal, AdhocSubtotalPosition adhocSubtotalPosition, String groupName) {
        Validate.notNull((Object)((Object)adhocSubtotalPosition), (String)"subtotalPosition must not be null", (Object[])new Object[0]);
        switch (adhocSubtotalPosition) {
            case TITLE: {
                this.report.addSubtotalAtTitle(new SubtotalBuilder[]{subtotal});
                break;
            }
            case PAGE_HEADER: {
                this.report.addSubtotalAtPageHeader(new SubtotalBuilder[]{subtotal});
                break;
            }
            case PAGE_FOOTER: {
                this.report.addSubtotalAtPageFooter(new SubtotalBuilder[]{subtotal});
                break;
            }
            case COLUMN_HEADER: {
                this.report.addSubtotalAtColumnHeader(new SubtotalBuilder[]{subtotal});
                break;
            }
            case COLUMN_FOOTER: {
                this.report.addSubtotalAtColumnFooter(new SubtotalBuilder[]{subtotal});
                break;
            }
            case GROUP_HEADER: {
                this.report.addSubtotalAtGroupHeader(this.groups.get(groupName), new SubtotalBuilder[]{subtotal});
                break;
            }
            case GROUP_FOOTER: {
                this.report.addSubtotalAtGroupFooter(this.groups.get(groupName), new SubtotalBuilder[]{subtotal});
                break;
            }
            case FIRST_GROUP_HEADER: {
                this.report.addSubtotalAtFirstGroupHeader(new SubtotalBuilder[]{subtotal});
                break;
            }
            case FIRST_GROUP_FOOTER: {
                this.report.addSubtotalAtFirstGroupFooter(new SubtotalBuilder[]{subtotal});
                break;
            }
            case LAST_GROUP_HEADER: {
                this.report.addSubtotalAtLastGroupHeader(new SubtotalBuilder[]{subtotal});
                break;
            }
            case LAST_GROUP_FOOTER: {
                this.report.addSubtotalAtLastGroupFooter(new SubtotalBuilder[]{subtotal});
                break;
            }
            case LAST_PAGE_FOOTER: {
                this.report.addSubtotalAtPageFooter(new SubtotalBuilder[]{subtotal});
                break;
            }
            case SUMMARY: {
                this.report.addSubtotalAtSummary(new SubtotalBuilder[]{subtotal});
                break;
            }
            default: {
                throw new AdhocException("SubtotalPosition " + adhocSubtotalPosition.name() + " not supported");
            }
        }
    }

    protected SortBuilder sort(AdhocSort adhocSort) {
        ColumnBuilder<?, ?> sortColumn = this.columns.get(adhocSort.getName());
        SortBuilder sort = sortColumn != null && sortColumn instanceof TextColumnBuilder ? DynamicReports.asc((TextColumnBuilder)((TextColumnBuilder)sortColumn)) : DynamicReports.asc(this.getFieldExpression(adhocSort.getName()));
        sort.setOrderType(this.orderType(adhocSort.getOrderType()));
        return sort;
    }

    protected OrderType orderType(AdhocOrderType adhocOrderType) {
        if (adhocOrderType == null) {
            return OrderType.ASCENDING;
        }
        switch (adhocOrderType) {
            case ASCENDING: {
                return OrderType.ASCENDING;
            }
            case DESCENDING: {
                return OrderType.DESCENDING;
            }
        }
        throw new AdhocException("Order type " + adhocOrderType.name() + " not supported");
    }

    protected BaseStyleBuilder<?, ?> baseStyle(AdhocStyle adhocStyle, BaseStyleBuilder<?, ?> baseStyle) {
        if (adhocStyle.getFont() != null) {
            baseStyle.setFont(this.font(adhocStyle.getFont()));
        }
        if (adhocStyle.getTopBorder() != null) {
            baseStyle.setTopBorder(this.pen(adhocStyle.getTopBorder()));
        }
        if (adhocStyle.getLeftBorder() != null) {
            baseStyle.setLeftBorder(this.pen(adhocStyle.getLeftBorder()));
        }
        if (adhocStyle.getBottomBorder() != null) {
            baseStyle.setBottomBorder(this.pen(adhocStyle.getBottomBorder()));
        }
        if (adhocStyle.getRightBorder() != null) {
            baseStyle.setRightBorder(this.pen(adhocStyle.getRightBorder()));
        }
        baseStyle.setForegroundColor(adhocStyle.getForegroundColor());
        baseStyle.setBackgroundColor(adhocStyle.getBackgroundColor());
        baseStyle.setHorizontalTextAlignment(this.horizontalTextAlignment(adhocStyle.getHorizontalAlignment()));
        baseStyle.setVerticalTextAlignment(this.verticalTextAlignment(adhocStyle.getVerticalAlignment()));
        baseStyle.setPattern(adhocStyle.getPattern());
        return baseStyle;
    }

    protected StyleBuilder style(AdhocStyle adhocStyle) {
        if (adhocStyle == null) {
            return null;
        }
        StyleBuilder style = Styles.style();
        this.baseStyle(adhocStyle, (BaseStyleBuilder<?, ?>)style);
        return style;
    }

    protected SimpleStyleBuilder simpleStyle(AdhocStyle adhocStyle) {
        if (adhocStyle == null) {
            return null;
        }
        SimpleStyleBuilder simpleStyle = Styles.simpleStyle();
        this.baseStyle(adhocStyle, (BaseStyleBuilder<?, ?>)simpleStyle);
        return simpleStyle;
    }

    protected FontBuilder font(AdhocFont adhocFont) {
        if (adhocFont == null) {
            return null;
        }
        FontBuilder font = Styles.font();
        font.setFontName(adhocFont.getFontName());
        font.setFontSize(adhocFont.getFontSize());
        font.setBold(adhocFont.getBold());
        font.setItalic(adhocFont.getItalic());
        font.setUnderline(adhocFont.getUnderline());
        font.setStrikeThrough(adhocFont.getStrikeThrough());
        return font;
    }

    protected PenBuilder pen(AdhocPen adhocPen) {
        if (adhocPen == null) {
            return null;
        }
        PenBuilder pen = Styles.pen();
        pen.setLineWidth(adhocPen.getLineWidth());
        pen.setLineColor(adhocPen.getLineColor());
        return pen;
    }

    protected HorizontalTextAlignment horizontalTextAlignment(AdhocHorizontalAlignment adhocHorizontalAlignment) {
        if (adhocHorizontalAlignment == null) {
            return null;
        }
        switch (adhocHorizontalAlignment) {
            case LEFT: {
                return HorizontalTextAlignment.LEFT;
            }
            case CENTER: {
                return HorizontalTextAlignment.CENTER;
            }
            case RIGHT: {
                return HorizontalTextAlignment.RIGHT;
            }
            case JUSTIFIED: {
                return HorizontalTextAlignment.JUSTIFIED;
            }
        }
        throw new AdhocException("Horizontal text alignment " + adhocHorizontalAlignment.name() + " not supported");
    }

    protected VerticalTextAlignment verticalTextAlignment(AdhocVerticalAlignment adhocVerticalAlignment) {
        if (adhocVerticalAlignment == null) {
            return null;
        }
        switch (adhocVerticalAlignment) {
            case TOP: {
                return VerticalTextAlignment.TOP;
            }
            case MIDDLE: {
                return VerticalTextAlignment.MIDDLE;
            }
            case BOTTOM: {
                return VerticalTextAlignment.BOTTOM;
            }
            case JUSTIFIED: {
                return VerticalTextAlignment.JUSTIFIED;
            }
        }
        throw new AdhocException("Vertical text alignment " + adhocVerticalAlignment.name() + " not supported");
    }

    protected void page(ReportBuilder<?> report, AdhocPage adhocPage) {
        if (adhocPage == null) {
            return;
        }
        report.setPageFormat(adhocPage.getWidth(), adhocPage.getHeight(), this.pageOrientation(adhocPage.getOrientation()));
        MarginBuilder margin = DynamicReports.margin();
        if (adhocPage.getTopMargin() != null) {
            margin.setTop(adhocPage.getTopMargin().intValue());
        }
        if (adhocPage.getBottomMargin() != null) {
            margin.setBottom(adhocPage.getBottomMargin().intValue());
        }
        if (adhocPage.getLeftMargin() != null) {
            margin.setLeft(adhocPage.getLeftMargin().intValue());
        }
        if (adhocPage.getRightMargin() != null) {
            margin.setRight(adhocPage.getRightMargin().intValue());
        }
        report.setPageMargin(margin);
        report.setIgnorePageWidth(adhocPage.getIgnorePageWidth());
    }

    protected PageOrientation pageOrientation(AdhocPageOrientation adhocPageOrientation) {
        if (adhocPageOrientation == null) {
            return PageOrientation.PORTRAIT;
        }
        switch (adhocPageOrientation) {
            case PORTRAIT: {
                return PageOrientation.PORTRAIT;
            }
            case LANDSCAPE: {
                return PageOrientation.LANDSCAPE;
            }
        }
        throw new AdhocException("Page orientation " + adhocPageOrientation.name() + " not supported");
    }

    protected void addComponents() {
    }

    protected ComponentBuilder<?, ?> component(AdhocComponent adhocComponent) {
        if (adhocComponent instanceof AdhocTextField) {
            return this.textField((AdhocTextField)adhocComponent);
        }
        if (adhocComponent instanceof AdhocChart) {
            return this.chart((AdhocChart)adhocComponent);
        }
        throw new AdhocException("Component " + adhocComponent.getClass().getName() + " not supported");
    }

    protected void component(AdhocComponent adhocComponent, ComponentBuilder<?, ?> component) {
        component.setStyle((ReportStyleBuilder)this.style(adhocComponent.getStyle()));
        if (component instanceof DimensionComponentBuilder) {
            if (adhocComponent.getWidth() != null) {
                ((DimensionComponentBuilder)component).setFixedWidth(adhocComponent.getWidth());
            }
            if (adhocComponent.getHeight() != null) {
                ((DimensionComponentBuilder)component).setFixedHeight(adhocComponent.getHeight());
            }
        }
    }

    protected TextFieldBuilder<?> textField(AdhocTextField adhocTextField) {
        TextFieldBuilder textField = Components.text((String)adhocTextField.getText());
        this.component(adhocTextField, (ComponentBuilder<?, ?>)textField);
        return textField;
    }

    protected AbstractChartBuilder<?> chart(AdhocChart adhocChart) {
        AdhocChartType type = adhocChart.getType();
        if (type == null) {
            type = AdhocChartType.BAR;
        }
        switch (type) {
            case AREA: {
                return this.areaChart(adhocChart);
            }
            case STACKEDAREA: {
                return this.stackedAreaChart(adhocChart);
            }
            case BAR: {
                return this.barChart(adhocChart);
            }
            case STACKEDBAR: {
                return this.stackedBarChart(adhocChart);
            }
            case GROUPEDSTACKEDBAR: {
                return this.groupedStackedBarChart(adhocChart);
            }
            case BAR3D: {
                return this.bar3DChart(adhocChart);
            }
            case STACKEDBAR3D: {
                return this.stackedBar3DChart(adhocChart);
            }
            case LINE: {
                return this.lineChart(adhocChart);
            }
            case LAYEREDBAR: {
                return this.layeredBarChart(adhocChart);
            }
            case WATERFALLBAR: {
                return this.waterfallBarChart(adhocChart);
            }
            case DIFFERENCE: {
                return this.differenceChart(adhocChart);
            }
            case PIE: {
                return this.pieChart(adhocChart);
            }
            case PIE3D: {
                return this.pie3DChart(adhocChart);
            }
            case SCATTER: {
                return this.scatterChart(adhocChart);
            }
            case SPIDER: {
                return this.spiderChart(adhocChart);
            }
            case TIMESERIES: {
                return this.timeSeriesChart(adhocChart);
            }
            case XYAREA: {
                return this.xyAreaChart(adhocChart);
            }
            case XYBAR: {
                return this.xyBarChart(adhocChart);
            }
            case XYLINE: {
                return this.xyLineChart(adhocChart);
            }
            case XYSTEP: {
                return this.xyStepChart(adhocChart);
            }
            case BUBBLE: {
                return this.bubbleChart(adhocChart);
            }
        }
        throw new AdhocException("Chart type " + type.name() + " not supported");
    }

    protected void chart(AdhocChart adhocChart, AbstractChartBuilder<?> chart) {
        this.component(adhocChart, (ComponentBuilder<?, ?>)chart);
        if (adhocChart.getTitle() != null) {
            chart.setTitle(adhocChart.getTitle());
        }
        if (adhocChart.getTitleFont() != null) {
            chart.setTitleFont(this.font(adhocChart.getTitleFont()));
        }
        chart.setTitleColor(adhocChart.getTitleColor());
        chart.setShowLegend(adhocChart.getShowLegend());
    }

    protected void baseChart(AdhocChart adhocChart, AbstractBaseChartBuilder<?, ?, ?> baseChart) {
        this.chart(adhocChart, (AbstractChartBuilder<?>)baseChart);
        if (adhocChart.getSeriesColors() != null && !adhocChart.getSeriesColors().isEmpty()) {
            for (Color adhocSeriesColor : adhocChart.getSeriesColors()) {
                baseChart.addSeriesColor(new Color[]{adhocSeriesColor});
            }
        }
        baseChart.setOrientation(this.orientation(adhocChart.getOrientation()));
    }

    protected void categoryChart(AdhocChart adhocChart, AbstractCategoryChartBuilder<?, ?> categoryChart) {
        AxisFormatBuilder valueAxisFormat;
        AxisFormatBuilder categoryAxisFormat;
        this.baseChart(adhocChart, (AbstractBaseChartBuilder<?, ?, ?>)categoryChart);
        ColumnBuilder<?, ?> valueColumn = this.columns.get(adhocChart.getXValue());
        if (valueColumn != null && valueColumn instanceof ValueColumnBuilder) {
            categoryChart.setCategory((ValueColumnBuilder)valueColumn);
        } else {
            DRIExpression<?> field = this.getFieldExpression(adhocChart.getXValue());
            categoryChart.setCategory(field);
        }
        if (adhocChart.getSeries() != null && !adhocChart.getSeries().isEmpty()) {
            for (AdhocChartSerie adhocChartSerie : adhocChart.getSeries()) {
                AdhocChartType chartType = adhocChart.getType();
                if (chartType != null && chartType.equals((Object)AdhocChartType.GROUPEDSTACKEDBAR)) {
                    categoryChart.addSerie(new AbstractCategoryChartSerieBuilder[]{this.groupedCategoryChartSerie(adhocChartSerie)});
                    continue;
                }
                categoryChart.addSerie(new AbstractCategoryChartSerieBuilder[]{this.categoryChartSerie(adhocChartSerie)});
            }
        }
        if ((categoryAxisFormat = this.axisFormat(adhocChart.getXAxisFormat())) != null) {
            categoryChart.setCategoryAxisFormat(categoryAxisFormat);
        }
        if ((valueAxisFormat = this.axisFormat(adhocChart.getYAxisFormat())) != null) {
            categoryChart.setValueAxisFormat(valueAxisFormat);
        }
        Boolean useSeriesAsCategory = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.useseriesascategory");
        categoryChart.setUseSeriesAsCategory(useSeriesAsCategory);
        Boolean showPercentages = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showpercentages");
        categoryChart.setShowPercentages(showPercentages);
    }

    protected void timeSeriesChart(AdhocChart adhocChart, AbstractTimeSeriesChartBuilder<?, ?> timeSeriesChart) {
        AxisFormatBuilder valueAxisFormat;
        AxisFormatBuilder timeAxisFormat;
        this.baseChart(adhocChart, (AbstractBaseChartBuilder<?, ?, ?>)timeSeriesChart);
        ColumnBuilder<?, ?> valueColumn = this.columns.get(adhocChart.getXValue());
        if (valueColumn != null && valueColumn instanceof ValueColumnBuilder) {
            timeSeriesChart.setTimePeriod((ValueColumnBuilder)valueColumn);
        } else {
            DRIExpression<?> field = this.getFieldExpression(adhocChart.getXValue());
            timeSeriesChart.setTimePeriod(field);
        }
        if (adhocChart.getSeries() != null && !adhocChart.getSeries().isEmpty()) {
            for (AdhocChartSerie adhocChartSerie : adhocChart.getSeries()) {
                timeSeriesChart.addSerie(new CategoryChartSerieBuilder[]{this.categoryChartSerie(adhocChartSerie)});
            }
        }
        if ((timeAxisFormat = this.axisFormat(adhocChart.getXAxisFormat())) != null) {
            timeSeriesChart.setTimeAxisFormat(timeAxisFormat);
        }
        if ((valueAxisFormat = this.axisFormat(adhocChart.getYAxisFormat())) != null) {
            timeSeriesChart.setValueAxisFormat(valueAxisFormat);
        }
        AdhocTimePeriod adhocTimePeriod = (AdhocTimePeriod)((Object)adhocChart.getProperty("net.sf.dynamicreports.chart.timeperiod"));
        timeSeriesChart.setTimePeriodType(this.timePeriodType(adhocTimePeriod));
        Boolean showValues = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showvalues");
        timeSeriesChart.setShowValues(showValues);
    }

    protected TimePeriod timePeriodType(AdhocTimePeriod timePeriod) {
        if (timePeriod == null) {
            return null;
        }
        switch (timePeriod) {
            case YEAR: {
                return TimePeriod.YEAR;
            }
            case QUARTER: {
                return TimePeriod.QUARTER;
            }
            case MONTH: {
                return TimePeriod.MONTH;
            }
            case WEEK: {
                return TimePeriod.WEEK;
            }
            case DAY: {
                return TimePeriod.DAY;
            }
            case HOUR: {
                return TimePeriod.HOUR;
            }
            case MINUTE: {
                return TimePeriod.MINUTE;
            }
            case SECOND: {
                return TimePeriod.SECOND;
            }
            case MILLISECOND: {
                return TimePeriod.MILLISECOND;
            }
        }
        throw new AdhocException("Time period type " + timePeriod.name() + " not supported");
    }

    protected void pieChart(AdhocChart adhocChart, AbstractPieChartBuilder<?, ?> pieChart) {
        this.baseChart(adhocChart, (AbstractBaseChartBuilder<?, ?, ?>)pieChart);
        ColumnBuilder<?, ?> valueColumn = this.columns.get(adhocChart.getXValue());
        if (valueColumn != null && valueColumn instanceof ValueColumnBuilder) {
            pieChart.setKey((ValueColumnBuilder)valueColumn);
        } else {
            DRIExpression<?> field = this.getFieldExpression(adhocChart.getXValue());
            pieChart.setKey(field);
        }
        if (adhocChart.getSeries() != null && !adhocChart.getSeries().isEmpty()) {
            for (AdhocChartSerie adhocChartSerie : adhocChart.getSeries()) {
                pieChart.addSerie(new CategoryChartSerieBuilder[]{this.categoryChartSerie(adhocChartSerie)});
            }
        }
        Boolean showValues = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showvalues");
        pieChart.setShowValues(showValues);
        Boolean showPercentages = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showpercentages");
        pieChart.setShowPercentages(showPercentages);
    }

    protected void xyChart(AdhocChart adhocChart, AbstractXyChartBuilder<?, ?> xyChart) {
        AxisFormatBuilder yAxisFormat;
        AxisFormatBuilder xAxisFormat;
        this.baseChart(adhocChart, (AbstractBaseChartBuilder<?, ?, ?>)xyChart);
        ColumnBuilder<?, ?> valueColumn = this.columns.get(adhocChart.getXValue());
        if (valueColumn != null && valueColumn instanceof ValueColumnBuilder) {
            xyChart.setXValue((ValueColumnBuilder)valueColumn);
        } else {
            DRIExpression<?> field = this.getFieldExpression(adhocChart.getXValue());
            xyChart.setXValue(field);
        }
        if (adhocChart.getSeries() != null && !adhocChart.getSeries().isEmpty()) {
            for (AdhocChartSerie adhocChartSerie : adhocChart.getSeries()) {
                xyChart.addSerie(new XyChartSerieBuilder[]{this.xyChartSerie(adhocChartSerie)});
            }
        }
        if ((xAxisFormat = this.axisFormat(adhocChart.getXAxisFormat())) != null) {
            xyChart.setXAxisFormat(xAxisFormat);
        }
        if ((yAxisFormat = this.axisFormat(adhocChart.getYAxisFormat())) != null) {
            xyChart.setYAxisFormat(yAxisFormat);
        }
    }

    protected void spiderChart(AdhocChart adhocChart, SpiderChartBuilder spiderChart) {
        this.chart(adhocChart, (AbstractChartBuilder<?>)spiderChart);
        ColumnBuilder<?, ?> valueColumn = this.columns.get(adhocChart.getXValue());
        if (valueColumn != null && valueColumn instanceof ValueColumnBuilder) {
            spiderChart.setCategory((ValueColumnBuilder)valueColumn);
        } else {
            DRIExpression<?> field = this.getFieldExpression(adhocChart.getXValue());
            spiderChart.setCategory(field);
        }
        if (adhocChart.getSeries() != null && !adhocChart.getSeries().isEmpty()) {
            for (AdhocChartSerie adhocChartSerie : adhocChart.getSeries()) {
                spiderChart.addSerie(new CategoryChartSerieBuilder[]{this.categoryChartSerie(adhocChartSerie)});
            }
        }
    }

    protected void bubbleChart(AdhocChart adhocChart, BubbleChartBuilder bubbleChart) {
        AxisFormatBuilder yAxisFormat;
        AxisFormatBuilder xAxisFormat;
        this.baseChart(adhocChart, (AbstractBaseChartBuilder<?, ?, ?>)bubbleChart);
        ColumnBuilder<?, ?> valueColumn = this.columns.get(adhocChart.getXValue());
        if (valueColumn != null && valueColumn instanceof ValueColumnBuilder) {
            bubbleChart.setXValue((ValueColumnBuilder)valueColumn);
        } else {
            DRIExpression<?> field = this.getFieldExpression(adhocChart.getXValue());
            bubbleChart.setXValue(field);
        }
        if (adhocChart.getSeries() != null && !adhocChart.getSeries().isEmpty()) {
            for (AdhocChartSerie adhocChartSerie : adhocChart.getSeries()) {
                bubbleChart.addSerie(new XyzChartSerieBuilder[]{this.xyzChartSerie(adhocChartSerie)});
            }
        }
        if ((xAxisFormat = this.axisFormat(adhocChart.getXAxisFormat())) != null) {
            bubbleChart.setXAxisFormat(xAxisFormat);
        }
        if ((yAxisFormat = this.axisFormat(adhocChart.getYAxisFormat())) != null) {
            bubbleChart.setYAxisFormat(yAxisFormat);
        }
    }

    protected AreaChartBuilder areaChart(AdhocChart adhocChart) {
        AreaChartBuilder areaChart = Charts.areaChart();
        this.categoryChart(adhocChart, (AbstractCategoryChartBuilder<?, ?>)areaChart);
        Boolean showValues = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showvalues");
        areaChart.setShowValues(showValues);
        return areaChart;
    }

    protected StackedAreaChartBuilder stackedAreaChart(AdhocChart adhocChart) {
        StackedAreaChartBuilder stackedAreaChart = Charts.stackedAreaChart();
        this.categoryChart(adhocChart, (AbstractCategoryChartBuilder<?, ?>)stackedAreaChart);
        return stackedAreaChart;
    }

    protected BarChartBuilder barChart(AdhocChart adhocChart) {
        BarChartBuilder barChart = Charts.barChart();
        this.categoryChart(adhocChart, (AbstractCategoryChartBuilder<?, ?>)barChart);
        Boolean showValues = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showvalues");
        barChart.setShowValues(showValues);
        return barChart;
    }

    protected StackedBarChartBuilder stackedBarChart(AdhocChart adhocChart) {
        StackedBarChartBuilder stackedBarChart = Charts.stackedBarChart();
        this.categoryChart(adhocChart, (AbstractCategoryChartBuilder<?, ?>)stackedBarChart);
        Boolean showValues = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showvalues");
        stackedBarChart.setShowValues(showValues);
        return stackedBarChart;
    }

    protected GroupedStackedBarChartBuilder groupedStackedBarChart(AdhocChart adhocChart) {
        GroupedStackedBarChartBuilder groupedStackedBarChart = Charts.groupedStackedBarChart();
        this.categoryChart(adhocChart, (AbstractCategoryChartBuilder<?, ?>)groupedStackedBarChart);
        Boolean showValues = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showvalues");
        groupedStackedBarChart.setShowValues(showValues);
        return groupedStackedBarChart;
    }

    protected Bar3DChartBuilder bar3DChart(AdhocChart adhocChart) {
        Bar3DChartBuilder bar3DChart = Charts.bar3DChart();
        this.categoryChart(adhocChart, (AbstractCategoryChartBuilder<?, ?>)bar3DChart);
        Boolean showValues = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showvalues");
        bar3DChart.setShowValues(showValues);
        return bar3DChart;
    }

    protected StackedBar3DChartBuilder stackedBar3DChart(AdhocChart adhocChart) {
        StackedBar3DChartBuilder stackedBar3DChart = Charts.stackedBar3DChart();
        this.categoryChart(adhocChart, (AbstractCategoryChartBuilder<?, ?>)stackedBar3DChart);
        Boolean showValues = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showvalues");
        stackedBar3DChart.setShowValues(showValues);
        return stackedBar3DChart;
    }

    protected LineChartBuilder lineChart(AdhocChart adhocChart) {
        LineChartBuilder lineChart = Charts.lineChart();
        this.categoryChart(adhocChart, (AbstractCategoryChartBuilder<?, ?>)lineChart);
        Boolean showValues = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showvalues");
        lineChart.setShowValues(showValues);
        return lineChart;
    }

    protected LayeredBarChartBuilder layeredBarChart(AdhocChart adhocChart) {
        LayeredBarChartBuilder layeredChart = Charts.layeredBarChart();
        this.categoryChart(adhocChart, (AbstractCategoryChartBuilder<?, ?>)layeredChart);
        return layeredChart;
    }

    protected WaterfallBarChartBuilder waterfallBarChart(AdhocChart adhocChart) {
        WaterfallBarChartBuilder waterfallChart = Charts.waterfallBarChart();
        this.categoryChart(adhocChart, (AbstractCategoryChartBuilder<?, ?>)waterfallChart);
        return waterfallChart;
    }

    protected DifferenceChartBuilder differenceChart(AdhocChart adhocChart) {
        DifferenceChartBuilder differenceChart = Charts.differenceChart();
        this.timeSeriesChart(adhocChart, (AbstractTimeSeriesChartBuilder<?, ?>)differenceChart);
        return differenceChart;
    }

    protected PieChartBuilder pieChart(AdhocChart adhocChart) {
        PieChartBuilder pieChart = Charts.pieChart();
        this.pieChart(adhocChart, (AbstractPieChartBuilder<?, ?>)pieChart);
        return pieChart;
    }

    protected Pie3DChartBuilder pie3DChart(AdhocChart adhocChart) {
        Pie3DChartBuilder pie3DChart = Charts.pie3DChart();
        this.pieChart(adhocChart, (AbstractPieChartBuilder<?, ?>)pie3DChart);
        return pie3DChart;
    }

    protected ScatterChartBuilder scatterChart(AdhocChart adhocChart) {
        ScatterChartBuilder scatterChart = Charts.scatterChart();
        this.xyChart(adhocChart, (AbstractXyChartBuilder<?, ?>)scatterChart);
        Boolean showValues = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showvalues");
        scatterChart.setShowValues(showValues);
        return scatterChart;
    }

    protected SpiderChartBuilder spiderChart(AdhocChart adhocChart) {
        SpiderChartBuilder spiderChart = Charts.spiderChart();
        this.spiderChart(adhocChart, spiderChart);
        return spiderChart;
    }

    protected TimeSeriesChartBuilder timeSeriesChart(AdhocChart adhocChart) {
        TimeSeriesChartBuilder timeSeriesChart = Charts.timeSeriesChart();
        this.timeSeriesChart(adhocChart, (AbstractTimeSeriesChartBuilder<?, ?>)timeSeriesChart);
        return timeSeriesChart;
    }

    protected XyAreaChartBuilder xyAreaChart(AdhocChart adhocChart) {
        XyAreaChartBuilder xyAreaChart = Charts.xyAreaChart();
        this.xyChart(adhocChart, (AbstractXyChartBuilder<?, ?>)xyAreaChart);
        return xyAreaChart;
    }

    protected XyBarChartBuilder xyBarChart(AdhocChart adhocChart) {
        XyBarChartBuilder xyBarChart = Charts.xyBarChart();
        this.xyChart(adhocChart, (AbstractXyChartBuilder<?, ?>)xyBarChart);
        Boolean showValues = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showvalues");
        xyBarChart.setShowValues(showValues);
        return xyBarChart;
    }

    protected XyLineChartBuilder xyLineChart(AdhocChart adhocChart) {
        XyLineChartBuilder xyLineChart = Charts.xyLineChart();
        this.xyChart(adhocChart, (AbstractXyChartBuilder<?, ?>)xyLineChart);
        Boolean showValues = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showvalues");
        xyLineChart.setShowValues(showValues);
        return xyLineChart;
    }

    protected XyStepChartBuilder xyStepChart(AdhocChart adhocChart) {
        XyStepChartBuilder xyStepChart = Charts.xyStepChart();
        this.xyChart(adhocChart, (AbstractXyChartBuilder<?, ?>)xyStepChart);
        Boolean showValues = (Boolean)adhocChart.getProperty("net.sf.dynamicreports.chart.showvalues");
        xyStepChart.setShowValues(showValues);
        return xyStepChart;
    }

    protected BubbleChartBuilder bubbleChart(AdhocChart adhocChart) {
        BubbleChartBuilder bubbleChart = Charts.bubbleChart();
        this.bubbleChart(adhocChart, bubbleChart);
        return bubbleChart;
    }

    protected Orientation orientation(AdhocOrientation adhocOrientation) {
        if (adhocOrientation == null) {
            return null;
        }
        switch (adhocOrientation) {
            case HORIZONTAL: {
                return Orientation.HORIZONTAL;
            }
            case VERTICAL: {
                return Orientation.VERTICAL;
            }
        }
        throw new AdhocException("Orientation " + adhocOrientation.name() + " not supported");
    }

    protected AxisFormatBuilder axisFormat(AdhocAxisFormat adhocAxisFormat) {
        if (adhocAxisFormat == null) {
            return null;
        }
        AxisFormatBuilder axisFormat = Charts.axisFormat();
        if (adhocAxisFormat.getLabel() != null) {
            axisFormat.setLabel(adhocAxisFormat.getLabel());
        }
        if (adhocAxisFormat.getLabelFont() != null) {
            axisFormat.setLabelFont(this.font(adhocAxisFormat.getLabelFont()));
        }
        axisFormat.setLabelColor(adhocAxisFormat.getLabelColor());
        return axisFormat;
    }

    protected void chartSerie(AdhocChartSerie adhocChartSerie, AbstractChartSerieBuilder<?, ?> chartSerie) {
        if (adhocChartSerie.getSeries() != null) {
            ColumnBuilder<?, ?> seriesColumn = this.columns.get(adhocChartSerie.getSeries());
            if (seriesColumn != null && seriesColumn instanceof ValueColumnBuilder) {
                chartSerie.setSeries((ValueColumnBuilder)seriesColumn);
            } else {
                chartSerie.setSeries(this.getFieldExpression(adhocChartSerie.getSeries()));
            }
        }
    }

    protected CategoryChartSerieBuilder categoryChartSerie(AdhocChartSerie adhocChartSerie) {
        String label;
        CategoryChartSerieBuilder categoryChartSerie;
        ColumnBuilder<?, ?> valueColumn = this.columns.get(adhocChartSerie.getYValue());
        if (valueColumn != null && valueColumn instanceof ValueColumnBuilder) {
            categoryChartSerie = Charts.serie((ValueColumnBuilder)((ValueColumnBuilder)valueColumn));
        } else {
            DRIExpression<?> field = this.getFieldExpression(adhocChartSerie.getYValue());
            categoryChartSerie = Charts.serie(field);
        }
        this.chartSerie(adhocChartSerie, (AbstractChartSerieBuilder<?, ?>)categoryChartSerie);
        if (adhocChartSerie.getLabel() != null) {
            categoryChartSerie.setLabel(adhocChartSerie.getLabel());
        } else if (valueColumn == null && StringUtils.isNotBlank((CharSequence)(label = this.getFieldLabel(adhocChartSerie.getYValue())))) {
            categoryChartSerie.setLabel(label);
        }
        return categoryChartSerie;
    }

    protected GroupedCategoryChartSerieBuilder groupedCategoryChartSerie(AdhocChartSerie adhocChartSerie) {
        String label;
        GroupedCategoryChartSerieBuilder groupedCategoryChartSerie;
        ColumnBuilder<?, ?> valueColumn = this.columns.get(adhocChartSerie.getYValue());
        if (valueColumn != null && valueColumn instanceof ValueColumnBuilder) {
            groupedCategoryChartSerie = Charts.groupedSerie((ValueColumnBuilder)((ValueColumnBuilder)valueColumn));
        } else {
            DRIExpression<?> field = this.getFieldExpression(adhocChartSerie.getYValue());
            groupedCategoryChartSerie = Charts.groupedSerie(field);
        }
        String seriesGroup = (String)adhocChartSerie.getProperty("net.sf.dynamicreports.chart.seriesgroup");
        if (seriesGroup != null) {
            ColumnBuilder<?, ?> groupColumn = this.columns.get(seriesGroup);
            if (groupColumn != null && groupColumn instanceof ValueColumnBuilder) {
                groupedCategoryChartSerie.setGroup((ValueColumnBuilder)groupColumn);
            } else {
                DRIExpression<?> field = this.getFieldExpression(seriesGroup);
                groupedCategoryChartSerie.setGroup(field);
            }
        }
        this.chartSerie(adhocChartSerie, (AbstractChartSerieBuilder<?, ?>)groupedCategoryChartSerie);
        if (adhocChartSerie.getLabel() != null) {
            groupedCategoryChartSerie.setLabel(adhocChartSerie.getLabel());
        } else if (valueColumn == null && StringUtils.isNotBlank((CharSequence)(label = this.getFieldLabel(adhocChartSerie.getYValue())))) {
            groupedCategoryChartSerie.setLabel(label);
        }
        return groupedCategoryChartSerie;
    }

    protected XyChartSerieBuilder xyChartSerie(AdhocChartSerie adhocChartSerie) {
        String label;
        DRIExpression<?> field;
        XyChartSerieBuilder xyChartSerie;
        ColumnBuilder<?, ?> valueColumn = this.columns.get(adhocChartSerie.getYValue());
        if (valueColumn != null && valueColumn instanceof ValueColumnBuilder) {
            xyChartSerie = Charts.xySerie((ValueColumnBuilder)((ValueColumnBuilder)valueColumn));
        } else {
            field = this.getFieldExpression(adhocChartSerie.getYValue());
            xyChartSerie = Charts.xySerie(field);
        }
        this.chartSerie(adhocChartSerie, (AbstractChartSerieBuilder<?, ?>)xyChartSerie);
        if (adhocChartSerie.getXValue() != null) {
            valueColumn = this.columns.get(adhocChartSerie.getXValue());
            if (valueColumn != null && valueColumn instanceof ValueColumnBuilder) {
                xyChartSerie.setXValue((ValueColumnBuilder)valueColumn);
            } else {
                field = this.getFieldExpression(adhocChartSerie.getXValue());
                xyChartSerie.setXValue(field);
            }
        }
        if (adhocChartSerie.getLabel() != null) {
            xyChartSerie.setLabel(adhocChartSerie.getLabel());
        } else if (valueColumn == null && StringUtils.isNotBlank((CharSequence)(label = this.getFieldLabel(adhocChartSerie.getYValue())))) {
            xyChartSerie.setLabel(label);
        }
        return xyChartSerie;
    }

    protected XyzChartSerieBuilder xyzChartSerie(AdhocChartSerie adhocChartSerie) {
        DRIExpression<?> field;
        ColumnBuilder<?, ?> valueColumn;
        XyzChartSerieBuilder xyzChartSerie = Charts.xyzSerie();
        this.chartSerie(adhocChartSerie, (AbstractChartSerieBuilder<?, ?>)xyzChartSerie);
        if (adhocChartSerie.getXValue() != null) {
            valueColumn = this.columns.get(adhocChartSerie.getXValue());
            if (valueColumn != null && valueColumn instanceof ValueColumnBuilder) {
                xyzChartSerie.setXValue((ValueColumnBuilder)valueColumn);
            } else {
                field = this.getFieldExpression(adhocChartSerie.getXValue());
                xyzChartSerie.setXValue(field);
            }
        }
        if (adhocChartSerie.getYValue() != null) {
            valueColumn = this.columns.get(adhocChartSerie.getYValue());
            if (valueColumn != null && valueColumn instanceof ValueColumnBuilder) {
                xyzChartSerie.setYValue((ValueColumnBuilder)valueColumn);
            } else {
                field = this.getFieldExpression(adhocChartSerie.getYValue());
                xyzChartSerie.setYValue(field);
            }
        }
        if (adhocChartSerie.getZValue() != null) {
            valueColumn = this.columns.get(adhocChartSerie.getZValue());
            if (valueColumn != null && valueColumn instanceof ValueColumnBuilder) {
                xyzChartSerie.setZValue((ValueColumnBuilder)valueColumn);
            } else {
                field = this.getFieldExpression(adhocChartSerie.getZValue());
                xyzChartSerie.setZValue(field);
            }
        }
        return xyzChartSerie;
    }
}

