/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sourceforge.jwbf.NioUnchecked;

public final class JWBF {
    public static final String VERSION_FALLBACK_VALUE = "Version unknown";
    private static boolean errorInfo = true;
    static Map<String, String> cache = null;
    private static NioUnchecked nio = new NioUnchecked();
    static final String DEVEL_NAME = "jwbf-generic";
    static final String DEVEL_VERSION = "DEVEL";
    static final char SEPARATOR_CHAR = '/';
    private static final String JAR_FILE_INDEX = "jar:file:";
    private static final String FILE_INDEX = "file:";
    private static final DirectoryStream.Filter<Path> DIRECTORY_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path entry) throws IOException {
            return Files.isDirectory(entry, new LinkOption[0]);
        }
    };

    private JWBF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> lazyVersion() {
        Class<JWBF> clazz = JWBF.class;
        String packageName = JWBF.packageNameOf(clazz);
        URL url = JWBF.urlOf(clazz, packageName);
        if (cache != null) return cache;
        Class<JWBF> clazz2 = JWBF.class;
        synchronized (JWBF.class) {
            if (cache != null) return cache;
            cache = JWBF.init(packageName, JWBF.toUri(url));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return cache;
        }
    }

    static Map<String, String> init(String packageName, URI uri) {
        String lowerCaseUrl = JWBF.urlExtract(uri).toLowerCase();
        if (lowerCaseUrl.startsWith(JAR_FILE_INDEX)) {
            return JWBF.jarVersionDetails(packageName, uri);
        }
        if (lowerCaseUrl.startsWith(FILE_INDEX) || JWBF.exists(uri)) {
            return JWBF.fileSystemVersionDetails(packageName, uri);
        }
        System.err.println("W: unknown uri: " + uri);
        return new HashMap<String, String>();
    }

    static URI stripJarSuffix(URI uri) {
        try {
            URLConnection urlConnection = JWBF.toUrl(uri).openConnection();
            if (urlConnection instanceof JarURLConnection) {
                JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
                return JWBF.toUri(jarURLConnection.getJarFileURL());
            }
            return uri;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static boolean exists(URI uri) {
        try {
            return Files.exists(Paths.get(uri), new LinkOption[0]);
        }
        catch (FileSystemNotFoundException e) {
            return false;
        }
    }

    private static URL urlOf(Class<?> clazz, String packageName) {
        return clazz.getClassLoader().getResource(packageName);
    }

    private static String packageNameOf(Class<?> clazz) {
        return clazz.getPackage().getName().replace('.', '/');
    }

    private static Map<String, String> fileSystemVersionDetails(String packageName, URI url) {
        Path root = JWBF.uriToPath(url);
        if (Files.exists(root, new LinkOption[0])) {
            List<Path> dirs = nio.listFiles(root, DIRECTORY_FILTER);
            List<ContainerEntry> entries = JWBF.filesToEntries(dirs, packageName);
            return JWBF.makeVersionMap(packageName, entries, DEVEL_VERSION, DEVEL_NAME);
        }
        return new HashMap<String, String>();
    }

    static Map<String, String> jarVersionDetails(String packageName, URI uri) {
        List<ContainerEntry> elements = JWBF.jarToEntries(uri);
        String implementationTitle = JWBF.getImplementationTitle();
        String implementationVersion = JWBF.getImplementationVersion();
        return JWBF.makeVersionMap(packageName, elements, implementationVersion, implementationTitle);
    }

    private static String urlExtract(URI uri) {
        return uri.toString();
    }

    static Map<String, String> makeVersionMap(String packageName, List<ContainerEntry> elements, String implementationVersion, String implementationTitle) {
        HashMap<String, String> parts = new HashMap<String, String>();
        for (ContainerEntry element : elements) {
            String elementName = element.getName();
            boolean isDirectory = element.isDirectory();
            int slashCount = JWBF.countSlashes(JWBF.removeTrailingSlash(elementName));
            if (!isDirectory || slashCount != 4 || !elementName.contains(packageName)) continue;
            String wikiSystemName = elementName.split("/")[3];
            String artifactId = implementationTitle + "-" + wikiSystemName;
            parts.put(artifactId, implementationVersion);
        }
        return parts;
    }

    static String removeTrailingSlash(String str) {
        return str.replaceFirst("([^/])/$", "$1");
    }

    static int countSlashes(String str) {
        String s = str.replaceAll("[/]+", "");
        return str.length() - s.length();
    }

    private static List<ContainerEntry> filesToEntries(Iterable<Path> dirs, String packageName) {
        ArrayList<ContainerEntry> result = new ArrayList<ContainerEntry>();
        if (dirs != null) {
            for (Path f : dirs) {
                if (!Files.isDirectory(f, new LinkOption[0])) continue;
                String name = JWBF.makeFileName(f, packageName);
                if (!name.isEmpty()) {
                    result.add(new ContainerEntry(name, true));
                }
                result.addAll(JWBF.filesToEntries(nio.listFiles(f, DIRECTORY_FILTER), packageName));
            }
        }
        return result;
    }

    private static String makeFileName(Path file, String packageName) {
        String path = file.toAbsolutePath().toUri().toString();
        int indexOfPackage = path.indexOf(packageName);
        if (indexOfPackage == -1) {
            return "";
        }
        return path.substring(indexOfPackage);
    }

    static List<ContainerEntry> jarToEntries(URI jarFileName) {
        ArrayList<ContainerEntry> result = new ArrayList<ContainerEntry>();
        URI jarSimpleName = JWBF.stripJarSuffix(jarFileName);
        if (jarSimpleName != null) {
            try (JarFile jar = new JarFile(new File(jarSimpleName));){
                Enumeration<JarEntry> je = jar.entries();
                while (je.hasMoreElements()) {
                    JarEntry jarEntry = je.nextElement();
                    boolean directory = jarEntry.isDirectory();
                    result.add(new ContainerEntry(jarEntry.getName(), directory));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String getVersion(Class<?> clazz) {
        return JWBF.getPartInfo(JWBF.lazyVersion(), clazz, (String)VERSION_FALLBACK_VALUE).version;
    }

    public static String getPartId(Class<?> clazz) {
        return JWBF.getPartInfo(JWBF.lazyVersion(), clazz, (String)new StringBuilder().append((String)"No Module for ").append((String)clazz.getName()).toString()).id;
    }

    private static PartContainer getPartInfo(Map<String, String> versionDetails, Class<?> clazz, String fallbackValue) {
        String[] packageParts = clazz.getPackage().getName().split("\\.");
        if (packageParts.length > 3) {
            String classContainer = packageParts[3];
            for (Map.Entry<String, String> entry : versionDetails.entrySet()) {
                if (!entry.getKey().contains(classContainer)) continue;
                return new PartContainer(entry.getKey(), entry.getValue());
            }
        }
        return new PartContainer(fallbackValue, fallbackValue);
    }

    public static void printVersion() {
        System.out.println("JWBF.");
        System.out.println(JWBF.formatVersionText());
    }

    static String formatVersionText() {
        ArrayList<String> lines = new ArrayList<String>();
        for (Map.Entry<String, String> entry : JWBF.getVersions().entrySet()) {
            lines.add(entry.getKey() + " => " + entry.getValue());
        }
        Collections.sort(lines);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        JWBF.printVersion();
    }

    public static Map<String, String> getVersions() {
        return Collections.unmodifiableMap(JWBF.lazyVersion());
    }

    private static String getImplementationVersion() {
        return JWBF.secondIfNull(JWBF.objPackage().getImplementationVersion(), DEVEL_VERSION);
    }

    private static String getImplementationTitle() {
        return JWBF.secondIfNull(JWBF.objPackage().getImplementationTitle(), DEVEL_NAME);
    }

    private static Package objPackage() {
        return JWBF.class.getPackage();
    }

    static String secondIfNull(String str, String orStr) {
        if (str == null) {
            return JWBF.logAndReturn(orStr);
        }
        return str;
    }

    private static String logAndReturn(String fallback) {
        if (errorInfo) {
            errorInfo = false;
            System.err.println("E: no MANIFEST.MF found, please create it.");
        }
        return fallback;
    }

    public static URL newURLWithoutHandler(String url) {
        try {
            return new URL(null, url, new UnsupportedHandler());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(url, e);
        }
    }

    public static URL newURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("\"" + url + "\"", e);
        }
    }

    static Path uriToPath(URI uri) {
        return Paths.get(uri);
    }

    public static File urlToFile(URL url) {
        String urlString = url.toString();
        return new File(JWBF.toUri(urlString));
    }

    public static URI toUri(String urlString) {
        try {
            return new URI(urlString);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(urlString, e);
        }
    }

    static URI toUri(URL url) {
        return JWBF.toUri(url.toString());
    }

    static URL toUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(uri.toString(), e);
        }
    }

    private static class UnsupportedHandler
    extends URLStreamHandler {
        private UnsupportedHandler() {
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class ContainerEntry {
        private final String name;
        private final boolean directory;

        public ContainerEntry(String name, boolean directory) {
            this.name = name;
            this.directory = directory;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public String toString() {
            return Objects.toString(this.name) + " " + this.directory;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.directory);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof ContainerEntry) {
                ContainerEntry that = (ContainerEntry)obj;
                return Objects.equals(this.name, that.name) && Objects.equals(this.directory, that.directory);
            }
            return false;
        }
    }

    private static class PartContainer {
        final String id;
        final String version;

        public PartContainer(String id, String version) {
            this.id = id;
            this.version = version;
        }
    }
}

