/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.core.actions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.Collection;
import net.sourceforge.jwbf.core.actions.HttpActionClient;
import net.sourceforge.jwbf.core.actions.ResponseHandler;
import net.sourceforge.jwbf.core.actions.util.HttpAction;

public class ContentProcessableBuilder {
    private ImmutableList<HttpAction> actions;
    private final HttpActionClient hac;

    public ContentProcessableBuilder(HttpActionClient hac) {
        this.hac = hac;
    }

    public <T> ResponseHandler<T> build() {
        ArrayDeque actionQueue = Queues.newArrayDeque(this.actions);
        return new ResponseHandler<T>(actionQueue){

            @Override
            public ImmutableList<T> get() {
                ContentProcessableBuilder.this.hac.performAction(this);
                return ImmutableList.copyOf((Collection)this.responeses);
            }
        };
    }

    public static ContentProcessableBuilder create(HttpActionClient hac) {
        return new ContentProcessableBuilder(hac);
    }

    public ContentProcessableBuilder withActions(HttpAction ... actions) {
        this.actions = ImmutableList.copyOf((Object[])actions);
        return this;
    }
}

