/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.core.actions;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.nio.charset.Charset;
import java.util.Objects;
import net.sourceforge.jwbf.core.actions.HttpBase;
import net.sourceforge.jwbf.core.actions.ParamJoiner;
import net.sourceforge.jwbf.core.actions.util.HttpAction;

public class Get
extends HttpBase
implements HttpAction {
    private final Supplier<String> req;
    private final Charset charset;

    Get(String req, String charset) {
        this((Supplier<String>)Suppliers.ofInstance((Object)req), charset);
    }

    Get(Supplier<String> req, String charset) {
        this(req, Charset.forName(charset), (Optional<ParamJoiner>)Optional.absent());
    }

    Get(Supplier<String> req, Charset charset, Optional<ParamJoiner> paramJoiner) {
        super(paramJoiner);
        this.req = req;
        this.charset = charset;
    }

    Get(String url) {
        this((Supplier<String>)Suppliers.ofInstance((Object)url), Charsets.UTF_8, (Optional<ParamJoiner>)Optional.absent());
    }

    Get(ParamJoiner joiner) {
        this(joiner, Charsets.UTF_8, (Optional<ParamJoiner>)Optional.of((Object)joiner));
    }

    @Override
    public String getRequest() {
        return this.getRequestAndFixAllSuppliers();
    }

    @Override
    public String getCharset() {
        return this.charset.displayName();
    }

    public String toString() {
        return this.getRequestAndFixAllSuppliers() + " " + this.getCharset();
    }

    public int hashCode() {
        return Objects.hash(this.getRequest(), this.getCharset());
    }

    private String getRequestAndFixAllSuppliers() {
        return (String)this.req.get();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Get) {
            Get that = (Get)obj;
            return Objects.equals(this.getRequestAndFixAllSuppliers(), that.getRequestAndFixAllSuppliers()) && Objects.equals(this.getCharset(), that.getCharset());
        }
        return false;
    }
}

