/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.core.actions;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.RateLimiter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.sourceforge.jwbf.JWBF;
import net.sourceforge.jwbf.core.Transform;
import net.sourceforge.jwbf.core.actions.ActionHandler;
import net.sourceforge.jwbf.core.actions.ContentProcessable;
import net.sourceforge.jwbf.core.actions.Get;
import net.sourceforge.jwbf.core.actions.Post;
import net.sourceforge.jwbf.core.actions.ReturningTextProcessor;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.internal.Checked;
import net.sourceforge.jwbf.core.internal.NonnullFunction;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClientVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpActionClient {
    private static final Logger log = LoggerFactory.getLogger(HttpActionClient.class);
    private final HttpClient client;
    private final String path;
    private final HttpHost host;
    private final Optional<RateLimiter> rateLimiter;
    private final URL url;

    public HttpActionClient(URL url) {
        this(HttpClientBuilder.create(), url);
    }

    public HttpActionClient(HttpClientBuilder clientBuilder, URL url) {
        this.url = url;
        this.path = this.pathOf(url);
        this.host = this.newHost(url);
        this.rateLimiter = Optional.absent();
        this.client = clientBuilder.build();
    }

    public HttpActionClient(Builder builder) {
        this.url = Checked.nonNull(builder.url, "url");
        this.host = this.newHost(builder.url);
        this.path = this.pathOf(builder.url);
        this.rateLimiter = builder.requestsPerSecond > 0.0 ? Optional.of((Object)RateLimiter.create((double)builder.requestsPerSecond)) : Optional.absent();
        this.client = builder.client;
    }

    private HttpHost newHost(URL url) {
        return new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
    }

    private String pathOf(URL url) {
        String urlPath = url.getPath();
        if (urlPath.length() > 1) {
            return urlPath.substring(0, urlPath.lastIndexOf("/"));
        }
        return "";
    }

    @Nonnull
    public synchronized String performAction(ContentProcessable contentProcessable) {
        String out = "";
        while (contentProcessable.hasMoreMessages()) {
            HttpAction httpAction = contentProcessable.getNextMessage();
            ContentProcessable answerParser = contentProcessable;
            out = this.processAction(httpAction, answerParser);
        }
        return out;
    }

    @Beta
    public synchronized void performAction(ActionHandler actionHandler) {
        while (actionHandler.hasMoreActions()) {
            HttpAction httpAction = actionHandler.popAction();
            this.processAction(httpAction, new ResponseHandler(actionHandler));
        }
    }

    @VisibleForTesting
    protected String processAction(HttpAction httpAction, ReturningTextProcessor answerParser) {
        String requestString = this.makeRequestString(httpAction);
        log.debug(requestString);
        URI uri = JWBF.toUri(this.host.toURI() + requestString);
        if (httpAction instanceof Get) {
            HttpGet httpRequest = new HttpGet(uri);
            return this.get((HttpRequestBase)httpRequest, answerParser, httpAction);
        }
        if (httpAction instanceof Post) {
            HttpPost httpRequest = new HttpPost(uri);
            return this.post((HttpRequestBase)httpRequest, answerParser, httpAction);
        }
        throw new IllegalArgumentException("httpAction should be GET or POST");
    }

    private String makeRequestString(HttpAction httpAction) {
        String requestString = this.path.length() > 1 ? this.path + httpAction.getRequest() : httpAction.getRequest();
        return requestString;
    }

    String post(Post post) {
        return this.post((HttpRequestBase)new HttpPost(post.getRequest()), null, post);
    }

    @VisibleForTesting
    String post(HttpRequestBase requestBase, ReturningTextProcessor contentProcessable, HttpAction ha) {
        Post post = (Post)ha;
        Charset charset = Charset.forName(post.getCharset());
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        ImmutableMultimap<String, Object> postParams = post.getParams();
        for (Map.Entry entry : postParams.asMap().entrySet()) {
            this.applyToEntityBuilder((String)entry.getKey(), (Collection)entry.getValue(), charset, entityBuilder);
        }
        ((HttpPost)requestBase).setEntity(entityBuilder.build());
        return this.executeAndProcess(requestBase, contentProcessable, ha);
    }

    @VisibleForTesting
    void applyToEntityBuilder(String key, Collection<Object> values, Charset charset, MultipartEntityBuilder entityBuilder) {
        for (Object content : Iterables.filter(values, (Predicate)Predicates.notNull())) {
            if (content instanceof String) {
                String text = (String)content;
                entityBuilder.addTextBody(key, text, ContentType.create((String)"*/*", (Charset)charset));
                continue;
            }
            if (content instanceof File) {
                File file = (File)content;
                entityBuilder.addBinaryBody(key, file);
                continue;
            }
            String canonicalName = content.getClass().getCanonicalName();
            throw new UnsupportedOperationException("No Handler found for " + canonicalName + ". Only String or File is accepted, " + "because http parameters knows no other types.");
        }
    }

    @Nonnull
    public String get(Get get) {
        return this.get((HttpRequestBase)new HttpGet(get.getRequest()), null, get);
    }

    @Nonnull
    private String get(HttpRequestBase requestBase, ReturningTextProcessor cp, HttpAction ha) {
        return this.executeAndProcess(requestBase, cp, ha);
    }

    @VisibleForTesting
    protected void consume(HttpResponse res) {
        try {
            res.getEntity().getContent().close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeAndProcess(HttpRequestBase requestBase, ReturningTextProcessor cp, HttpAction ha) {
        log.debug("message {} is: \n\t hostPath : {} \n\t queryPath: {}", this.debug((HttpUriRequest)requestBase, ha, cp));
        HttpResponse res = this.execute(requestBase);
        String out = this.writeToString(ha, res);
        try {
            if (cp != null) {
                String string = cp.processReturningText(out, ha);
                return string;
            }
            String string = out;
            return string;
        }
        finally {
            this.consume(res);
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    @VisibleForTesting
    String writeToString(HttpAction ha, HttpResponse res) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String toString(BufferedReader br) throws IOException {
        return Joiner.on((String)"\n").join((Iterable)CharStreams.readLines((Readable)br)) + "\n";
    }

    @VisibleForTesting
    HttpResponse execute(HttpRequestBase requestBase) {
        HttpResponse res;
        try {
            if (this.rateLimiter.isPresent()) {
                ((RateLimiter)this.rateLimiter.get()).acquire();
            }
            res = this.client.execute((HttpUriRequest)requestBase);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        StatusLine statusLine = res.getStatusLine();
        int code = statusLine.getStatusCode();
        if (code >= 400) {
            this.consume(res);
            throw new IllegalStateException("invalid status: " + statusLine + "; for " + requestBase.getURI());
        }
        return res;
    }

    @VisibleForTesting
    Object[] debug(HttpUriRequest request, HttpAction ha, ReturningTextProcessor cp) {
        if (cp != null) {
            String path = this.debugRequestPathOf(request);
            String type = this.debugTypeOf(ha, cp);
            return new String[]{type, path, ha.getRequest()};
        }
        return new String[0];
    }

    private String debugRequestPathOf(HttpUriRequest request) {
        String requestString = request.getURI().toString();
        int lastSlash = requestString.lastIndexOf("/");
        requestString = requestString.substring(0, lastSlash);
        return requestString;
    }

    private String debugTypeOf(HttpAction ha, ReturningTextProcessor cp) {
        String className = cp.getClass().getName();
        String suffix = className + ")";
        if (ha instanceof Post) {
            return "(POST " + suffix;
        }
        if (ha instanceof Get) {
            return "(GET " + suffix;
        }
        throw new IllegalStateException("unknown type: " + ha.getClass().getCanonicalName());
    }

    String getHostUrl() {
        return this.host.toURI();
    }

    public String getUrl() {
        return this.url.toExternalForm();
    }

    private static String trimAndRemoveWhitespace(String in) {
        String changed = in.trim().replaceAll("[\r\n()]+", "");
        return HttpActionClient.logIfDifferent(in, changed, "\"{}\" was changed to \"{}\"; because of User-Agent comment rules");
    }

    private static String trimAndReplaceWhitespaceLogged(String in) {
        String changed = HttpActionClient.trimAndReplaceWhitespace(in);
        return HttpActionClient.logIfDifferent(in, changed, "\"{}\" was changed to \"{}\"; because of User-Agent name/version rules");
    }

    private static String trimAndReplaceWhitespace(String in) {
        return HttpActionClient.emptyToUnknown(in.trim().replaceAll("[\r\n/]+", "").replaceAll("[ ]+", "_"));
    }

    private static String toISO8859(String toEncode) {
        byte[] array = StandardCharsets.ISO_8859_1.encode(toEncode).array();
        String encoded = new String(array, StandardCharsets.UTF_8);
        return HttpActionClient.logIfDifferent(toEncode, encoded, "\"{}\" was encoded to \"{}\"; because only iso8859 is supported");
    }

    private static String emptyToUnknown(String changed) {
        if (changed.isEmpty()) {
            return "Unknown";
        }
        return changed;
    }

    private static String logIfDifferent(String original, String changed, String msg) {
        if (!changed.equals(original)) {
            String originalWithVisibleWhitespace = original.replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r").replaceAll("\t", "\\\\t");
            log.warn(msg, (Object)originalWithVisibleWhitespace, (Object)changed);
        }
        return changed;
    }

    public static HttpActionClient of(String url) {
        return HttpActionClient.builder().withUrl(url).build();
    }

    public static HttpActionClient of(URL url) {
        return HttpActionClient.builder().withUrl(url).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    static class UserAgentPart {
        final String name;
        final String version;
        final String comment;

        UserAgentPart(String name, String version, String comment) {
            this.name = Checked.nonNull(name, "name");
            this.version = Checked.nonNull(version, "version");
            this.comment = Checked.nonNull(comment, "comment");
        }
    }

    private static class ResponseHandler
    implements ReturningTextProcessor {
        private final ActionHandler actionHandler;

        public ResponseHandler(ActionHandler actionHandler) {
            this.actionHandler = actionHandler;
        }

        @Override
        public String processReturningText(String s, HttpAction action) {
            this.actionHandler.processReturningText(s, action);
            return "";
        }
    }

    public static class Builder {
        private static final Function<UserAgentPart, String> TO_STRING = new NonnullFunction<UserAgentPart, String>(){

            @Override
            @Nonnull
            public String applyNonnull(@Nonnull UserAgentPart input) {
                String comment = !Strings.isNullOrEmpty((String)input.comment) ? " (" + input.comment + ")" : "";
                return input.name + "/" + input.version + comment;
            }
        };
        private double requestsPerSecond = -1.0;
        private HttpClient client;
        private URL url;
        @VisibleForTesting
        List<UserAgentPart> userAgentParts = Lists.newArrayList();

        public Builder withUserAgent(String userAgentName, String userAgentVersion, String userAgentComment) {
            String nonNullUserAgentName = Checked.nonNull(userAgentName, "User-Agent name");
            String nonNullUserAgentVersion = Checked.nonNull(userAgentVersion, "User-Agent version");
            String nonNullUserAgentComment = Checked.nonNull(userAgentComment, "User-Agent comment");
            String encodedName = HttpActionClient.toISO8859(HttpActionClient.trimAndReplaceWhitespaceLogged(nonNullUserAgentName));
            String encodedVersion = HttpActionClient.toISO8859(HttpActionClient.trimAndReplaceWhitespaceLogged(nonNullUserAgentVersion));
            String encodedComment = HttpActionClient.toISO8859(HttpActionClient.trimAndRemoveWhitespace(nonNullUserAgentComment));
            this.userAgentParts.add(new UserAgentPart(encodedName, encodedVersion, encodedComment));
            return this;
        }

        public Builder withUserAgent(String userAgentName, String userAgentVersion) {
            return this.withUserAgent(userAgentName, userAgentVersion, "");
        }

        public HttpActionClient build() {
            if (this.client == null) {
                if (this.userAgentParts.isEmpty()) {
                    this.withUserAgent("Unknown", "Unknown");
                }
                this.withUserAgent("JWBF", HttpActionClient.trimAndReplaceWhitespace(this.getJwbfVersion()));
                HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
                httpClientBuilder.setUserAgent(Builder.makeUserAgentString(this.userAgentParts));
                this.withClient((HttpClient)httpClientBuilder.build());
            } else {
                log.warn("a User-Agent must be set in your client");
            }
            return new HttpActionClient(this);
        }

        @VisibleForTesting
        String getJwbfVersion() {
            return JWBF.getVersion(HttpActionClient.class);
        }

        private static String makeUserAgentString(List<UserAgentPart> userAgentParts) {
            String userAgent = Joiner.on((String)" ").join(Transform.the(userAgentParts, TO_STRING)) + " " + HttpClientVersion.DEFAULT_USER_AGENT;
            return userAgent.trim();
        }

        public Builder withClient(HttpClient client) {
            this.client = client;
            return this;
        }

        public Builder withUrl(URL url) {
            this.url = url;
            return this;
        }

        public Builder withUrl(String url) {
            return this.withUrl(JWBF.newURL(url));
        }

        public Builder withRequestsPerUnit(double requestsPer, TimeUnit unit) {
            long seconds = TimeUnit.SECONDS.convert(1L, unit);
            this.requestsPerSecond = requestsPer / (double)seconds;
            return this;
        }
    }
}

