/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.core.actions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.sourceforge.jwbf.core.actions.RequestBuilder;
import net.sourceforge.jwbf.core.internal.NonnullFunction;

class ParamJoiner
implements Supplier<String> {
    private static final Function<Map.Entry<String, Supplier<String>>, String> TO_KEY_VALUE_PAIR = new NonnullFunction<Map.Entry<String, Supplier<String>>, String>(){

        @Override
        @Nonnull
        public String applyNonnull(@Nonnull Map.Entry<String, Supplier<String>> input) {
            return input.getKey() + "=" + (String)input.getValue().get();
        }
    };
    private final String path;
    private final ImmutableMultimap.Builder<String, Supplier<String>> params;
    private final ImmutableMultimap.Builder<String, Supplier<Object>> postParams;

    ParamJoiner(String path, ImmutableMultimap.Builder<String, Supplier<String>> params, ImmutableMultimap.Builder<String, Supplier<Object>> postParams) {
        this.path = path;
        this.params = params;
        this.postParams = postParams;
    }

    RequestBuilder toBuilder() {
        return RequestBuilder.of(this.path).params(this.params).postParams(this.postParams);
    }

    public String get() {
        ImmutableMultimap build = this.params.build();
        if (!build.isEmpty()) {
            ImmutableList values = FluentIterable.from((Iterable)build.entries()).transform(TO_KEY_VALUE_PAIR).toSortedList((Comparator)Ordering.natural());
            return this.path + "?" + Joiner.on((String)"&").join((Iterable)values);
        }
        return this.path;
    }

    ImmutableMultimap.Builder<String, Supplier<Object>> postParams() {
        return this.postParams;
    }
}

