/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.core.actions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Objects;
import net.sourceforge.jwbf.core.internal.Checked;

public final class ParamTuple<T> {
    final String key;
    final Supplier<T> valueSupplier;

    public ParamTuple(String key, T value) {
        this(key, Suppliers.ofInstance(Checked.nonNull(value, "value")));
    }

    public ParamTuple(String key, Supplier<T> valueSupplier) {
        this.key = Checked.nonNull(key, "key");
        this.valueSupplier = Checked.nonNull(valueSupplier, "value");
    }

    public boolean equals(Object o) {
        if (o instanceof ParamTuple) {
            ParamTuple that = (ParamTuple)o;
            return Objects.equals(that.key, this.key) && Objects.equals(that.valueSupplier, this.valueSupplier);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.valueSupplier);
    }

    public String toString() {
        return "('" + this.key + "', '" + this.valueSupplier.get() + "')";
    }

    @VisibleForTesting
    public String key() {
        return this.key;
    }

    @VisibleForTesting
    public String value() {
        return (String)this.valueSupplier.get();
    }
}

