/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.core.actions;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.meta.When;
import net.sourceforge.jwbf.core.actions.HttpBase;
import net.sourceforge.jwbf.core.actions.ParamJoiner;
import net.sourceforge.jwbf.core.actions.util.HttpAction;
import net.sourceforge.jwbf.core.internal.NonnullFunction;

public class Post
extends HttpBase
implements HttpAction {
    private static Function<Supplier<Object>, Object> flattenSuppliers = new NonnullFunction<Supplier<Object>, Object>(){

        @Override
        @Nonnull
        public Object applyNonnull(@Nonnull Supplier<Object> input) {
            return input.get();
        }
    };
    private final Supplier<String> req;
    private final ImmutableMultimap.Builder<String, Supplier<Object>> params;
    private final Charset charset;

    @Deprecated
    Post(String req, String charset) {
        this((Supplier<String>)Suppliers.ofInstance((Object)req), charset);
    }

    @Deprecated
    Post(Supplier<String> req, String charset) {
        this(req, Charset.forName(charset), (Optional<ParamJoiner>)Optional.absent());
    }

    private Post(Supplier<String> req, Charset charset, Optional<ParamJoiner> joiner, ImmutableMultimap.Builder<String, Supplier<Object>> params) {
        super(joiner);
        this.req = req;
        this.charset = charset;
        this.params = params;
    }

    Post(Supplier<String> req, Charset charset, Optional<ParamJoiner> joiner) {
        super(joiner);
        this.req = req;
        this.charset = charset;
        this.params = joiner.isPresent() ? ((ParamJoiner)joiner.get()).postParams() : ImmutableMultimap.builder();
    }

    private Post(Supplier<String> url, Charset charset) {
        this(url, charset, (Optional<ParamJoiner>)Optional.absent());
    }

    Post(String url) {
        this((Supplier<String>)Suppliers.ofInstance((Object)url));
    }

    private Post(Supplier<String> url) {
        this(url, Charsets.UTF_8);
    }

    @Deprecated
    public void addParam(String key, Object value) {
        this.postParam(key, value);
    }

    @Deprecated
    @CheckReturnValue(when=When.NEVER)
    public Post postParam(String key, Object value) {
        this.params.put((Object)key, (Object)Suppliers.ofInstance((Object)value));
        return new Post(this.req, this.charset, (Optional<ParamJoiner>)Optional.absent(), this.params);
    }

    public ImmutableMultimap<String, Object> getParams() {
        return ImmutableMultimap.copyOf((Multimap)Multimaps.transformValues((Multimap)this.params.build(), flattenSuppliers));
    }

    @Override
    public String getRequest() {
        return (String)this.req.get();
    }

    @Override
    public String getCharset() {
        return this.charset.displayName();
    }

    public int hashCode() {
        return Objects.hash(this.getRequest(), this.getCharset(), this.getParams());
    }

    public String toString() {
        return this.getRequest() + " " + this.getCharset() + " " + this.getParams();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Post) {
            Post that = (Post)obj;
            return Objects.equals(this.getRequest(), that.getRequest()) && Objects.equals(this.getCharset(), that.getCharset()) && Objects.equals(this.getParams(), that.getParams());
        }
        return false;
    }
}

