/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.core.actions;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.Serializable;
import java.util.Locale;
import net.sourceforge.jwbf.core.actions.Get;
import net.sourceforge.jwbf.core.actions.ParamJoiner;
import net.sourceforge.jwbf.core.actions.ParamTuple;
import net.sourceforge.jwbf.core.actions.Post;
import net.sourceforge.jwbf.core.internal.Checked;

public class RequestBuilder {
    private final ImmutableMultimap.Builder<String, Supplier<String>> params = ImmutableMultimap.builder();
    private final ImmutableMultimap.Builder<String, Supplier<Object>> postParams = ImmutableMultimap.builder();
    private final String path;

    public RequestBuilder(String path) {
        this.path = path;
    }

    public RequestBuilder param(String key, int value) {
        this.param(key, value + "");
        return this;
    }

    public RequestBuilder param(String key, Supplier<String> stringSupplier) {
        return this.applyKeyValueTo(key, stringSupplier, this.params);
    }

    public RequestBuilder param(ParamTuple<String> paramTuple) {
        return this.param(paramTuple.key, paramTuple.valueSupplier);
    }

    private <T> RequestBuilder applyKeyValueTo(String key, Supplier<?> stringSupplier, ImmutableMultimap.Builder<String, Supplier<T>> toParams) {
        if (!Strings.isNullOrEmpty((String)key)) {
            Checked.nonNull(stringSupplier, "stringSupplier");
            HashCodeEqualsMemoizingSupplier memoize = new HashCodeEqualsMemoizingSupplier(stringSupplier);
            if (!toParams.build().containsEntry((Object)key, memoize)) {
                toParams.put((Object)key, memoize);
            }
        }
        return this;
    }

    RequestBuilder postParams(ImmutableMultimap.Builder<String, Supplier<Object>> all) {
        this.postParams.putAll((Multimap)all.build());
        return this;
    }

    RequestBuilder params(ImmutableMultimap.Builder<String, Supplier<String>> params) {
        this.params.putAll((Multimap)params.build());
        return this;
    }

    private RequestBuilder postParam(String key, Object value) {
        return this.applyKeyValueTo(key, Suppliers.ofInstance((Object)value), this.postParams);
    }

    public RequestBuilder postParam(String key, String value) {
        return this.postParam(key, (Object)value);
    }

    public RequestBuilder postParam(String key, int value) {
        return this.postParam(key, value + "");
    }

    public RequestBuilder postParam(String key, double value, Locale locale, String format) {
        return this.postParam(key, String.format(locale, format, value));
    }

    public RequestBuilder postParam(String key, File value) {
        return this.postParam(key, (Object)value);
    }

    public RequestBuilder postParam(ParamTuple<?> paramTuple) {
        Supplier val = paramTuple.valueSupplier;
        return this.applyKeyValueTo(paramTuple.key, val, this.postParams);
    }

    public RequestBuilder param(String key, boolean value) {
        return this.param(key, Boolean.toString(value));
    }

    public RequestBuilder param(String key, String value) {
        if (!Strings.isNullOrEmpty((String)key)) {
            if (Strings.isNullOrEmpty((String)value)) {
                this.param(key, (Supplier<String>)Suppliers.ofInstance((Object)"None"));
            } else {
                this.param(key, (Supplier<String>)Suppliers.ofInstance((Object)value));
            }
        }
        return this;
    }

    public Post buildPost() {
        return new Post(this.lazy(), Charsets.UTF_8, (Optional<ParamJoiner>)Optional.of((Object)this.lazy()));
    }

    public Get buildGet() {
        return new Get(this.lazy());
    }

    ParamJoiner lazy() {
        return new ParamJoiner(this.path, this.params, this.postParams);
    }

    public String build() {
        return this.lazy().get();
    }

    public static RequestBuilder of(String path) {
        return new RequestBuilder(path);
    }

    static class HashCodeEqualsMemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        volatile transient boolean initialized;
        transient T value;
        private static final long serialVersionUID = 0L;

        HashCodeEqualsMemoizingSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            if (!this.initialized) {
                HashCodeEqualsMemoizingSupplier hashCodeEqualsMemoizingSupplier = this;
                synchronized (hashCodeEqualsMemoizingSupplier) {
                    if (!this.initialized) {
                        Object t = this.delegate.get();
                        this.value = t;
                        this.initialized = true;
                        return (T)t;
                    }
                }
            }
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof HashCodeEqualsMemoizingSupplier) {
                return this.delegate.equals(((HashCodeEqualsMemoizingSupplier)obj).delegate);
            }
            if (obj == null) {
                throw new IllegalStateException("do not compare with null");
            }
            String canonicalName = obj.getClass().getCanonicalName();
            throw new IllegalStateException(canonicalName);
        }
    }
}

