/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.core.bots;

import java.net.URL;
import net.sourceforge.jwbf.core.actions.ContentProcessable;
import net.sourceforge.jwbf.core.actions.GetPage;
import net.sourceforge.jwbf.core.actions.HttpActionClient;
import net.sourceforge.jwbf.core.internal.Checked;

public class HttpBot {
    private final HttpActionClient actionClient;

    public HttpBot(HttpActionClient actionClient) {
        this.actionClient = Checked.nonNull(actionClient, "actionClient");
    }

    public HttpBot(String url) {
        this(HttpBot.clientBuilder().withUrl(url).build());
    }

    public HttpBot(URL url) {
        this(HttpBot.clientBuilder().withUrl(url).build());
    }

    private static HttpActionClient.Builder clientBuilder() {
        return HttpActionClient.builder();
    }

    public synchronized String performAction(ContentProcessable a) {
        return this.actionClient.performAction(a);
    }

    public static String getPage(HttpActionClient client) {
        GetPage gp = new GetPage(client.getUrl());
        new HttpBot(client).performAction(gp);
        return gp.getText();
    }

    public static String getPage(String url) {
        return HttpBot.getPage(HttpActionClient.of(url));
    }
}

