/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.core.bots.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.PrintStream;
import java.io.PrintWriter;
import net.sourceforge.jwbf.JWBF;

public class JwbfException
extends RuntimeException {
    private static final long serialVersionUID = -2456904376052276104L;

    public JwbfException(String message) {
        super(message);
    }

    public JwbfException(Throwable t) {
        super(t);
    }

    public JwbfException(String message, Throwable t) {
        super(message, t);
    }

    public Class<?> getExceptionSrcClass() {
        return JwbfException.getClassBy(this.getStackTrace()[0]);
    }

    private static Class<?> getClassBy(StackTraceElement stackTraceElement) {
        String className = stackTraceElement.getClassName();
        return JwbfException.getClassBy(className);
    }

    @VisibleForTesting
    static Class<?> getClassBy(String className) {
        try {
            ClassLoader loader = JwbfException.class.getClassLoader();
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return Object.class;
        }
    }

    private String getModulInfo() {
        Class<?> clazz = this.getExceptionSrcClass();
        return "( " + JWBF.getPartId(clazz) + "-" + JWBF.getVersion(clazz) + " )";
    }

    @Override
    public void printStackTrace(PrintWriter arg0) {
        arg0.println(this.getModulInfo());
        super.printStackTrace(arg0);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        s.println(this.getModulInfo());
        super.printStackTrace(s);
    }
}

