/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.core.contentRep;

import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import net.sourceforge.jwbf.core.bots.WikiBot;
import net.sourceforge.jwbf.core.contentRep.ArticleMeta;
import net.sourceforge.jwbf.core.contentRep.ContentSetable;
import net.sourceforge.jwbf.core.contentRep.SimpleArticle;

public class Article
implements ArticleMeta,
ContentSetable {
    private final WikiBot bot;
    private final SimpleArticle sa;
    private int reload = 0;
    private static final int TEXT_RELOAD = 2;
    private static final int REVISION_ID_RELOAD = 4;
    private static final int MINOR_EDIT_RELOAD = 8;
    private static final int EDITOR_RELOAD = 16;
    private static final int EDIT_SUM_RELOAD = 32;
    private static final int EDIT_DATE_RELOAD = 64;

    @VisibleForTesting
    boolean isReload(int reloadVar) {
        return (this.reload & reloadVar) == 0;
    }

    private void setReload(int reloadVar) {
        this.reload |= reloadVar;
    }

    private void unSetReload(int reloadVar) {
        this.reload = (this.reload | reloadVar) ^ reloadVar;
    }

    @Override
    public String getText() {
        if (this.isReload(2)) {
            this.setReload(2);
            this.setText(this.read().getText());
        }
        return this.sa.getText();
    }

    @Override
    public void setText(String text) {
        this.setReload(2);
        this.sa.setText(text);
    }

    @Override
    public String getRevisionId() {
        if (this.isReload(4)) {
            this.setReload(4);
            this.sa.setRevisionId(this.read().getRevisionId());
        }
        return this.sa.getRevisionId();
    }

    @Override
    public String getEditor() {
        if (this.isReload(16)) {
            this.setReload(16);
            this.setEditor(this.read().getEditor());
        }
        return this.sa.getEditor();
    }

    @Override
    public void setEditor(String editor) {
        this.setReload(16);
        this.sa.setEditor(editor);
    }

    @Override
    public String getEditSummary() {
        if (this.isReload(32)) {
            this.setReload(32);
            this.setEditSummary(this.read().getEditSummary());
        }
        return this.sa.getEditSummary();
    }

    SimpleArticle read() {
        return this.bot.readData(this.sa.getTitle());
    }

    @Override
    public void setEditSummary(String s) {
        this.setReload(32);
        this.sa.setEditSummary(s);
    }

    @Override
    public boolean isMinorEdit() {
        if (this.isReload(8)) {
            this.setReload(8);
            this.setMinorEdit(this.read().isMinorEdit());
        }
        return this.sa.isMinorEdit();
    }

    public Article(WikiBot bot, String title) {
        this.bot = bot;
        this.sa = new SimpleArticle(title);
    }

    public Article(WikiBot bot, SimpleArticle sa) {
        this.sa = sa;
        this.bot = bot;
    }

    @Deprecated
    public Article(WikiBot bot, String text, String title) {
        this.sa = new SimpleArticle(text, title);
        this.bot = bot;
    }

    public void save() {
        this.bot.writeContent(this.sa);
        this.unSetReload(4);
        this.setReload(2);
    }

    public void save(String summary) {
        this.setEditSummary(summary);
        this.save();
    }

    public void clear() {
        this.setText("");
        this.save();
    }

    public void delete() {
        this.bot.delete(this.sa.getTitle());
    }

    @Deprecated
    public boolean isEmpty() {
        return this.getText().length() < 1;
    }

    @Deprecated
    public WikiBot getBot() {
        return this.bot;
    }

    @Override
    public String getTitle() {
        return this.sa.getTitle();
    }

    @Override
    public Date getEditTimestamp() {
        if (this.isReload(64)) {
            this.setReload(64);
            this.sa.setEditTimestamp(this.read().getEditTimestamp());
        }
        return this.sa.getEditTimestamp();
    }

    @Override
    @Deprecated
    public boolean isRedirect() {
        return this.sa.isRedirect();
    }

    @Override
    public void addText(String text) {
        this.setText(this.getText() + text);
    }

    @Override
    public void addTextnl(String text) {
        this.setText(this.getText() + "\n" + text);
    }

    @Override
    public void setMinorEdit(boolean minor) {
        this.sa.setMinorEdit(minor);
    }

    @Override
    public void setTitle(String title) {
        this.sa.setTitle(title);
    }

    public SimpleArticle getSimpleArticle() {
        return this.sa;
    }
}

