/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.core.contentRep;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.sourceforge.jwbf.core.contentRep.Article;
import net.sourceforge.jwbf.core.contentRep.ArticleMeta;
import net.sourceforge.jwbf.core.contentRep.ContentAccessable;
import net.sourceforge.jwbf.core.contentRep.ContentSetable;

public class SimpleArticle
implements ArticleMeta,
Serializable,
ContentSetable {
    private static final long serialVersionUID = -1368796410854055279L;
    private String title = "";
    private String editSummary = "";
    private String text = "";
    private String editor = "";
    private boolean minorEdit = false;
    private long editTimestamp = SimpleArticle.newZeroDate().getTime();
    private String revId = "";
    private static Pattern redirectPattern = Pattern.compile("#(.*)redirect (.*)", 2);

    @VisibleForTesting
    public static Date newZeroDate() {
        return new Date(0L);
    }

    public SimpleArticle() {
    }

    public SimpleArticle(ContentAccessable ca) {
        if (ca instanceof Article) {
            throw new IllegalArgumentException("do not convert an " + Article.class.getCanonicalName() + " to a " + this.getClass().getCanonicalName() + ", because its very expensive");
        }
        this.title = (String)Optional.fromNullable((Object)ca.getTitle()).or((Object)"");
        this.text = (String)Optional.fromNullable((Object)ca.getText()).or((Object)"");
        this.editSummary = (String)Optional.fromNullable((Object)ca.getEditSummary()).or((Object)"");
        this.editor = (String)Optional.fromNullable((Object)ca.getEditor()).or((Object)"");
        this.setMinorEdit(ca.isMinorEdit());
    }

    public SimpleArticle(ArticleMeta sa) {
        this((ContentAccessable)sa);
        if (sa.getEditTimestamp() != null) {
            this.editTimestamp = sa.getEditTimestamp().getTime();
        }
        if (sa.getRevisionId() != null) {
            this.revId = sa.getRevisionId();
        }
    }

    @Deprecated
    public SimpleArticle(String text, String title) {
        this(title);
        this.text = text;
    }

    public SimpleArticle(String title) {
        this.title = title;
    }

    @Override
    public String getEditSummary() {
        return this.editSummary;
    }

    @Override
    public void setEditSummary(String s) {
        this.editSummary = s;
    }

    @Override
    public boolean isMinorEdit() {
        return this.minorEdit;
    }

    @Override
    public void setMinorEdit(boolean minor) {
        this.minorEdit = minor;
    }

    @Deprecated
    public String getLabel() {
        return this.getTitle();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Deprecated
    public void setLabel(String label) {
        this.setTitle(label);
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void addText(String text) {
        this.setText(this.getText() + text);
    }

    @Override
    public void addTextnl(String text) {
        this.setText(this.getText() + "\n" + text);
    }

    @Override
    public String getEditor() {
        return this.editor;
    }

    @Override
    public void setEditor(String editor) {
        this.editor = editor;
    }

    @Override
    @Beta
    public boolean isRedirect() {
        return redirectPattern.matcher(this.text).matches();
    }

    @Override
    public Date getEditTimestamp() {
        return new Date(this.editTimestamp);
    }

    public void setEditTimestamp(String editTimestamp) {
        Date parsedDate = this.tryParse(editTimestamp);
        this.setEditTimestamp(parsedDate);
    }

    private Date tryParse(String editTimestamp) {
        Optional<Date> parsedDate = this.tryParse(editTimestamp, "yyyy-MM-dd'T'HH:mm:ss'Z'");
        return (Date)parsedDate.or(this.tryParse(editTimestamp, "MM/dd/yy' 'HH:mm:ss")).get();
    }

    private Optional<Date> tryParse(String editTimestamp, String datePattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
        try {
            return Optional.of((Object)sdf.parse(editTimestamp));
        }
        catch (ParseException e) {
            return Optional.absent();
        }
    }

    public void setEditTimestamp(@Nullable Date d) {
        if (d != null) {
            this.editTimestamp = d.getTime();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleArticle) {
            SimpleArticle that = (SimpleArticle)obj;
            return Objects.equals(this.editTimestamp, that.editTimestamp) && Objects.equals(this.revId, that.revId) && Objects.equals(this.text, that.text) && Objects.equals(this.title, that.title);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.editTimestamp, this.revId, this.text, this.title);
    }

    @Override
    public String getRevisionId() {
        return this.revId;
    }

    public void setRevisionId(String revId) {
        this.revId = revId;
    }
}

