/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.sourceforge.jwbf.core.internal.Checked;

public class JsonMapper {
    private final ToJsonFunction transfomer;

    public JsonMapper() {
        this(new JacksonToJsonFunction());
    }

    public <T> JsonMapper(ToJsonFunction transfomer) {
        this.transfomer = transfomer;
    }

    public <T> T get(String json, Class<T> clazz) {
        String nonNullJson = Checked.nonNull(json, "json");
        return (T)Checked.nonNull(this.transfomer.toJson(nonNullJson, clazz), "a json mapping result");
    }

    static class JacksonToJsonFunction
    implements ToJsonFunction {
        JacksonToJsonFunction() {
        }

        ObjectMapper newObjectMapper() {
            return new ObjectMapper();
        }

        @Override
        @Nonnull
        public Object toJson(@Nonnull String jsonString, Class<?> clazz) {
            try {
                return this.newObjectMapper().readValue(jsonString, clazz);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static interface ToJsonFunction {
        @Nonnull
        public Object toJson(@Nonnull String var1, Class<?> var2);
    }
}

