/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mapper;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sourceforge.jwbf.core.Optionals;
import net.sourceforge.jwbf.core.actions.util.ActionException;
import net.sourceforge.jwbf.core.internal.NonnullFunction;
import net.sourceforge.jwbf.mapper.XmlElement;
import net.sourceforge.jwbf.mediawiki.MediaWiki;
import net.sourceforge.jwbf.mediawiki.actions.util.ApiException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public final class XmlConverter {
    private static final Logger log = LoggerFactory.getLogger(XmlConverter.class);

    private XmlConverter() {
    }

    public static Function<XmlElement, ApiException> toApiException() {
        return new NonnullFunction<XmlElement, ApiException>(){

            @Override
            @Nonnull
            public ApiException applyNonnull(@Nonnull XmlElement xmlElement) {
                String qualifiedName = xmlElement.getQualifiedName();
                if (qualifiedName != null && qualifiedName.equals("error")) {
                    String code = xmlElement.getAttributeValue("code");
                    String info = xmlElement.getAttributeValue("info");
                    return new ApiException(code, info);
                }
                throw new IllegalArgumentException("only errors can be mapped to an exception");
            }
        };
    }

    @Nonnull
    public static XmlElement getRootElementWithError(String xml) {
        return Optionals.getOrThrow(XmlConverter.getRootElementWithErrorOpt(xml), "Invalid XML: " + xml);
    }

    static Optional<XmlElement> getRootElementWithErrorOpt(String xml) {
        String xmlTrimmedInCauseOfMediawikiProblem = xml.trim();
        Optional<String> xmlStringOpt = Optionals.absentIfEmpty(xmlTrimmedInCauseOfMediawikiProblem);
        if (xmlStringOpt.isPresent()) {
            Element root;
            SAXBuilder builder = new SAXBuilder();
            try {
                byte[] bytes = xmlTrimmedInCauseOfMediawikiProblem.getBytes(Charsets.UTF_8);
                Document doc = builder.build((InputStream)new ByteArrayInputStream(bytes));
                root = doc.getRootElement();
            }
            catch (JDOMException e) {
                log.error(xml);
                return Optional.absent();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            if (root == null) {
                throw new ActionException("no root element found");
            }
            return Optional.of((Object)new XmlElement(root));
        }
        return Optional.absent();
    }

    static Optional<XmlElement> getErrorElement(XmlElement rootXmlElement) {
        Optional<XmlElement> elem = rootXmlElement.getChildOpt("error");
        if (elem.isPresent()) {
            ApiException error = (ApiException)elem.transform(XmlConverter.toApiException()).get();
            log.error(error.getCode() + ": " + error.getValue());
        }
        return elem;
    }

    @Nonnull
    public static XmlElement getRootElement(String xml) {
        Optional<XmlElement> rootXmlElement = XmlConverter.getRootElementWithErrorOpt(xml);
        if (!rootXmlElement.isPresent()) {
            throw new IllegalArgumentException("\"" + xml + "\" is no valid xml");
        }
        Optional apiException = XmlConverter.getErrorElement((XmlElement)rootXmlElement.get()).transform(XmlConverter.toApiException());
        if (apiException.isPresent()) {
            throw (ApiException)apiException.get();
        }
        return (XmlElement)rootXmlElement.get();
    }

    public static String evaluateXpath(String xml, String xpath) {
        XPath parser = XPathFactory.newInstance().newXPath();
        try {
            XPathExpression titleParser = parser.compile(xpath);
            ByteArrayInputStream byteStream = new ByteArrayInputStream(xml.getBytes(MediaWiki.getCharset()));
            InputSource in = new InputSource(byteStream);
            return titleParser.evaluate(in);
        }
        catch (UnsupportedEncodingException | XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Optional<XmlElement> getChildOpt(String xml, String first, String ... childNames) {
        XmlElement child = XmlConverter.getChild(xml, first, childNames);
        if (XmlElement.NULL_XML == child) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)child);
    }

    @CheckForNull
    static XmlElement getChild(String xml, String first, String ... childNames) {
        if (first == null) {
            return null;
        }
        ImmutableList names = ImmutableList.builder().add((Object)first).addAll((Iterable)ImmutableList.copyOf((Object[])childNames)).build();
        XmlElement rootElement = XmlConverter.getRootElement(xml);
        return XmlConverter.getChild(rootElement, (ImmutableList<String>)names);
    }

    @CheckForNull
    private static XmlElement getChild(XmlElement element, ImmutableList<String> names) {
        if (element == null) {
            return null;
        }
        if (names.isEmpty()) {
            return element;
        }
        ImmutableList withoutFirst = names.subList(1, names.size());
        XmlElement child = element.getChild((String)Iterables.getFirst(names, null));
        return XmlConverter.getChild(child, (ImmutableList<String>)withoutFirst);
    }

    public static void failOnError(String xml) {
        XmlConverter.getChecked(xml).getClass();
    }

    public static XmlElement getChecked(String xml) {
        XmlElement root = XmlConverter.getRootElementWithError(xml);
        Optional error = root.getErrorElement().transform(XmlConverter.toApiException());
        if (error.isPresent()) {
            throw (ApiException)error.get();
        }
        return root;
    }
}

