/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwbf.mapper;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.sourceforge.jwbf.core.internal.Checked;
import net.sourceforge.jwbf.mapper.XmlConverter;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class XmlElement {
    public static final XmlElement NULL_XML = new XmlElement(null);
    private final Optional<Element> element;
    private static final Function<Element, XmlElement> TO_ELEMENT = new Function<Element, XmlElement>(){

        public XmlElement apply(@Nullable Element input) {
            if (input == null) {
                return null;
            }
            return new XmlElement(input);
        }
    };

    XmlElement(Element element) {
        this.element = Optional.fromNullable((Object)element);
    }

    @CheckForNull
    public String getQualifiedName() {
        if (this.element.isPresent()) {
            return ((Element)this.element.get()).getQualifiedName();
        }
        return null;
    }

    @CheckForNull
    public String getAttributeValue(String name) {
        if (this.element.isPresent()) {
            return ((Element)this.element.get()).getAttributeValue(name);
        }
        return null;
    }

    public Optional<String> getAttributeValueOpt(String name) {
        return Optional.fromNullable((Object)this.getAttributeValue(name));
    }

    public String getAttributeValueNonNull(String name) {
        return Checked.nonNull(this.getAttributeValue(name), "attribute value for key: " + name);
    }

    @Deprecated
    @CheckForNull
    public String getChildAttributeValue(String childName, String attributeName) {
        XmlElement child = this.getChild(childName);
        if (child == NULL_XML) {
            return null;
        }
        return child.getAttributeValue(attributeName);
    }

    public Optional<XmlElement> getChildOpt(String name) {
        XmlElement child = this.getChild(name);
        if (child == NULL_XML) {
            return Optional.absent();
        }
        return Optional.of((Object)child);
    }

    public XmlElement getChild(String name) {
        if (this.element.isPresent()) {
            Element child = ((Element)this.element.get()).getChild(name);
            if (child == null) {
                return NULL_XML;
            }
            return new XmlElement(child);
        }
        return NULL_XML;
    }

    private ImmutableList<XmlElement> toElements(List<Element> list) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(list, TO_ELEMENT));
    }

    public List<XmlElement> getChildren() {
        if (this.element.isPresent()) {
            return this.toElements(((Element)this.element.get()).getChildren());
        }
        return ImmutableList.of();
    }

    public List<XmlElement> getChildren(String name) {
        if (this.element.isPresent()) {
            return this.toElements(((Element)this.element.get()).getChildren(name));
        }
        return ImmutableList.of();
    }

    public boolean hasAttribute(String name) {
        if (this.element.isPresent()) {
            Attribute attribute = ((Element)this.element.get()).getAttribute(name);
            return attribute != null;
        }
        return false;
    }

    @CheckForNull
    public String getText() {
        if (this.element.isPresent()) {
            return ((Element)this.element.get()).getText();
        }
        return null;
    }

    public Optional<XmlElement> getErrorElement() {
        return XmlConverter.getErrorElement(this);
    }
}

